/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import workbench.interfaces.PropertyStorage;
import workbench.resource.Settings;
import workbench.util.CharacterRange;
import workbench.util.EncodingUtil;
import workbench.util.FileUtil;
import workbench.util.StringUtil;

public class WbProperties
extends Properties
implements PropertyStorage {
    private static final long serialVersionUID = 1L;
    private int distinctSections;
    private final Map<String, List<PropertyChangeListener>> changeListeners = new HashMap<String, List<PropertyChangeListener>>();
    private final Map<String, String> comments = new HashMap<String, String>();
    private Object changeNotificationSource = null;
    private boolean changed = false;
    private Comparator<String> sortComparator = null;

    protected WbProperties() {
        this(null, 2);
    }

    public WbProperties(int n) {
        this(null, n);
    }

    public WbProperties(Object object) {
        this(object, 2);
    }

    public WbProperties(Object object, int n) {
        this.changeNotificationSource = object == null ? this : object;
        this.distinctSections = n;
    }

    public boolean isModified() {
        return this.changed;
    }

    public synchronized void saveToFile(File file) throws IOException {
        this.saveToFile(file, null);
    }

    public synchronized void saveToFile(File file, WbProperties wbProperties) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            this.save((OutputStream)fileOutputStream, wbProperties);
        }
    }

    public synchronized void save(OutputStream outputStream) throws IOException {
        this.save(outputStream, (WbProperties)null);
    }

    public void setSortComparator(Comparator<String> comparator) {
        this.sortComparator = comparator;
    }

    public synchronized void save(OutputStream outputStream, WbProperties wbProperties) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(this.getKeys());
        if (this.sortComparator == null) {
            Collections.sort(arrayList);
        } else {
            arrayList.sort(this.sortComparator);
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        String string = null;
        String string2 = null;
        boolean bl = false;
        for (Object e : arrayList) {
            String string3;
            String string4;
            String string5;
            string2 = (String)e;
            if (wbProperties != null && wbProperties.size() > 0 && StringUtil.equalStringOrEmpty(string5 = this.getProperty(string2), string4 = wbProperties.getProperty(string2))) continue;
            string5 = this.comments.get(string2);
            if (StringUtil.isNonBlank(string5)) {
                if (!bl) {
                    bufferedWriter.newLine();
                }
                bufferedWriter.write(string5);
                bufferedWriter.newLine();
            }
            if (string != null && this.distinctSections > 0) {
                string4 = null;
                string3 = null;
                string4 = this.getSections(string, this.distinctSections);
                if (!string4.equals(string3 = this.getSections(string2, this.distinctSections)) && StringUtil.isBlank(string5)) {
                    bufferedWriter.newLine();
                }
            }
            if ((string3 = this.getProperty(string2)) != null) {
                string3 = string3.replace("\n", "_$wb$nl$_");
                string3 = StringUtil.escapeText(string3, CharacterRange.RANGE_7BIT);
                if ((string3 = string3.replace("_$wb$nl$_", "\\\n")).length() > 0) {
                    bufferedWriter.write(string2 + "=" + string3);
                    bufferedWriter.newLine();
                } else {
                    bufferedWriter.write(string2 + "=");
                    bufferedWriter.newLine();
                }
            } else {
                bufferedWriter.write(string2 + "=");
                bufferedWriter.newLine();
            }
            if (StringUtil.isBlank(string5)) {
                bl = false;
            } else {
                bufferedWriter.newLine();
                bl = true;
            }
            string = string2;
        }
        bufferedWriter.flush();
        this.changed = false;
    }

    @Override
    public int getIntProperty(String string, int n) {
        String string2 = this.getProperty(string, null);
        if (string2 == null) {
            return n;
        }
        return StringUtil.getIntValue(string2, n);
    }

    @Override
    public boolean getBoolProperty(String string, boolean bl) {
        String string2 = this.getProperty(string, null);
        if (string2 == null) {
            return bl;
        }
        return Boolean.valueOf(string2);
    }

    @Override
    public void setProperty(String string, int n) {
        this.setProperty(string, Integer.toString(n));
    }

    @Override
    public void setProperty(String string, boolean bl) {
        this.setProperty(string, Boolean.toString(bl));
    }

    private String getSections(String string, int n) {
        int n2 = string.indexOf(46);
        if (n2 < 0) {
            return string;
        }
        String string2 = null;
        for (int i = 1; i < n; ++i) {
            int n3 = string.indexOf(46, n2 + 1);
            if (n3 > -1) {
                n2 = n3;
                continue;
            }
            if (i != n - 1) continue;
            n2 = string.length();
        }
        string2 = string.substring(0, n2);
        return string2;
    }

    @Override
    public void removeProperty(String string) {
        String string2 = this.getProperty(string, null);
        super.remove(string);
        this.firePropertyChanged(string, string2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener, String ... stringArray) {
        if (propertyChangeListener == null) {
            return;
        }
        Map<String, List<PropertyChangeListener>> map = this.changeListeners;
        synchronized (map) {
            for (String string : stringArray) {
                List<PropertyChangeListener> list = this.changeListeners.get(string);
                if (list == null) {
                    list = new ArrayList<PropertyChangeListener>();
                    this.changeListeners.put(string, list);
                }
                list.add(propertyChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Map<String, List<PropertyChangeListener>> map = this.changeListeners;
        synchronized (map) {
            for (List<PropertyChangeListener> list : this.changeListeners.values()) {
                if (list == null) continue;
                list.remove(propertyChangeListener);
            }
        }
    }

    private void firePropertyChanged(String string, String string2, String string3) {
        this.changed = true;
        List<PropertyChangeListener> list = this.changeListeners.get(string);
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList<PropertyChangeListener> arrayList = new ArrayList<PropertyChangeListener>(list);
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.changeNotificationSource, string, string2, string3);
        for (PropertyChangeListener propertyChangeListener : arrayList) {
            if (propertyChangeListener == null) continue;
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    @Override
    public Set<String> getKeys() {
        return super.stringPropertyNames();
    }

    @Override
    public List<String> getKeysWithPrefix(String string) {
        if (string == null) {
            return new ArrayList<String>(this.getKeys());
        }
        Set<String> set = this.getKeys();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : set) {
            if (!string2.startsWith(string)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    @Override
    public Object setProperty(String string, String string2) {
        return this.setProperty(string, string2, true);
    }

    public void setTemporaryProperty(String string, String string2) {
        String string3 = System.getProperty(string, this.getProperty(string));
        if (!StringUtil.equalStringOrEmpty(string3, string2)) {
            System.setProperty(string, string2);
            this.firePropertyChanged(string, string3, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setProperty(String string, String string2, boolean bl) {
        if (string == null) {
            return null;
        }
        String string3 = null;
        WbProperties wbProperties = this;
        synchronized (wbProperties) {
            string3 = string2 == null ? (String)super.remove(string) : (String)super.setProperty(string, string2);
        }
        if (bl && StringUtil.stringsAreNotEqual(string3, string2)) {
            this.firePropertyChanged(string, string3, string2);
        }
        return string3;
    }

    public void clearComments() {
        this.comments.clear();
    }

    public String getComment(String string) {
        return this.comments.get(string);
    }

    public void setComment(String string, String string2) {
        this.comments.put(string, string2);
    }

    public void addPropertyDefinition(String string) {
        this.addPropertyDefinition(string, null);
    }

    public void addPropertyDefinition(String string, String string2) {
        if (string == null) {
            return;
        }
        if (string.charAt(0) == '#') {
            return;
        }
        int n = string.indexOf(61);
        if (n == -1) {
            return;
        }
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1);
        this.setProperty(string3, string4);
        this.comments.put(string3, string2);
    }

    public void loadTextFile(File file) throws IOException {
        this.loadTextFile(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTextFile(File file, String string) throws IOException {
        BufferedReader bufferedReader = null;
        if (string == null) {
            string = Settings.getInstance().getDefaultEncoding();
        }
        try {
            bufferedReader = EncodingUtil.createBufferedReader(file, string);
            this.loadFromReader(bufferedReader);
        }
        finally {
            FileUtil.closeQuietely(bufferedReader);
        }
    }

    public void loadFromStream(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        this.loadFromReader(bufferedReader);
    }

    public void loadFromReader(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        String string2 = null;
        String string3 = null;
        while (string != null) {
            if (StringUtil.isBlank(string)) {
                string2 = null;
            }
            if (string.trim().startsWith("#") && !string.trim().startsWith("#!")) {
                string2 = string2 == null ? string : string2 + "\n" + string;
            } else if (string.trim().endsWith("\\")) {
                string = string.substring(0, string.lastIndexOf(92));
                string3 = string3 == null ? string : string3 + "\n" + string;
            } else {
                if (string3 != null) {
                    if (StringUtil.isNonBlank(string3 = string3 + "\n" + string)) {
                        this.addPropertyDefinition(StringUtil.decodeUnicode(string3.trim()), string2);
                    }
                    string3 = null;
                } else if (StringUtil.isNonBlank(string)) {
                    this.addPropertyDefinition(StringUtil.decodeUnicode(string.trim()), string2);
                }
                string2 = null;
            }
            string = bufferedReader.readLine();
        }
        this.changed = false;
    }

    public static Properties createCopy(Properties properties) {
        if (properties == null) {
            return null;
        }
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        return properties2;
    }
}

