/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import workbench.gui.sql.PanelType;
import workbench.gui.sql.SqlHistory;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.CharacterRange;
import workbench.util.CollectionUtil;
import workbench.util.FileUtil;
import workbench.util.StringUtil;
import workbench.util.WbFile;
import workbench.util.WbProperties;

public class WbWorkspace
implements Closeable {
    public static final String TAB_PROP_PREFIX = "tab";
    private static final String VARIABLES_FILENAME = "variables.properties";
    private static final String TABINFO_FILENAME = "tabs.properties";
    private static final String TOOL_ENTRY_PREFIX = "toolprop_";
    private static final String CURSOR_POS_PROP = ".file.cursorpos";
    private static final String ENCODING_PROP = ".encoding";
    private static final String FILENAME_PROP = ".filename";
    private ZipOutputStream zout;
    private ZipFile archive;
    private WorkspaceState state = WorkspaceState.closed;
    private int tabCount = -1;
    private WbProperties tabInfo = new WbProperties(0);
    private Map<String, WbProperties> toolProperties = new HashMap<String, WbProperties>();
    private WbProperties variables = new WbProperties(0);
    private Map<Integer, SqlHistory> historyEntries = new HashMap<Integer, SqlHistory>();
    private String filename;
    private String loadError;

    public WbWorkspace(String string) {
        if (string == null) {
            throw new NullPointerException("Filename cannot be null");
        }
        this.filename = string;
    }

    public void openForWriting() throws IOException {
        this.close();
        BufferedOutputStream bufferedOutputStream = null;
        try {
            File file = new File(this.filename);
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), 65536);
            this.zout = new ZipOutputStream(bufferedOutputStream);
            this.zout.setLevel(Settings.getInstance().getIntProperty("workbench.workspace.compression", 9));
            this.zout.setComment("SQL Workbench/J Workspace file");
            this.state = WorkspaceState.writing;
        }
        catch (Exception exception) {
            if (this.zout == null) {
                FileUtil.closeQuietely(bufferedOutputStream);
            } else {
                FileUtil.closeQuietely(this.zout);
            }
            this.state = WorkspaceState.closed;
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException("Could not open ZIP file", exception);
        }
    }

    public String getLoadError() {
        return this.loadError;
    }

    public boolean isOpenForReading() {
        return this.state == WorkspaceState.reading;
    }

    public boolean isOpen() {
        return this.state != WorkspaceState.closed;
    }

    public boolean openForReading() throws IOException {
        this.close();
        this.clear();
        this.loadError = null;
        try {
            long l;
            this.zout = null;
            this.archive = new ZipFile(this.filename);
            ZipEntry zipEntry = this.archive.getEntry(TABINFO_FILENAME);
            long l2 = l = zipEntry != null ? zipEntry.getSize() : 0L;
            if (l <= 0L) {
                zipEntry = this.archive.getEntry("tabinfo.properties");
            }
            this.readTabInfo(zipEntry);
            this.readToolProperties();
            this.readVariables();
            this.tabCount = this.calculateTabCount();
            this.state = WorkspaceState.reading;
            return true;
        }
        catch (Throwable throwable) {
            FileUtil.closeQuietely(this.archive);
            LogMgr.logDebug(new CallerInfo(){}, "Could not open workspace file " + this.filename, throwable);
            this.loadError = throwable.getMessage();
            this.state = WorkspaceState.closed;
            return false;
        }
    }

    public void setFilename(String string) {
        if (string == null) {
            throw new NullPointerException("Filename cannot be null");
        }
        if (this.state != WorkspaceState.closed) {
            LogMgr.logError(new CallerInfo(){}, "setFilename() called although workspace is not closed!", new Exception("Backtrace"));
        }
        this.filename = string;
    }

    public String getFilename() {
        return this.filename;
    }

    public Map<String, WbProperties> getToolProperties() {
        return this.toolProperties;
    }

    public void setEntryCount(int n) {
        this.tabInfo.setProperty("tab.total.count", n);
    }

    public void addHistoryEntry(int n, SqlHistory sqlHistory) {
        this.historyEntries.put(n, sqlHistory);
    }

    public WbProperties getVariables() {
        WbProperties wbProperties = new WbProperties(0);
        wbProperties.putAll((Map<?, ?>)this.variables);
        return wbProperties;
    }

    public void setVariables(Properties properties) {
        this.variables.clear();
        if (properties != null) {
            this.variables.putAll((Map<?, ?>)properties);
        }
    }

    public int getEntryCount() {
        if (this.state != WorkspaceState.reading) {
            return -1;
        }
        return this.tabCount;
    }

    public PanelType getPanelType(int n) {
        String string = this.tabInfo.getProperty(TAB_PROP_PREFIX + n + ".type", "sqlPanel");
        try {
            return PanelType.valueOf(string);
        }
        catch (Exception exception) {
            return PanelType.sqlPanel;
        }
    }

    public void readHistoryData(int n, SqlHistory sqlHistory) throws IOException {
        if (this.state != WorkspaceState.reading) {
            throw new IllegalStateException("Workspace is not open for reading. Entry count is not available");
        }
        ZipEntry zipEntry = this.archive.getEntry("WbStatements" + (n + 1) + ".txt");
        if (zipEntry != null) {
            InputStream inputStream = this.archive.getInputStream(zipEntry);
            sqlHistory.readFromStream(inputStream);
        }
    }

    public void flush() {
        if (this.zout != null) {
            try {
                this.zout.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void save() throws IOException {
        if (this.zout != null) {
            this.saveTabInfo();
            this.saveToolProperties();
            this.saveVariables();
            this.saveHistory();
            this.historyEntries.clear();
        }
    }

    @Override
    public void close() {
        FileUtil.closeQuietely(this.zout);
        FileUtil.closeQuietely(this.archive);
        this.zout = null;
        this.archive = null;
        this.state = WorkspaceState.closed;
    }

    public WbProperties getSettings() {
        return this.tabInfo;
    }

    public void prepareForSaving() {
        this.tabInfo.clear();
        this.historyEntries.clear();
    }

    private void clear() {
        this.toolProperties.clear();
        this.variables.clear();
        this.tabInfo.clear();
        this.historyEntries.clear();
    }

    private void readVariables() {
        if (this.archive == null) {
            return;
        }
        this.variables.clear();
        try {
            ZipEntry zipEntry = this.archive.getEntry(VARIABLES_FILENAME);
            if (zipEntry != null && zipEntry.getSize() > 0L) {
                InputStream inputStream = this.archive.getInputStream(zipEntry);
                this.variables.load(inputStream);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not read variables file", exception);
        }
    }

    private void readToolProperties() {
        this.toolProperties.clear();
        Enumeration<? extends ZipEntry> enumeration = this.archive.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            if (!string.startsWith(TOOL_ENTRY_PREFIX)) continue;
            WbFile wbFile = new WbFile(string.substring(TOOL_ENTRY_PREFIX.length()));
            String string2 = wbFile.getFileName();
            WbProperties wbProperties = this.readProperties(zipEntry);
            this.toolProperties.put(string2, wbProperties);
        }
    }

    private int calculateTabCount() {
        int n = this.tabInfo.getIntProperty("tab.total.count", -1);
        if (n > 0) {
            return n;
        }
        boolean bl = true;
        int n2 = 0;
        while (bl) {
            if (this.tabInfo.containsKey(TAB_PROP_PREFIX + n2 + ".maxrows") || this.tabInfo.containsKey(TAB_PROP_PREFIX + n2 + ".title") || this.tabInfo.containsKey(TAB_PROP_PREFIX + n2 + ".append.results")) {
                this.tabInfo.setProperty(TAB_PROP_PREFIX + n2 + ".type", PanelType.sqlPanel.toString());
                ++n2;
                continue;
            }
            if (this.tabInfo.containsKey(TAB_PROP_PREFIX + n2 + ".type")) {
                ++n2;
                continue;
            }
            bl = false;
        }
        int n3 = this.tabInfo.getIntProperty("dbexplorer.visible", 0);
        for (int i = 0; i < n3; ++i) {
            this.tabInfo.setProperty(TAB_PROP_PREFIX + n2 + ".type", PanelType.dbExplorer.toString());
            ++n2;
        }
        return n2;
    }

    private void saveVariables() throws IOException {
        if (CollectionUtil.isEmpty(this.variables)) {
            return;
        }
        try {
            ZipEntry zipEntry = new ZipEntry(VARIABLES_FILENAME);
            this.zout.putNextEntry(zipEntry);
            this.variables.save(this.zout);
        }
        catch (IOException iOException) {
            LogMgr.logError(new CallerInfo(){}, "Could not write variables", iOException);
            throw iOException;
        }
        finally {
            this.zout.closeEntry();
        }
    }

    private void saveToolProperties() throws IOException {
        if (CollectionUtil.isEmpty(this.toolProperties)) {
            return;
        }
        try {
            for (Map.Entry<String, WbProperties> entry : this.toolProperties.entrySet()) {
                ZipEntry zipEntry = new ZipEntry(TOOL_ENTRY_PREFIX + entry.getKey() + ".properties");
                this.zout.putNextEntry(zipEntry);
                entry.getValue().save(this.zout);
            }
        }
        catch (IOException iOException) {
            LogMgr.logError(new CallerInfo(){}, "Could not write variables", iOException);
            throw iOException;
        }
        finally {
            this.zout.closeEntry();
        }
    }

    private void saveHistory() throws IOException {
        for (Map.Entry<Integer, SqlHistory> entry : this.historyEntries.entrySet()) {
            if (entry.getValue() == null || entry.getKey() == null) continue;
            try {
                int n = entry.getKey();
                ZipEntry zipEntry = new ZipEntry("WbStatements" + (n + 1) + ".txt");
                this.zout.putNextEntry(zipEntry);
                entry.getValue().writeToStream(this.zout);
            }
            catch (IOException iOException) {
                LogMgr.logError(new CallerInfo(){}, "Could not history for tab index: " + entry.getKey(), iOException);
                throw iOException;
            }
            finally {
                this.zout.closeEntry();
            }
        }
    }

    private void saveTabInfo() throws IOException {
        if (CollectionUtil.isEmpty(this.tabInfo)) {
            return;
        }
        try {
            ZipEntry zipEntry = new ZipEntry(TABINFO_FILENAME);
            this.zout.putNextEntry(zipEntry);
            this.tabInfo.save(this.zout);
        }
        catch (IOException iOException) {
            LogMgr.logError(new CallerInfo(){}, "Could not write variables", iOException);
            throw iOException;
        }
        finally {
            this.zout.closeEntry();
        }
    }

    private void readTabInfo(ZipEntry zipEntry) {
        this.tabInfo = this.readProperties(zipEntry);
    }

    private WbProperties readProperties(ZipEntry zipEntry) {
        WbProperties wbProperties = new WbProperties(null, 1);
        if (zipEntry == null) {
            return wbProperties;
        }
        try {
            InputStream inputStream = this.archive.getInputStream(zipEntry);
            wbProperties.load(inputStream);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not read property file: " + zipEntry.getName(), exception);
        }
        return wbProperties;
    }

    public void setSelectedTab(int n) {
        this.tabInfo.setProperty("tab.selected", Integer.toString(n));
    }

    public int getSelectedTab() {
        return StringUtil.getIntValue(this.tabInfo.getProperty("tab.selected", "0"));
    }

    public boolean isSelectedTabExplorer() {
        int n = this.getSelectedTab();
        return PanelType.dbExplorer == this.getPanelType(n);
    }

    public void setTabTitle(int n, String string) {
        String string2 = TAB_PROP_PREFIX + n + ".title";
        String string3 = StringUtil.escapeText(string, CharacterRange.RANGE_7BIT);
        this.tabInfo.setProperty(string2, string3);
    }

    public String getTabTitle(int n) {
        if (this.tabInfo == null) {
            return null;
        }
        String string = TAB_PROP_PREFIX + n + ".title";
        String string2 = (String)this.tabInfo.get(string);
        return StringUtil.decodeUnicode(string2);
    }

    public int getExternalFileCursorPos(int n) {
        if (this.tabInfo == null) {
            return -1;
        }
        String string = TAB_PROP_PREFIX + n + CURSOR_POS_PROP;
        String string2 = (String)this.tabInfo.get(string);
        if (string2 == null) {
            return -1;
        }
        int n2 = -1;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            n2 = -1;
        }
        return n2;
    }

    public void setQueryTimeout(int n, int n2) {
        String string = TAB_PROP_PREFIX + n + ".timeout";
        this.tabInfo.setProperty(string, Integer.toString(n2));
    }

    public int getQueryTimeout(int n) {
        if (this.tabInfo == null) {
            return 0;
        }
        String string = TAB_PROP_PREFIX + n + ".timeout";
        String string2 = (String)this.tabInfo.get(string);
        if (string2 == null) {
            return 0;
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            n2 = 0;
        }
        return n2;
    }

    public void setMaxRows(int n, int n2) {
        String string = TAB_PROP_PREFIX + n + ".maxrows";
        this.tabInfo.setProperty(string, Integer.toString(n2));
    }

    public int getMaxRows(int n) {
        if (this.tabInfo == null) {
            return 0;
        }
        String string = TAB_PROP_PREFIX + n + ".maxrows";
        String string2 = (String)this.tabInfo.get(string);
        if (string2 == null) {
            return 0;
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            n2 = 0;
        }
        return n2;
    }

    public String getExternalFileName(int n) {
        if (this.tabInfo == null) {
            return null;
        }
        String string = TAB_PROP_PREFIX + n + FILENAME_PROP;
        String string2 = (String)this.tabInfo.get(string);
        return StringUtil.decodeUnicode(string2);
    }

    public String getExternalFileEncoding(int n) {
        if (this.tabInfo == null) {
            return null;
        }
        String string = TAB_PROP_PREFIX + n + ENCODING_PROP;
        String string2 = (String)this.tabInfo.get(string);
        if (StringUtil.isEmptyString(string2)) {
            return Settings.getInstance().getDefaultEncoding();
        }
        return string2;
    }

    public void setExternalFileCursorPos(int n, int n2) {
        String string = TAB_PROP_PREFIX + n + CURSOR_POS_PROP;
        this.tabInfo.setProperty(string, Integer.toString(n2));
    }

    public void setExternalFileName(int n, String string) {
        String string2 = TAB_PROP_PREFIX + n + FILENAME_PROP;
        String string3 = StringUtil.escapeText(string, CharacterRange.RANGE_7BIT);
        this.tabInfo.setProperty(string2, string3);
    }

    public void setExternalFileEncoding(int n, String string) {
        if (string == null) {
            return;
        }
        String string2 = TAB_PROP_PREFIX + n + ENCODING_PROP;
        this.tabInfo.setProperty(string2, string);
    }

    public String toString() {
        return this.filename;
    }

    private static enum WorkspaceState {
        closed,
        reading,
        writing;

    }
}

