/*
 * Decompiled with CFR 0.152.
 */
package workbench.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import workbench.db.WbConnection;
import workbench.util.StringUtil;
import workbench.util.WbProperties;

public class WorkspaceConnectionVariables {
    public static final String VAR_DB_USER = "${db.user}";
    public static final String VAR_DB_URL = "${db.url}";
    public static final String VAR_DB_SCHEMA = "${db.schema}";
    public static final String VAR_DB_CATALOG = "${db.catalog}";
    private final Map<String, String> sysVars = new HashMap<String, String>();

    public WorkspaceConnectionVariables(WbConnection wbConnection) {
        if (wbConnection != null) {
            this.sysVars.put(VAR_DB_URL, wbConnection.getUrl());
            this.sysVars.put(VAR_DB_USER, wbConnection.getCurrentUser());
            this.sysVars.put(VAR_DB_SCHEMA, wbConnection.getCurrentSchema());
            this.sysVars.put(VAR_DB_CATALOG, wbConnection.getCurrentCatalog());
        }
    }

    public Map<String, String> getVariables() {
        return Collections.unmodifiableMap(this.sysVars);
    }

    public void replaceVariableValues(WbProperties wbProperties) {
        if (wbProperties == null) {
            return;
        }
        for (String string : wbProperties.getKeys()) {
            String string2 = wbProperties.getProperty(string);
            String string3 = StringUtil.replaceProperties(this.sysVars, string2);
            wbProperties.setProperty(string, string3);
        }
    }
}

