/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.provider.z3950;

import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Logger;
import org.apache.commons.beanutils.BeanUtils;
import org.jzkit.a2j.codec.util.OIDRegister;
import org.jzkit.a2j.gen.AsnUseful.EXTERNAL_type;
import org.jzkit.search.provider.iface.IREvent;
import org.jzkit.search.provider.z3950.PresentCallbackHandler;
import org.jzkit.search.provider.z3950.Z3950Origin;
import org.jzkit.search.provider.z3950.ZCallbackTarget;
import org.jzkit.search.util.RecordModel.ArchetypeRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.ExplicitRecordFormatSpecification;
import org.jzkit.search.util.RecordModel.FormatProperty;
import org.jzkit.search.util.RecordModel.HTMLRecord;
import org.jzkit.search.util.RecordModel.IndirectFormatProperty;
import org.jzkit.search.util.RecordModel.InformationFragment;
import org.jzkit.search.util.RecordModel.RecordFormatSpecification;
import org.jzkit.search.util.RecordModel.SGMLRecord;
import org.jzkit.search.util.RecordModel.SUTRS;
import org.jzkit.search.util.RecordModel.SurrogateDiagnostic;
import org.jzkit.search.util.RecordModel.UnknownBlob;
import org.jzkit.search.util.RecordModel.XMLRecord;
import org.jzkit.search.util.RecordModel.iso2709;
import org.jzkit.search.util.ResultSet.AbstractIRResultSet;
import org.jzkit.search.util.ResultSet.AsynchronousEnumeration;
import org.jzkit.search.util.ResultSet.IFSNotificationTarget;
import org.jzkit.search.util.ResultSet.IRResultSet;
import org.jzkit.search.util.ResultSet.IRResultSetException;
import org.jzkit.search.util.ResultSet.IRResultSetInfo;
import org.jzkit.search.util.ResultSet.ReadAheadEnumeration;
import org.jzkit.util.FormatSpecOIDHelper;
import org.jzkit.z3950.RecordModel.ExplainRecord;
import org.jzkit.z3950.RecordModel.GRS1;
import org.jzkit.z3950.RecordModel.OpacRecord;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.DefaultDiagFormat_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.DiagRec_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.NamePlusRecord_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.PresentResponse_type;
import org.jzkit.z3950.gen.v3.Z39_50_APDU_1995.Records_type;

public class Z3950SearchTask
extends AbstractIRResultSet
implements IRResultSet {
    public static final int ZSTATUS_NONE = 0;
    public static final int ZSTATUS_IDLE = 1;
    public static final int ZSTATUS_SEARCHING = 2;
    public static final int ZSTATUS_SEARCH_COMPLETE = 3;
    public static final int ZSTATUS_PRESENTING = 4;
    public static final int ZSTATUS_ALL_PRESENTED = 5;
    public static final int ZSTATUS_SORTING = 6;
    public static final int ZSTATUS_SORT_COMPLETE = 7;
    public static final int ZSTATUS_ERROR = 8;
    private static final String[] private_status_types = new String[]{"Undefined", "Idle", "Searching", "Search complete", "Requesting records", "All records returned", "Sorting", "Sort Complete", "Error"};
    public int z3950_status = 0;
    private Z3950Origin protocol_endpoint = null;
    private int fragment_count = 0;
    private Logger log = Logger.getLogger((class$org$jzkit$search$provider$z3950$Z3950SearchTask == null ? (class$org$jzkit$search$provider$z3950$Z3950SearchTask = Z3950SearchTask.class$("org.jzkit.search.provider.z3950.Z3950SearchTask")) : class$org$jzkit$search$provider$z3950$Z3950SearchTask).getName());
    public static int dbg_counter = 0;
    private int default_present_timeout = 60000;
    private RecordFormatSpecification default_spec = null;
    private String grs_record_profile = null;
    private Hashtable outstanding_requests = new Hashtable();
    private String charset = "UTF-8";
    static /* synthetic */ Class class$org$jzkit$search$provider$z3950$Z3950SearchTask;

    public Z3950SearchTask(Z3950Origin protocol_endpoint, Observer[] observers, RecordFormatSpecification default_spec) {
        super(observers);
        ++dbg_counter;
        this.protocol_endpoint = protocol_endpoint;
        this.default_spec = default_spec;
    }

    protected void finalize() {
        this.log.fine("Z3950SearchTask::finalize() (" + --dbg_counter + " active)");
    }

    protected void setPrivateStatusCode(int code) {
        this.z3950_status = code;
    }

    public int getPrivateTaskStatusCode() {
        return this.z3950_status;
    }

    public String lookupPrivateStatusCode(int code) {
        return private_status_types[code];
    }

    public InformationFragment[] getFragment(int starting_fragment, int count, RecordFormatSpecification spec) throws IRResultSetException {
        ExplicitRecordFormatSpecification actual_spec = this.interpretSpec(spec);
        this.log.fine("Z3950SearchTask::getFragment(" + starting_fragment + "," + count + "," + actual_spec + ")");
        if (starting_fragment > this.fragment_count) {
            throw new IRResultSetException("Present out of range, only " + this.fragment_count + " records available");
        }
        if (starting_fragment + count - 1 > this.fragment_count) {
            count = this.fragment_count - starting_fragment + 1;
            this.log.fine("get asks for record past end of result set, trim to " + count);
        }
        Object result = null;
        PresentResponse_type pr = this.protocol_endpoint.fetchRecords(this.getSetID(), actual_spec, starting_fragment, count, this.default_present_timeout);
        return this.processRecords(pr.records);
    }

    public void asyncGetFragment(int starting_fragment, int count, RecordFormatSpecification spec, IFSNotificationTarget target) throws IRResultSetException {
        ExplicitRecordFormatSpecification actual_spec = this.interpretSpec(spec);
        this.log.fine("Z3950SearchTask::asyncgetFragment(" + starting_fragment + "," + count + "," + actual_spec + ")");
        if (starting_fragment > this.fragment_count) {
            target.notifyError("bib1-diag", null, "present out of bounds", (Throwable)new IRResultSetException("Present out of range, only " + this.fragment_count + " records available"));
        } else {
            if (starting_fragment + count - 1 > this.fragment_count) {
                count = this.fragment_count - starting_fragment + 1;
                this.log.fine("get asks for record past end of result set, trim to " + count);
            }
            try {
                this.protocol_endpoint.asyncFetchRecords(this.getSetID(), actual_spec, starting_fragment, count, (ZCallbackTarget)new PresentCallbackHandler(this, target));
            }
            catch (IRResultSetException rse) {
                target.notifyError("bib1-diag", null, "Problem", (Throwable)new IRResultSetException(rse.toString()));
            }
        }
    }

    protected InformationFragment[] processRecords(Records_type r) {
        InformationFragment[] result;
        block37: {
            block36: {
                result = null;
                if (r == null) break block36;
                switch (r.which) {
                    case 0: {
                        ArrayList v = (ArrayList)r.o;
                        int num_records = v.size();
                        int counter = 0;
                        result = new InformationFragment[num_records];
                        this.log.fine("Response contains " + num_records + " Response Records");
                        Iterator recs = ((AbstractList)v).iterator();
                        while (recs.hasNext()) {
                            NamePlusRecord_type npr = (NamePlusRecord_type)recs.next();
                            if (null != npr) {
                                String source_name = this.protocol_endpoint.getTargetDN();
                                String source_collection = npr.name;
                                block5 : switch (npr.record.which) {
                                    case 0: {
                                        EXTERNAL_type et = (EXTERNAL_type)npr.record.o;
                                        int[] record_oid = et.direct_reference;
                                        ExplicitRecordFormatSpecification spec = FormatSpecOIDHelper.getSpec((OIDRegister)this.protocol_endpoint.reg, (int[])record_oid, (String)null, null);
                                        this.log.fine("Derived record spec : " + spec);
                                        switch (et.direct_reference.length) {
                                            case 6: {
                                                switch (et.direct_reference[5]) {
                                                    case 1: {
                                                        result[counter++] = new iso2709(source_name, source_collection, spec, null, et.encoding.o, "UTF-8");
                                                        break block5;
                                                    }
                                                    case 3: {
                                                        break block5;
                                                    }
                                                    case 10: 
                                                    case 11: 
                                                    case 12: 
                                                    case 13: 
                                                    case 14: 
                                                    case 15: 
                                                    case 21: 
                                                    case 22: {
                                                        this.log.fine("Marc variant");
                                                        result[counter++] = new iso2709(source_name, source_collection, spec, null, et.encoding.o, this.charset);
                                                        break block5;
                                                    }
                                                    case 100: {
                                                        this.log.fine("Explain");
                                                        result[counter++] = new ExplainRecord(source_name, source_collection, null, et.encoding.o, spec);
                                                        break block5;
                                                    }
                                                    case 101: {
                                                        this.log.fine("SUTRS");
                                                        result[counter++] = new SUTRS(source_name, source_collection, null, et.encoding.o, spec);
                                                        break block5;
                                                    }
                                                    case 102: {
                                                        this.log.fine("Opac record");
                                                        result[counter++] = new OpacRecord(source_name, source_collection, null, et.encoding.o, spec);
                                                    }
                                                    case 105: {
                                                        this.log.fine("GRS1");
                                                        result[counter++] = new GRS1(source_name, source_collection, null, (ArrayList)et.encoding.o, FormatSpecOIDHelper.getSpec((OIDRegister)this.protocol_endpoint.reg, (int[])record_oid, (String)null, (String)this.grs_record_profile), this.protocol_endpoint.reg);
                                                        break block5;
                                                    }
                                                }
                                                this.log.info("unknow Syntax OID ending with " + et.direct_reference[4]);
                                                result[counter++] = new UnknownBlob(source_name, source_collection, null, et.encoding.o, spec);
                                                break block5;
                                            }
                                            case 7: {
                                                if (et.direct_reference[5] == 109) {
                                                    switch (et.direct_reference[6]) {
                                                        case 1: {
                                                            this.log.fine("PDF Document...");
                                                            result[counter++] = new UnknownBlob(source_name, source_collection, null, et.encoding.o, spec);
                                                            break block5;
                                                        }
                                                        case 3: {
                                                            this.log.fine("HTML record...");
                                                            String html_rec = null;
                                                            html_rec = et.encoding.o instanceof byte[] ? new String((byte[])et.encoding.o) : et.encoding.o.toString();
                                                            result[counter++] = new HTMLRecord(source_name, source_collection, null, (Object)html_rec, spec);
                                                            break block5;
                                                        }
                                                        case 9: {
                                                            this.log.fine("SGML record...");
                                                            result[counter++] = new SGMLRecord(source_name, source_collection, null, et.encoding.o.toString(), spec);
                                                            break block5;
                                                        }
                                                        case 10: {
                                                            String rec = new String((byte[])et.encoding.o);
                                                            result[counter++] = new XMLRecord(source_name, source_collection, null, rec, spec);
                                                            break block5;
                                                        }
                                                    }
                                                    result[counter++] = new UnknownBlob(source_name, source_collection, null, et.encoding.o, spec);
                                                    break block5;
                                                }
                                                this.log.info("Unhandled 7-int OID for record type");
                                            }
                                        }
                                        break;
                                    }
                                    case 1: {
                                        this.log.info("SurrogateDiagnostic");
                                        DiagRec_type d = (DiagRec_type)npr.record.o;
                                        if (d.which == 0) {
                                            DefaultDiagFormat_type ddf = (DefaultDiagFormat_type)d.o;
                                            String reason = "Diagnostic " + (ddf.addinfo != null ? ddf.addinfo.toString() : "none");
                                            this.setDiagnosticStatus("diag.bib1." + ddf.condition, this.protocol_endpoint.getTargetName(), source_name + " " + source_collection);
                                            result[counter++] = new SurrogateDiagnostic(source_name, source_collection, (Object)ddf.condition, null, reason);
                                            break;
                                        }
                                        this.setDiagnosticStatus("diag.k-int.7", this.protocol_endpoint.getTargetName(), source_name + " " + source_collection);
                                        result[counter++] = new SurrogateDiagnostic(source_name, source_collection, (Object)"External", null, "External");
                                        break;
                                    }
                                    case 2: {
                                        this.log.info("StartingFragment");
                                        break;
                                    }
                                    case 3: {
                                        this.log.info("IntermediateFragment");
                                        break;
                                    }
                                    case 4: {
                                        this.log.info("FinalFragment");
                                        break;
                                    }
                                    default: {
                                        this.log.info("Unhandled record type");
                                        break;
                                    }
                                }
                                continue;
                            }
                            this.log.fine("Error... record ptr is null");
                        }
                        break block37;
                    }
                    case 1: {
                        DefaultDiagFormat_type d = (DefaultDiagFormat_type)r.o;
                        if (d.addinfo != null) {
                            this.log.info("Non surrogate diagnostics [" + d.condition + "] Additional Info : " + d.addinfo.o);
                            this.setDiagnosticStatus("diag.bib1." + d.condition, this.protocol_endpoint.getTargetName(), "Additional Info : " + d.addinfo.o);
                            break;
                        }
                        this.log.info("Non surrogate diagnostics [" + d.condition + "] no additional info");
                        this.setDiagnosticStatus("diag.bib1." + d.condition, this.protocol_endpoint.getTargetName(), null);
                        break;
                    }
                    case 2: {
                        this.log.info("Multiple non surrogate diagnostics");
                        break;
                    }
                    default: {
                        this.log.info("Unknown choice for records response : " + r.which);
                    }
                }
                break block37;
            }
            this.log.fine("Records member of present response is null");
        }
        return result;
    }

    public void setFragmentCount(int i) {
        this.log.fine("Z3950SearchTask::setFragmentCount(" + i + ")");
        this.fragment_count = i;
        IREvent e = new IREvent(1001, (Object)new Integer(i));
        ((Observable)((Object)this)).setChanged();
        ((Observable)((Object)this)).notifyObservers(e);
    }

    public int getFragmentCount() {
        return this.fragment_count;
    }

    public int getRecordAvailableHWM() {
        return this.fragment_count;
    }

    public void cancelTask() {
        this.log.fine("Z3950SearchTask::cancelTask()");
    }

    public void close() {
        this.log.fine("Z3950SearchTask::close()");
    }

    public void destroyTask() {
        super.destroyTask();
        this.log.fine("Z3950SearchTask::destroyTask()");
    }

    public AsynchronousEnumeration elements() {
        this.log.fine("Z3950SearchTask::elements()");
        int default_present_chunk_size = 10;
        return new ReadAheadEnumeration((IRResultSet)this, default_present_chunk_size);
    }

    public String toString() {
        return "Z3950SearchTask - " + this.getSetID();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExplicitRecordFormatSpecification interpretSpec(RecordFormatSpecification in_spec) throws IRResultSetException {
        ExplicitRecordFormatSpecification retval = null;
        if (in_spec instanceof ExplicitRecordFormatSpecification) {
            ExplicitRecordFormatSpecification spec;
            retval = spec = (ExplicitRecordFormatSpecification)in_spec;
            boolean new_spec_needed = false;
            try {
                String new_format = this.strval(spec.getEncoding());
                String new_schema = this.strval(spec.getSchema());
                String new_esetname = this.strval(spec.getSetname());
                this.log.fine("InterpretSpec " + spec);
                if (spec.getEncoding() instanceof IndirectFormatProperty) {
                    this.log.fine("Convert format " + spec.getEncoding());
                    new_format = BeanUtils.getProperty((Object)this.protocol_endpoint, (String)new_format);
                    new_spec_needed = true;
                    this.log.fine("actual format will be " + new_format);
                }
                if (spec.getSchema() instanceof IndirectFormatProperty) {
                    new_schema = BeanUtils.getProperty((Object)this.protocol_endpoint, (String)new_schema);
                    new_spec_needed = true;
                    this.log.fine("actual format will be " + new_schema);
                }
                if (spec.getSetname() instanceof IndirectFormatProperty) {
                    this.log.fine("Convert setname " + spec.getSchema());
                    new_esetname = BeanUtils.getProperty((Object)this.protocol_endpoint, (String)new_esetname);
                    new_spec_needed = true;
                    this.log.fine("actual format will be " + new_esetname);
                }
                if (!new_spec_needed) return retval;
                retval = new ExplicitRecordFormatSpecification(new_format, new_schema, new_esetname);
                this.log.fine("Converted " + spec.toString() + " into " + retval);
                return retval;
            }
            catch (IllegalAccessException iae) {
                throw new IRResultSetException("Problem interpreting spec", (Object)iae);
            }
            catch (InvocationTargetException ite) {
                throw new IRResultSetException("Problem interpreting spec", (Object)ite);
            }
            catch (NoSuchMethodException nspe) {
                throw new IRResultSetException("Problem interpreting spec", (Object)nspe);
            }
        } else {
            if (!(in_spec instanceof ArchetypeRecordFormatSpecification)) throw new IRResultSetException("Unhandled RecordFormatSpecification of class " + in_spec.getClass().getName());
            String actual_spec = (String)this.protocol_endpoint.getRecordArchetypes().get(in_spec.toString());
            if (actual_spec == null) {
                throw new IRResultSetException("Unable to locate format specification for archetype " + in_spec.toString());
            }
            this.log.fine("Record Archetype " + in_spec + " converted to " + actual_spec);
            return new ExplicitRecordFormatSpecification(actual_spec);
        }
    }

    private String strval(FormatProperty p) {
        if (p != null) {
            return p.toString();
        }
        return null;
    }

    public IRResultSetInfo getResultSetInfo() {
        return new IRResultSetInfo(this.getResultSetName(), this.getFragmentCount(), this.getStatus());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

