/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.jexcel.dal.provider;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Locale;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.feature.OpenFeatureStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.spi.AbstractDataStoreParameters;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.gvsig.tools.dynobject.DynObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JExcelStoreParameters
extends AbstractDataStoreParameters
implements OpenFeatureStoreParameters,
FilesystemStoreParameters {
    private static final Logger logger = LoggerFactory.getLogger(JExcelStoreParameters.class);
    public static final String PARAMETERS_DEFINITION_NAME = "JExcel";
    private static final String FILE = "file";
    private static final String IGNOREERRORS = "ignoreErrors";
    private static final String CRS = "CRS";
    private static final String FIELDTYPES = "fieldtypes";
    public static final String LOCALE = "locale";
    public static final String ENCODING = "encoding";
    private static final String SHEET = "sheet";
    private static final String ISFIRSTROWHEADER = "isFirstRowHeader";
    private static final String AUTOMATICTYPESDETECTION = "automaticTypesDetection";
    private static final String HEADER = "header";
    private DelegatedDynObject parameters;

    public JExcelStoreParameters() {
        this(PARAMETERS_DEFINITION_NAME);
    }

    protected JExcelStoreParameters(String parametersDefinitionName) {
        this(parametersDefinitionName, PARAMETERS_DEFINITION_NAME);
    }

    public JExcelStoreParameters(String parametersDefinitionName, String name) {
        this.parameters = (DelegatedDynObject)FileHelper.newParameters((String)parametersDefinitionName);
        this.setDynValue("ProviderName", name);
    }

    public String getDataStoreName() {
        return (String)this.getDynValue("ProviderName");
    }

    public String getDescription() {
        return this.getDynClass().getDescription();
    }

    protected DelegatedDynObject getDelegatedDynObject() {
        return this.parameters;
    }

    public boolean isValid() {
        return !StringUtils.isBlank((CharSequence)JExcelStoreParameters.getFileName((DynObject)this));
    }

    public File getFile() {
        return (File)this.getDynValue(FILE);
    }

    public void setFile(File file) {
        this.setDynValue(FILE, file);
    }

    static IProjection getCRS(DynObject dynobj) {
        return (IProjection)dynobj.getDynValue(CRS);
    }

    static String getFileName(DynObject dynobj) {
        File f = (File)dynobj.getDynValue(FILE);
        if (f == null) {
            return null;
        }
        return f.getPath();
    }

    static File getFile(DynObject dynobj) {
        File f = (File)dynobj.getDynValue(FILE);
        return f;
    }

    static Locale getLocale(DynObject dynobj) {
        try {
            String s = (String)dynobj.getDynValue(LOCALE);
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            if ("DEFAULT".equalsIgnoreCase(s.trim())) {
                return Locale.getDefault();
            }
            Locale locale = Locale.forLanguageTag(s);
            return locale;
        }
        catch (Exception ex) {
            logger.warn("Can't get locale from JExcel parameters.", (Throwable)ex);
            return null;
        }
    }

    public static String getEncoding(DynObject dynobj) {
        try {
            String s = (String)dynobj.getDynValue(ENCODING);
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            if ("DEFAULT".equalsIgnoreCase(s.trim())) {
                return Charset.defaultCharset().name();
            }
            return s;
        }
        catch (Exception ex) {
            logger.warn("Can't get locale from JExcel parameters.", (Throwable)ex);
            return null;
        }
    }

    private static String getDelimiter(String line) {
        String sep = null;
        String seps = ",;-|@#/+$%&!:";
        for (int i = 0; i < seps.length(); ++i) {
            sep = seps.substring(i, 1);
            if (line.contains(seps.substring(i, 1))) break;
            sep = null;
        }
        return sep;
    }

    static String[] getPointDimensionNames(DynObject dynobj) {
        String s = (String)dynobj.getDynValue("point");
        if (StringUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        return s.split(",");
    }

    static boolean getIgnoreErrors(DynObject dynobj) {
        Boolean b = (Boolean)dynobj.getDynValue(IGNOREERRORS);
        if (b == null) {
            return false;
        }
        return b;
    }

    static int[] getFieldTypes(DynObject dynobj) {
        String s = (String)dynobj.getDynValue(FIELDTYPES);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        String sep = JExcelStoreParameters.getDelimiter(s);
        if (sep == null) {
            return null;
        }
        DataTypesManager dataTypeManager = ToolsLocator.getDataTypesManager();
        String[] fieldTypeNames = s.split("[" + sep + "]");
        int[] fieldTypes = new int[fieldTypeNames.length];
        for (int i = 0; i < fieldTypeNames.length; ++i) {
            s = fieldTypeNames[i].trim();
            if (s.contains(":")) {
                s = s.split(":")[0];
            }
            fieldTypes[i] = dataTypeManager.getType(s);
        }
        return fieldTypes;
    }

    static int[] getFieldSizes(DynObject dynobj) {
        String s = (String)dynobj.getDynValue(FIELDTYPES);
        if (StringUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        String sep = JExcelStoreParameters.getDelimiter(s);
        if (sep == null) {
            return null;
        }
        String[] fieldTypeNames = s.split("[" + sep + "]");
        int[] fieldSizes = new int[fieldTypeNames.length];
        for (int i = 0; i < fieldTypeNames.length; ++i) {
            String fieldtype = fieldTypeNames[i].trim();
            if (fieldtype.contains(":")) {
                try {
                    s = fieldtype.split(":")[1];
                    fieldSizes[i] = Integer.parseInt(s);
                }
                catch (Exception ex) {
                    logger.warn("Can't get size of field " + i + " (" + fieldtype + ").", (Throwable)ex);
                }
                continue;
            }
            fieldSizes[i] = 0;
        }
        return fieldSizes;
    }

    static int getSheetIndex(DynObject dynobj) {
        Integer sheet = (Integer)dynobj.getDynValue(SHEET);
        if (sheet == null) {
            return 0;
        }
        return sheet;
    }

    static String getHeader(DynObject dynobj) {
        String s = (String)dynobj.getDynValue(HEADER);
        if (StringUtils.isBlank((CharSequence)(s = StringEscapeUtils.unescapeJava((String)s)))) {
            return null;
        }
        return s;
    }

    static String[] getHeaders(DynObject dynobj) {
        String s = JExcelStoreParameters.getHeader(dynobj);
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        String sep = JExcelStoreParameters.getDelimiter(s);
        if (sep == null) {
            return null;
        }
        String[] ss = s.split("[" + sep + "]");
        return ss;
    }

    static boolean getAutomaticTypesDetection(DynObject dynobj) {
        Boolean b = (Boolean)dynobj.getDynValue(AUTOMATICTYPESDETECTION);
        if (b == null) {
            return false;
        }
        return b;
    }

    static boolean isFirstRowHeader(DynObject dynobj) {
        Boolean b = (Boolean)dynobj.getDynValue(ISFIRSTROWHEADER);
        if (b == null) {
            return false;
        }
        return b;
    }
}

