/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.lib.impl;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.BasicAsyncResponseProducer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.nio.protocol.HttpAsyncResponseProducer;
import org.apache.http.protocol.HttpContext;
import org.gvsig.report.lib.api.commands.Command;
import org.gvsig.report.lib.impl.DefaultReportServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHandler
implements HttpAsyncRequestHandler<HttpRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpHandler.class);
    private final DefaultReportServer server;

    public HttpHandler(DefaultReportServer server) {
        this.server = server;
    }

    public HttpAsyncRequestConsumer<HttpRequest> processRequest(HttpRequest request, HttpContext context) {
        return new BasicAsyncRequestConsumer();
    }

    public void handle(HttpRequest request, HttpAsyncExchange httpexchange, HttpContext context) throws HttpException, IOException {
        HttpResponse response = httpexchange.getResponse();
        this.handleInternal(request, response, context);
        httpexchange.submitResponse((HttpAsyncResponseProducer)new BasicAsyncResponseProducer(response));
    }

    private void handleInternal(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        Object ret;
        String method = request.getRequestLine().getMethod().toUpperCase(Locale.ENGLISH);
        if (!method.equals("GET")) {
            this.server.log(1, "Method not supported, Only GET supported.");
            throw new MethodNotSupportedException(method + " method not supported");
        }
        String target = request.getRequestLine().getUri();
        String line = URLDecoder.decode(target, "UTF-8");
        String[] argsTarget = StringUtils.split((String)target, (char)'/');
        int i = argsTarget.length;
        String[] args = new String[i];
        for (int cont = 0; cont < i; ++cont) {
            args[cont] = URLDecoder.decode(argsTarget[cont], "UTF-8");
        }
        int argc = args.length - 1;
        Command command = this.server.getCommand(args[0]);
        if (command == null) {
            this.server.log(1, "Command '" + line + "' not found.");
            response.setStatusCode(404);
            NStringEntity entity = new NStringEntity("<html><body><h1>Command " + line + " not found</h1></body></html>", ContentType.create((String)"text/html", (String)"UTF-8"));
            response.setEntity((HttpEntity)entity);
            return;
        }
        if (!command.getNumArgs().contains((Object)argc)) {
            this.server.log(1, "Command '" + line + "', invalid number of arguments.");
            response.setStatusCode(400);
            NStringEntity entity = new NStringEntity("<html><body><h1>Number of arguments invalid in " + line + "</h1></body></html>", ContentType.create((String)"text/html", (String)"UTF-8"));
            response.setEntity((HttpEntity)entity);
            return;
        }
        try {
            ret = command.call(argc, args);
        }
        catch (Exception ex) {
            LOG.warn("Can't server command '" + line + "'.", (Throwable)ex);
            this.server.log(1, "Command '" + line + "', error " + ex.getMessage() + ".");
            response.setStatusCode(500);
            NStringEntity entity = new NStringEntity("<html><body><h1>Error processing " + line + "</h1><p>" + ex.toString() + "</p></body></html>", ContentType.create((String)"text/html", (String)"UTF-8"));
            response.setEntity((HttpEntity)entity);
            return;
        }
        if (ret == null) {
            this.server.log(1, "Command '" + line + "' return null.");
            response.setStatusCode(500);
            NStringEntity entity = new NStringEntity("<html><body><h1>Process " + line + " return null</h1></body></html>", ContentType.create((String)"text/html", (String)"UTF-8"));
            response.setEntity((HttpEntity)entity);
            return;
        }
        if (ret instanceof byte[]) {
            response.setStatusCode(200);
            ByteArrayEntity entity = new ByteArrayEntity((byte[])ret, ContentType.create((String)command.getMimeType(), (String)"UTF-8"));
            response.setEntity((HttpEntity)entity);
            this.server.log(0, "Command '" + line + "' ok.");
            return;
        }
        response.setStatusCode(200);
        NStringEntity entity = new NStringEntity(ret.toString(), ContentType.create((String)command.getMimeType(), (String)"UTF-8"));
        response.setEntity((HttpEntity)entity);
        this.server.log(0, "Command '" + line + "' ok.");
    }
}

