/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.lib.impl.commands;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.htmlbuilder.HTMLBuilder;
import org.gvsig.report.lib.api.ReportServer;
import org.gvsig.report.lib.api.commands.AbstractCommand;
import org.gvsig.report.lib.api.commands.Command;
import org.gvsig.report.lib.api.commands.CommandFactory;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.json.JSONArray;
import org.json.JSONObject;

public class Help
extends AbstractCommand {
    public Help(CommandFactory factory, ReportServer server) {
        super(factory, server);
    }

    public Object call(int argc, String[] args) {
        Map commands = this.getServer().getCommands();
        if (argc > 0 && StringUtils.equalsIgnoreCase((CharSequence)"asjson", (CharSequence)args[1])) {
            JSONArray json = new JSONArray();
            for (Command command : commands.values()) {
                json.put((Object)this.getCommandDescription(command));
            }
            return json.toString();
        }
        HTMLBuilder builder = ToolsUtilLocator.getToolsUtilManager().createHTMLBuilder();
        HTMLBuilder.HTMLComplexElement table = builder.table(new Object[]{0, 1, 4, builder.thead(new Object[]{builder.tr(new Object[]{builder.th(new Object[]{"Return type"}), builder.th(new Object[]{"Name"}), builder.th(new Object[]{"Description"})})})});
        for (Command command : commands.values()) {
            HTMLBuilder.HTMLComplexElement tr = builder.tr("top").contents(new Object[]{builder.td(new Object[]{command.getMimeType()}), builder.td(new Object[]{command.getName()}), builder.td(new Object[]{builder.plainWithNl(command.getDescription() + "\n\n")})});
            table.contents(new Object[]{tr});
        }
        return table.toHTML();
    }

    public JSONObject getCommandDescription(Command command) {
        JSONObject json = new JSONObject();
        json.put("Name", (Object)command.getName());
        json.put("NumArgs", (Object)command.getNumArgs().toString());
        json.put("MimeType", (Object)StringUtils.defaultString((String)command.getMimeType()));
        json.put("Description", (Object)StringUtils.defaultString((String)command.getDescription()));
        return json;
    }
}

