/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.lib.impl.reportbuilder;

import ar.com.fdvs.dj.domain.CustomExpression;
import java.util.Map;
import java.util.Objects;
import net.sf.jasperreports.engine.fill.JRFillField;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.expressionevaluator.FeatureSymbolTable;
import org.gvsig.report.lib.impl.JRFeatureStoreDataSource;
import org.gvsig.tools.dataTypes.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GvsigCustomExpression
implements CustomExpression {
    private static final Logger LOGGER = LoggerFactory.getLogger(GvsigCustomExpression.class);
    public final Expression expression;
    private final DataType dataType;
    private final MutableSymbolTable symbolTable;

    GvsigCustomExpression(Expression exp, DataType dataType) {
        this.expression = exp;
        this.dataType = dataType;
        this.symbolTable = ExpressionUtils.createSymbolTable();
    }

    public Object evaluate(Map fields, Map variables, Map parameters) {
        Object o = null;
        Map fieldsVars = fields;
        for (Map.Entry var : fieldsVars.entrySet()) {
            o = var.getValue();
            if (!(o instanceof JRFillField)) continue;
            JRFillField value = o;
            this.symbolTable.setVar((String)var.getKey(), value.getValue());
        }
        o = parameters.get("REPORT_DATA_SOURCE");
        if (o instanceof JRFeatureStoreDataSource) {
            JRFeatureStoreDataSource dataSource = o;
            FeatureSymbolTable fst = dataSource.getFeatureSymbolTable();
            this.symbolTable.addSymbolTable((SymbolTable)fst);
            LOGGER.info(Objects.toString(fst.getFeature()));
        }
        return this.expression.execute((SymbolTable)this.symbolTable);
    }

    public String getClassName() {
        return this.dataType.getDefaultClass().getName();
    }
}

