/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tilecache.provider;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.gvsig.fmap.dal.raster.RasterQuery;
import org.gvsig.fmap.dal.raster.spi.RasterStoreProvider;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.raster.lib.buffer.api.TileStruct;
import org.gvsig.raster.tilecache.provider.TileCacheStructImage;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.dynobject.exception.DynMethodException;
import org.gvsig.tools.exception.BaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTileCacheStructImage
extends AbstractDisposable
implements TileCacheStructImage {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTileCacheStructImage.class);
    protected RasterStoreProvider innerProvider;
    protected RasterQuery query;
    protected TileStruct tileStruct;
    protected Object colorInterpretation;
    protected Object legend;
    protected Object colorTable;
    protected Map<String, Tile> recentAccededTiles;
    protected Integer bandNumber = null;
    protected int[] dataTypes;

    public AbstractTileCacheStructImage(RasterStoreProvider innerProvider, RasterQuery query) {
        this.innerProvider = innerProvider;
        this.query = query;
    }

    @Override
    public int getZoomLvlForPixelSize(double pixelSize) {
        int zoom = 0;
        Map pixelSizePerZoomLevel = this.getTileStruct().getPixelSizePerZoomLevel();
        Iterator iterator = pixelSizePerZoomLevel.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            zoom = i;
            double levelPixelSize = (Double)pixelSizePerZoomLevel.get(zoom);
            if (!(pixelSize >= levelPixelSize)) continue;
            return zoom;
        }
        return zoom;
    }

    protected void fillStoreInfo() {
        this.bandNumber = this.innerProvider.getBands();
        this.dataTypes = new int[this.bandNumber.intValue()];
        for (int i = 0; i < this.bandNumber; ++i) {
            this.dataTypes[i] = this.innerProvider.getBandDescriptor(i).getDataType();
        }
        try {
            this.colorInterpretation = this.innerProvider.invokeDynMethod("getColorInterpretation", null);
            this.colorTable = this.innerProvider.invokeDynMethod("getColorTable", null);
            this.legend = this.innerProvider.invokeDynMethod("getLegend", null);
        }
        catch (DynMethodException e) {
            logger.warn("Can't fill legend info from store.");
        }
    }

    @Override
    public int getBandNumber() {
        if (this.bandNumber == null) {
            this.fillStoreInfo();
        }
        return this.bandNumber;
    }

    @Override
    public int[] getDataTypes() {
        if (this.dataTypes == null) {
            this.fillStoreInfo();
        }
        return this.dataTypes;
    }

    @Override
    public int getRows(int zoomLevel) {
        return (int)Math.round(this.getEnvelope().getLength(1) / (Double)this.tileStruct.getPixelSizePerZoomLevel().get(zoomLevel));
    }

    @Override
    public int getColumns(int zoomLevel) {
        return (int)Math.round(this.getEnvelope().getLength(0) / (Double)this.tileStruct.getPixelSizePerZoomLevel().get(zoomLevel));
    }

    @Override
    public Envelope getEnvelope() {
        return this.tileStruct.getEnvelope();
    }

    @Override
    public int getRowsPerTile() {
        return this.tileStruct.getRowsPerTile();
    }

    @Override
    public int getColumnsPerTile() {
        return this.tileStruct.getColumnsPerTile();
    }

    @Override
    public String getProviderName() {
        return this.tileStruct.getProviderName();
    }

    protected String composeKeyForRecentTiles(int zoomLevel, int structRow, int structCol) {
        StringBuilder builder = new StringBuilder();
        builder.append(zoomLevel);
        builder.append(":");
        builder.append(structCol);
        builder.append(":");
        builder.append(structRow);
        return builder.toString();
    }

    protected void removeOlderTile() {
        Tile olderTile = null;
        for (Tile tile : this.recentAccededTiles.values()) {
            if (olderTile != null && tile.getLastAccess() >= olderTile.getLastAccess()) continue;
            olderTile = tile;
        }
        if (olderTile != null) {
            this.recentAccededTiles.remove(olderTile.getKey());
            DisposeUtils.dispose((Disposable)olderTile);
        }
    }

    @Override
    public Object getColorInterpretation() {
        if (this.colorInterpretation == null) {
            this.fillStoreInfo();
        }
        return this.colorInterpretation;
    }

    @Override
    public Object getColorTable() {
        if (this.colorTable == null) {
            this.fillStoreInfo();
        }
        return this.colorTable;
    }

    @Override
    public Object getLegend() {
        if (this.legend == null) {
            this.fillStoreInfo();
        }
        return this.legend;
    }

    @Override
    public void forgetCache() {
        this.recentAccededTiles.clear();
    }

    protected void doDispose() throws BaseException {
        if (this.recentAccededTiles != null) {
            Set<Map.Entry<String, Tile>> entrySet = this.recentAccededTiles.entrySet();
            for (Map.Entry<String, Tile> entry : entrySet) {
                DisposeUtils.dispose((Disposable)((Disposable)entry.getValue()));
            }
            this.recentAccededTiles.clear();
        }
        DisposeUtils.dispose((Disposable)this.innerProvider);
        this.innerProvider = null;
        DisposeUtils.dispose((Disposable)((Disposable)this.tileStruct));
        this.tileStruct = null;
        this.query = null;
        this.colorInterpretation = null;
        this.legend = null;
        this.colorTable = null;
    }

    protected class Tile
    extends AbstractDisposable {
        Buffer buffer;
        long lastAccess;
        String key;

        public Tile(Buffer buffer, String key) {
            ToolsLocator.getDisposableManager().bind((Disposable)buffer);
            this.buffer = buffer;
            this.key = key;
            this.lastAccess = System.currentTimeMillis();
        }

        public String getKey() {
            return this.key;
        }

        public Buffer getBuffer() {
            this.lastAccess = System.currentTimeMillis();
            return this.buffer;
        }

        public long getLastAccess() {
            return this.lastAccess;
        }

        protected void finalize() throws Throwable {
            super.finalize();
        }

        public void doDispose() throws BaseException {
            DisposeUtils.dispose((Disposable)this.buffer);
            this.buffer = null;
        }
    }
}

