/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tilecache.provider;

import java.util.ArrayList;
import org.gvsig.fmap.dal.DALFileLibrary;
import org.gvsig.fmap.dal.DALLibrary;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.spi.DALSPILocator;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.raster.tilecache.provider.MemoryTileCacheStoreProvider;
import org.gvsig.raster.tilecache.provider.MemoryTileCacheStoreProviderFactory;
import org.gvsig.raster.tilecache.provider.MemoryTileCacheStoreProviderParameters;
import org.gvsig.raster.tilecache.provider.TileCacheStoreProvider;
import org.gvsig.raster.tilecache.provider.TileCacheStoreProviderFactory;
import org.gvsig.raster.tilecache.provider.TileCacheStoreProviderParameters;
import org.gvsig.tools.library.AbstractLibrary;
import org.gvsig.tools.library.LibraryException;

public class TileCacheLibrary
extends AbstractLibrary {
    public static int DEFAULT_LEVELS = 25;
    public static int DEFAULT_TILEWIDTH = 256;
    public static int DEFAULT_TILEHEIGHT = 256;

    public void doRegistration() {
        this.registerAsServiceOf(DALLibrary.class);
        this.require(DALFileLibrary.class);
    }

    protected void doInitialize() throws LibraryException {
    }

    protected void doPostInitialize() throws LibraryException {
        ArrayList<Throwable> exs = new ArrayList<Throwable>();
        FileHelper.registerParametersDefinition((String)"TileCacheStoreProviderParameters", TileCacheStoreProviderParameters.class, (String)"TileCacheParameters.xml");
        try {
            FileHelper.registerMetadataDefinition((String)TileCacheStoreProvider.METADATA_DEFINITION_NAME, TileCacheStoreProvider.class, (String)"TileCacheMetadata.xml");
        }
        catch (MetadataException e) {
            exs.add(e);
        }
        FileHelper.registerParametersDefinition((String)"MemoryTileCacheStoreProviderParameters", MemoryTileCacheStoreProviderParameters.class, (String)"TileCacheParameters.xml");
        try {
            FileHelper.registerMetadataDefinition((String)MemoryTileCacheStoreProvider.METADATA_DEFINITION_NAME, MemoryTileCacheStoreProvider.class, (String)"TileCacheMetadata.xml");
        }
        catch (MetadataException e) {
            exs.add(e);
        }
        DataManagerProviderServices dataman = DALSPILocator.getDataManagerProviderServices();
        try {
            if (!dataman.getStoreProviders().contains(TileCacheStoreProvider.NAME)) {
                dataman.registerStoreProviderFactory((DataStoreProviderFactory)new TileCacheStoreProviderFactory(TileCacheStoreProvider.NAME, TileCacheStoreProvider.DESCRIPTION));
            }
            if (!dataman.getStoreProviders().contains(MemoryTileCacheStoreProvider.NAME)) {
                dataman.registerStoreProviderFactory((DataStoreProviderFactory)new MemoryTileCacheStoreProviderFactory(MemoryTileCacheStoreProvider.NAME, MemoryTileCacheStoreProvider.DESCRIPTION));
            }
        }
        catch (RuntimeException e) {
            exs.add(e);
        }
        if (exs.size() > 0) {
            throw new LibraryException(((Object)((Object)this)).getClass(), exs);
        }
    }
}

