/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.reproject.algorithm.swing.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.cresques.cts.IProjection;
import org.gvsig.app.gui.panels.CRSSelectPanel;
import org.gvsig.app.gui.panels.CRSSelectPanelFactory;
import org.gvsig.gui.beans.defaultbuttonspanel.DefaultButtonsPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.reproject.algorithm.swing.api.RasterReprojectionPanel;
import org.gvsig.raster.reproject.algorithm.swing.api.ReprojectionPanelDataModel;
import org.gvsig.raster.reproject.algorithm.swing.impl.InterpolationPanel;
import org.gvsig.raster.reproject.algorithm.swing.impl.OutputLayerOptionsPanel;
import org.gvsig.raster.swing.RasterSwingLocator;
import org.gvsig.raster.swing.newlayer.CreateNewLayerPanel;

public class RasterReprojectionPanelImpl
extends DefaultButtonsPanel
implements ActionListener,
RasterReprojectionPanel,
KeyListener {
    private static final long serialVersionUID = -1011688195806336071L;
    private CRSSelectPanel projectionSrcSelector = null;
    private CRSSelectPanel projectionDstSelector = null;
    private InterpolationPanel interpolationPanel = null;
    private OutputLayerOptionsPanel layerOptions = null;
    private CreateNewLayerPanel newLayerPanel = null;
    private ReprojectionPanelDataModel dataModel = null;
    private JLabel layerName = null;

    public RasterReprojectionPanelImpl(ReprojectionPanelDataModel dataModel) {
        super(2);
        this.dataModel = dataModel;
        this.init();
        this.loadPanelFromDataModel();
        this.getInterpolationPanel().getComboInterpolationMethod().addActionListener(this);
        this.getInterpolationPanel().getRadioYes().addActionListener(this);
        this.getInterpolationPanel().getRadioNo().addActionListener(this);
    }

    private void loadPanelFromDataModel() {
        this.getLayerOptionsPanel().getTextFieldCellSize().setText(this.dataModel.getCellSize() + "");
        this.getLayerOptionsPanel().getTextFieldSizeX().setText(this.dataModel.getSize()[0] + "");
        this.getLayerOptionsPanel().getTextFieldSizeY().setText(this.dataModel.getSize()[1] + "");
        this.getLayerName().setText("<html><b>" + this.dataModel.getLayerName() + "</b></html>");
        List<String> list = this.dataModel.getInterpolationMethodList();
        for (int i = 0; i < list.size(); ++i) {
            this.getInterpolationPanel().getComboInterpolationMethod().addItem(list.get(i));
        }
        if (this.dataModel.getInterpolationMethodSelected() < 0) {
            this.getInterpolationPanel().getRadioYes().setSelected(false);
            this.getInterpolationPanel().getRadioNo().setSelected(true);
        } else {
            this.getInterpolationPanel().getRadioYes().setSelected(true);
            this.getInterpolationPanel().getRadioNo().setSelected(false);
            this.getInterpolationPanel().getComboInterpolationMethod().setEnabled(true);
        }
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        int posy = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = posy++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        JPanel panelFile = new JPanel();
        panelFile.setLayout(new BorderLayout());
        panelFile.setBorder(BorderFactory.createTitledBorder(Messages.getText((String)"origen")));
        panelFile.add((Component)this.getLayerName(), "Center");
        this.add(panelFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = posy++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.getProjectionSrcSelector(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = posy++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.getProjectionDstSelector(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = posy++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add(this.getInterpolationPanel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = posy++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add(this.getLayerOptionsPanel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = posy++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((JComponent)this.getCreateNewLayerPanel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = posy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JPanel emptyPanel = new JPanel();
        this.add(emptyPanel, gridBagConstraints);
    }

    private JLabel getLayerName() {
        if (this.layerName == null) {
            this.layerName = new JLabel();
        }
        return this.layerName;
    }

    public CreateNewLayerPanel getCreateNewLayerPanel() {
        if (this.newLayerPanel == null) {
            this.newLayerPanel = RasterSwingLocator.getSwingManager().createNewLayerPanel();
        }
        return this.newLayerPanel;
    }

    public InterpolationPanel getInterpolationPanel() {
        if (this.interpolationPanel == null) {
            this.interpolationPanel = new InterpolationPanel();
        }
        return this.interpolationPanel;
    }

    public OutputLayerOptionsPanel getLayerOptionsPanel() {
        if (this.layerOptions == null) {
            this.layerOptions = new OutputLayerOptionsPanel();
            this.layerOptions.getTextFieldCellSize().addKeyListener(this);
        }
        return this.layerOptions;
    }

    private CRSSelectPanel getProjectionSrcSelector() {
        if (this.projectionSrcSelector == null) {
            this.projectionSrcSelector = CRSSelectPanelFactory.getPanel((IProjection)this.dataModel.getSrcProjection());
            this.projectionSrcSelector.setTransPanelActive(true);
            this.projectionSrcSelector.setPreferredSize(null);
            this.projectionSrcSelector.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (RasterReprojectionPanelImpl.this.projectionSrcSelector.isOkPressed()) {
                        RasterReprojectionPanelImpl.this.dataModel.setSrcProjection(RasterReprojectionPanelImpl.this.projectionSrcSelector.getCurProj());
                        try {
                            RasterReprojectionPanelImpl.this.updateSize();
                            RasterReprojectionPanelImpl.this.getLayerOptionsPanel().getTextFieldCellSize().setText(RasterReprojectionPanelImpl.this.dataModel.getCellSize() + "");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this.projectionSrcSelector.setBorder((Border)BorderFactory.createTitledBorder(Messages.getText((String)"src_proj")));
        }
        return this.projectionSrcSelector;
    }

    private CRSSelectPanel getProjectionDstSelector() {
        if (this.projectionDstSelector == null) {
            this.projectionDstSelector = CRSSelectPanel.getPanel((IProjection)this.dataModel.getDstProjection());
            this.projectionDstSelector.setTransPanelActive(true);
            this.projectionDstSelector.setPreferredSize(null);
            this.projectionDstSelector.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (RasterReprojectionPanelImpl.this.projectionDstSelector.isOkPressed()) {
                        RasterReprojectionPanelImpl.this.dataModel.setDstProjection(RasterReprojectionPanelImpl.this.projectionDstSelector.getCurProj());
                        try {
                            RasterReprojectionPanelImpl.this.updateSize();
                            RasterReprojectionPanelImpl.this.getLayerOptionsPanel().getTextFieldCellSize().setText(RasterReprojectionPanelImpl.this.dataModel.getCellSize() + "");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this.projectionDstSelector.setBorder((Border)BorderFactory.createTitledBorder(Messages.getText((String)"dest_proj")));
        }
        return this.projectionDstSelector;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        try {
            Double d = new Double(this.getLayerOptionsPanel().getTextFieldCellSize().getText());
            this.dataModel.setCellSize(d);
            this.updateSize();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateSize() {
        this.getLayerOptionsPanel().getTextFieldSizeX().setText(this.dataModel.getSize()[0] + "");
        this.getLayerOptionsPanel().getTextFieldSizeY().setText(this.dataModel.getSize()[1] + "");
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void addButtonsListener(ActionListener listener) {
        this.getButtonsPanel().getButton(1).addActionListener(listener);
        this.getButtonsPanel().getButton(2).addActionListener(listener);
    }

    @Override
    public int getObjectSelected(Object obj) {
        if (obj == this.getButtonsPanel().getButton(1)) {
            return 1;
        }
        if (obj == this.getButtonsPanel().getButton(2)) {
            return 2;
        }
        return -1;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getFileSelected() {
        return this.getCreateNewLayerPanel().getFileSelected();
    }

    @Override
    public String getDirectorySelected() {
        return this.getCreateNewLayerPanel().getDirectorySelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getInterpolationPanel().getComboInterpolationMethod()) {
            this.dataModel.setInterpolationMethodSelected(this.getInterpolationPanel().getComboInterpolationMethod().getSelectedIndex());
        }
        if (e.getSource() == this.getInterpolationPanel().getRadioYes()) {
            this.dataModel.setInterpolationMethodSelected(this.getInterpolationPanel().getComboInterpolationMethod().getSelectedIndex());
        }
        if (e.getSource() == this.getInterpolationPanel().getRadioNo()) {
            this.dataModel.setInterpolationMethodSelected(-1);
        }
    }
}

