/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.xmlschema.prov.kxml.model;

import java.io.IOException;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamReader;
import org.gvsig.xmlschema.lib.api.som.IXSComplexContent;
import org.gvsig.xmlschema.lib.api.som.IXSComplexTypeDefinition;
import org.gvsig.xmlschema.lib.api.som.IXSContentType;
import org.gvsig.xmlschema.lib.api.som.IXSElement;
import org.gvsig.xmlschema.lib.api.som.IXSExtension;
import org.gvsig.xmlschema.lib.api.som.IXSGroup;
import org.gvsig.xmlschema.lib.api.som.IXSRestriction;
import org.gvsig.xmlschema.lib.api.som.IXSSimpleContent;
import org.gvsig.xmlschema.lib.api.som.IXSTypeDefinition;
import org.gvsig.xmlschema.prov.kxml.model.AbstractXSComponent;
import org.gvsig.xmlschema.prov.kxml.model.XSElement;
import org.gvsig.xmlschema.prov.kxml.model.XSSchema;
import org.gvsig.xmlschema.prov.kxml.model.XSSequence;

public class XSExtension
extends AbstractXSComponent
implements IXSExtension {
    private IXSGroup group = null;
    private String baseType = null;
    private boolean isExtended = false;

    public XSExtension(XSSchema schema, IXmlStreamReader xmlStreamReader) throws IOException {
        super(schema);
        this.schema = schema;
        this.parse(xmlStreamReader);
    }

    private void parse(IXmlStreamReader xmlStreamReader) throws IOException {
        boolean end = false;
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            String attName = xmlStreamReader.getAttributeName(i).getLocalPart();
            String attValue = xmlStreamReader.getAttributeValue(i);
            if (!"base".equals(attName)) continue;
            this.setBaseType(attValue);
        }
        int currentTag = xmlStreamReader.next();
        while (!end) {
            switch (currentTag) {
                case 1: {
                    if (!"sequence".equals(xmlStreamReader.getName().getLocalPart())) break;
                    this.group = new XSSequence(this.schema, xmlStreamReader);
                    break;
                }
                case 2: {
                    if (!"extension".equals(xmlStreamReader.getName().getLocalPart())) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = xmlStreamReader.next();
        }
    }

    public short getNodeType() {
        return 0;
    }

    public String getNodeValue() {
        return null;
    }

    private void setBaseType(String baseType) {
        this.baseType = baseType;
    }

    public IXSGroup getGroup() {
        if (!this.isExtended) {
            IXSTypeDefinition typeDefinition;
            if (this.baseType != null && (typeDefinition = this.schema.getTypeByName(null, this.baseType)) != null && typeDefinition instanceof IXSComplexTypeDefinition) {
                IXSComplexTypeDefinition complexTypeDefinition = (IXSComplexTypeDefinition)typeDefinition;
                this.addGroup(((IXSComplexTypeDefinition)typeDefinition).getGroup());
                IXSContentType contentType = complexTypeDefinition.getContentType();
                if (!(contentType instanceof IXSSimpleContent)) {
                    if (contentType instanceof IXSComplexContent) {
                        IXSExtension extension;
                        IXSRestriction restriction = contentType.getRestriction();
                        if (restriction != null) {
                            this.addGroup(restriction.getGroup());
                        }
                        if ((extension = contentType.getExtension()) != null) {
                            this.addGroup(extension.getGroup());
                        }
                    } else if (contentType instanceof IXSGroup) {
                        this.addGroup((IXSGroup)contentType);
                    }
                }
            }
            this.isExtended = true;
        }
        return this.group;
    }

    private void addGroup(IXSGroup group) {
        if (group != null) {
            for (Object item : group.getItems()) {
                this.group.addChildElement((IXSElement)((XSElement)item));
            }
        }
    }
}

