/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.app.mainplugin;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.EventListener;
import javax.swing.SwingUtilities;
import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.ProjectNotification;
import org.gvsig.report.app.mainplugin.AppReportServices;
import org.gvsig.report.lib.api.ReportLocator;
import org.gvsig.report.lib.api.ReportManager;
import org.gvsig.report.lib.api.ReportServer;
import org.gvsig.report.lib.api.ReportServerConfig;
import org.gvsig.report.lib.api.ReportServices;
import org.gvsig.report.swing.api.JReportServer;
import org.gvsig.report.swing.api.ReportSwingLocator;
import org.gvsig.report.swing.api.ReportSwingManager;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.util.BaseListenerSupport;

public class ReportState {
    private static final String REPORTS_CONFIG = "reports.config";
    private static ReportState reportState = null;
    private ReportServer server = null;
    private JReportServer serverPanel = null;
    private CircularFifoBuffer serverlog = null;
    private ReportServer.LoggerListener logListener = null;
    private AppReportServices services = null;

    public static ReportState get() {
        if (reportState == null) {
            reportState = new ReportState();
        }
        return reportState;
    }

    private ReportState() {
        this.initServer(null, null);
        ProjectManager projectManager = ProjectManager.getInstance();
        projectManager.addProjectListener(new BaseListenerSupport.NotificationListener(){

            public void notify(EventListener event) {
                if (event instanceof ProjectManager.ProjectEvent) {
                    ReportState.this.initServer(null, null);
                    ReportState.this.onNewProject(((ProjectManager.ProjectEvent)event).getProject());
                }
            }
        });
        Project project = projectManager.getCurrentProject();
        if (project != null) {
            project.setProperty((Object)this, (Object)this);
        }
    }

    private void onNewProject(Project project) {
        project.addObserver(new Observer(){

            public void update(Observable observable, Object param) {
                if (param instanceof ProjectNotification) {
                    ProjectNotification notification = (ProjectNotification)param;
                    switch (notification.getNotificationType()) {
                        case 11: {
                            ReportState.this.putServerConfigInProject(notification.getProject(), notification.getFile());
                            break;
                        }
                        case 16: {
                            ReportState.this.fetchServerConfigFromProject(notification.getProject(), notification.getFile());
                        }
                    }
                }
            }
        });
    }

    public ReportServer getServer() {
        return this.server;
    }

    public ReportServerConfig getConfig() {
        return this.server.getConfig();
    }

    private void initServer(String configJSON, File rootFolder) {
        ReportManager manager = ReportLocator.getReportManager();
        if (this.server != null) {
            if (this.server.isStarted()) {
                this.server.stop();
            }
            this.server = null;
        }
        this.logListener = new ReportServer.LoggerListener(){

            public void log(int level, String message) {
                ReportState.this.serverlog.add((Object)new ImmutablePair((Object)level, (Object)message));
            }
        };
        this.serverlog = new CircularFifoBuffer(200);
        this.services = new AppReportServices();
        this.services.setRootFolder(rootFolder);
        ReportServerConfig config = manager.createServerConfig((ReportServices)this.services, configJSON);
        this.server = manager.createServer(config);
        manager.setDefaultServer(this.server);
        this.server.addLogListener(this.logListener);
        if (this.serverPanel != null) {
            this.serverPanel.setServer(this.server);
        }
        config.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ApplicationManager application = ApplicationLocator.getManager();
                Project project = application.getCurrentProject();
                ReportState.this.putServerConfigInProject(project, null);
            }
        });
        if (this.getConfig().getAutostart() && !this.server.isStarted()) {
            this.server.start();
        }
    }

    private void putServerConfigInProject(Project project, File rootFolder) {
        if (this.services != null) {
            this.services.setRootFolder(rootFolder);
        }
        if (this.server != null) {
            project.setProperty(REPORTS_CONFIG, (Object)this.server.getConfig().toJSON());
        } else {
            project.setProperty(REPORTS_CONFIG, null);
        }
    }

    private void fetchServerConfigFromProject(Project project, File rootFolder) {
        String configJSON = (String)project.getProperty(REPORTS_CONFIG);
        this.initServer(configJSON, rootFolder);
    }

    public JReportServer getServerPanel() {
        if (this.serverPanel == null) {
            ReportSwingManager swingManager = ReportSwingLocator.getReportSwingManager();
            this.serverPanel = swingManager.createJReportServer(this.server);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (Object entry : ReportState.this.serverlog) {
                        ImmutablePair logEntry = (ImmutablePair)entry;
                        ReportState.this.serverPanel.log(((Integer)logEntry.getLeft()).intValue(), (String)logEntry.getRight());
                    }
                }
            });
        }
        return this.serverPanel;
    }
}

