/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.app.mainplugin.document;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonReader;
import org.gvsig.app.project.documents.AbstractDocument;
import org.gvsig.app.project.documents.DocumentManager;
import org.gvsig.report.app.mainplugin.document.ReportDocument;
import org.gvsig.report.app.mainplugin.document.ReportDocumentsManager;
import org.gvsig.report.lib.api.Report;
import org.gvsig.report.lib.api.ReportConfig;
import org.gvsig.report.lib.api.ReportLocator;
import org.gvsig.report.lib.api.ReportManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.PropertiesSupport;

public class ReportDocumentImpl
extends AbstractDocument
implements ReportDocument {
    private PropertiesSupport propertiesSupport;
    private ReportConfig reportConfig;
    private boolean openWhenTheUserCreates;

    public ReportDocumentImpl() {
    }

    public ReportDocumentImpl(ReportDocumentsManager reportManager, ReportConfig reportConfig) {
        super((DocumentManager)reportManager);
        this.reportConfig = reportConfig;
        this.setName(reportConfig.getName());
    }

    @Override
    public ReportConfig getReportConfig() {
        return this.reportConfig;
    }

    @Override
    public Report getReport() {
        return this.reportConfig.createReport();
    }

    public Object getProperty(String string) {
        return this.propertiesSupport.getProperty(string);
    }

    public void setProperty(String string, Object o) {
        this.propertiesSupport.setProperty(string, o);
    }

    public Map<String, Object> getProperties() {
        return this.propertiesSupport.getProperties();
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("report_config", this.reportConfig.toJSON().toString());
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        String config_json = state.getString("report_config");
        try (JsonReader reader = Json.createReader((InputStream)new ByteArrayInputStream(config_json.getBytes()));){
            ReportManager manager = ReportLocator.getReportManager();
            this.reportConfig = manager.createReportConfig();
            this.reportConfig.fromJSON(reader.readObject());
        }
    }

    void setOpenWhenTheUserCreates(boolean openDocument) {
        this.openWhenTheUserCreates = openDocument;
    }

    public boolean getOpenWhenTheUserCreates() {
        return this.openWhenTheUserCreates;
    }
}

