/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.spi.dynformfield;

import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormField;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynField_v2;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectUtils;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.dynobject.exception.DynFieldValidateException;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.swing.api.DropDown;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;

public abstract class AbstractJDynFormFieldWithValueList
extends AbstractJDynFormField
implements JDynFormField,
FocusListener {
    protected Object assignedValue = null;
    protected DropDown dropDown = null;
    private DocumentListener documentListener;
    private ItemListener dropDownListener;
    private ChangeListener spinnerListener;

    public AbstractJDynFormFieldWithValueList(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
        this.assignedValue = value;
    }

    @Override
    public Object getAssignedValue() {
        return this.assignedValue;
    }

    protected JTextField getJTextField() {
        if (this.contents instanceof JTextField) {
            return (JTextField)this.contents;
        }
        return null;
    }

    protected JSpinner getJSpinnerField() {
        if (this.contents instanceof JSpinner) {
            return (JSpinner)this.contents;
        }
        return null;
    }

    protected DropDown getDropDown() {
        return this.dropDown;
    }

    protected DynObjectValueItem[] getAvailableValues() {
        DynFormFieldDefinition theDefinition = this.getDefinition();
        if (theDefinition == null) {
            return null;
        }
        DynObjectValueItem[] availableValues = null;
        if (theDefinition instanceof DynField_v2) {
            DynField[] fields;
            DynObject context = this.getForm().getDefinition().createElement();
            for (DynField field : fields = context.getDynClass().getDynFields()) {
                String name = field.getName();
                JDynFormField jfield = this.getForm().getField(name);
                if (jfield == null) continue;
                try {
                    jfield.fetch(context);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            availableValues = theDefinition.getAvailableValues(context);
        } else {
            availableValues = theDefinition.getAvailableValues();
        }
        if (availableValues == null) {
            return null;
        }
        Arrays.sort(availableValues, (o1, o2) -> StringUtils.compareIgnoreCase((String)o1.getLabel(), (String)o2.getLabel()));
        return availableValues;
    }

    @Override
    public void initComponent() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        DynFormSPIManager.ComponentsFactory theFactory = this.getComponentsFactory();
        this.documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractJDynFormFieldWithValueList.this.updateProblemIndicator();
                AbstractJDynFormFieldWithValueList.this.fireFieldChangedEvent();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractJDynFormFieldWithValueList.this.updateProblemIndicator();
                AbstractJDynFormFieldWithValueList.this.fireFieldChangedEvent();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractJDynFormFieldWithValueList.this.updateProblemIndicator();
                AbstractJDynFormFieldWithValueList.this.fireFieldChangedEvent();
            }
        };
        this.dropDownListener = e -> {
            if (e.getStateChange() == 1) {
                this.updateProblemIndicator();
                this.updateDependantFields();
                this.fireFieldChangedEvent();
            }
        };
        this.spinnerListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractJDynFormFieldWithValueList.this.updateProblemIndicator();
                AbstractJDynFormFieldWithValueList.this.fireFieldChangedEvent();
            }
        };
        if (theFactory.containsJComboBox(this.getDefinition(), null)) {
            JComboBox combo = this.getComponentsFactory().getJComboBox(this.getDefinition(), null);
            this.dropDown = ToolsSwingLocator.getToolsSwingManager().createDropDown(combo);
            if (this.getDefinition().isAvailableValuesCalculated()) {
                this.dropDown.addDropdownListener(e -> this.dropDown.setModel(new DefaultComboBoxModel<DynObjectValueItem>(this.getAvailableValues())));
            } else {
                this.dropDown.setModel(new DefaultComboBoxModel<DynObjectValueItem>(this.getAvailableValues()));
            }
            this.contents = combo;
            this.fixPreferredWidth(this.contents);
            this.dropDown.addItemListener(this.dropDownListener);
        } else if (theFactory.containsJLabel(this.getDefinition(), "Ddn")) {
            JLabel label = this.getComponentsFactory().getJLabel(this.getDefinition(), "Ddn");
            this.dropDown = ToolsSwingLocator.getToolsSwingManager().createDropDown(label);
            if (this.getDefinition().isAvailableValuesCalculated()) {
                this.dropDown.addDropdownListener(e -> this.dropDown.setModel(new DefaultComboBoxModel<DynObjectValueItem>(this.getAvailableValues())));
            }
            this.dropDown.setModel(new DefaultComboBoxModel<DynObjectValueItem>(this.getAvailableValues()));
            this.dropDown.setVisibleDropdownArrow(true);
            this.contents = label;
            this.fixPreferredWidth(this.contents);
            this.dropDown.addItemListener(this.dropDownListener);
        } else if (theFactory.containsJSpinner(this.getDefinition(), null)) {
            JSpinner spinner = this.getComponentsFactory().getJSpinner(this.getDefinition(), null);
            DataType dataType = this.getDefinition().getDataType();
            if (dataType.isNumeric()) {
                spinner = ToolsSwingLocator.getToolsSwingManager().spinnerOfNumber(spinner, dataType.getDefaultClass());
            } else if (this.getDefinition().getDataType().getType() == 10) {
                spinner = ToolsSwingLocator.getToolsSwingManager().spinnerOfTime(spinner, null);
            }
            this.contents = spinner;
            this.fixPreferredWidth(this.contents);
            this.dropDown = null;
            spinner.addChangeListener(this.spinnerListener);
        } else if (theFactory.containsJTextField(this.getDefinition(), null)) {
            JTextComponent text = theFactory.getJTextField(this.getDefinition(), null);
            this.contents = text;
            toolsSwingManager.addClearButton(text);
            this.fixPreferredWidth(this.contents);
            this.dropDown = null;
            text.getDocument().addDocumentListener(this.documentListener);
        } else {
            DynObjectValueItem[] availableValues = this.getAvailableValues();
            if (availableValues == null) {
                this.dropDown = null;
                JTextComponent text = this.getComponentsFactory().getJTextField(this.getDefinition(), null);
                this.contents = text;
                toolsSwingManager.addClearButton(text);
                this.fixPreferredWidth(this.contents);
                text.getDocument().addDocumentListener(this.documentListener);
            } else {
                String dropdownType;
                switch (dropdownType = this.getTagValueAsString("dynform.dropdown", availableValues.length <= 20 ? "text" : "combo").toLowerCase().trim()) {
                    case "text": {
                        JTextComponent text = this.getComponentsFactory().getJTextField(this.getDefinition(), "Ddn");
                        this.dropDown = ToolsSwingLocator.getToolsSwingManager().createDropDown((JComponent)text);
                        this.dropDown.setModel(new DefaultComboBoxModel<DynObjectValueItem>(this.getAvailableValues()));
                        if (this.getDefinition().isAvailableValuesCalculated()) {
                            this.dropDown.addDropdownListener(e -> this.updateValuesOfDropDown());
                        }
                        text.setEditable(true);
                        this.dropDown.setVisibleDropdownArrow(true);
                        this.contents = text;
                        this.fixPreferredWidth(this.contents);
                        break;
                    }
                    case "label": {
                        JLabel label = this.getComponentsFactory().getJLabel(this.getDefinition(), "Ddn");
                        this.dropDown = ToolsSwingLocator.getToolsSwingManager().createDropDown(label);
                        this.dropDown.setModel(new DefaultComboBoxModel<DynObjectValueItem>(this.getAvailableValues()));
                        if (this.getDefinition().isAvailableValuesCalculated()) {
                            this.dropDown.addDropdownListener(e -> this.updateValuesOfDropDown());
                        }
                        this.dropDown.setVisibleDropdownArrow(true);
                        label.setBorder(BorderFactory.createLineBorder(UIManager.getColor("TextField.darkShadow")));
                        label.setForeground(UIManager.getColor("TextField.foreground"));
                        label.setBackground(UIManager.getColor("TextField.background"));
                        label.setOpaque(true);
                        this.contents = label;
                        this.fixPreferredWidth(this.contents);
                        break;
                    }
                    default: {
                        JComboBox combo = this.getComponentsFactory().getJComboBox(this.getDefinition(), null);
                        this.dropDown = ToolsSwingLocator.getToolsSwingManager().createDropDown(combo);
                        this.dropDown.setModel(new DefaultComboBoxModel<DynObjectValueItem>(this.getAvailableValues()));
                        if (this.getDefinition().isAvailableValuesCalculated()) {
                            this.dropDown.addDropdownListener(e -> this.updateValuesOfDropDown());
                        }
                        this.contents = combo;
                        this.fixPreferredWidth(this.contents);
                        break;
                    }
                }
                this.dropDown.addItemListener(this.dropDownListener);
            }
        }
        this.contents.setFocusable(true);
        this.contents.addFocusListener(this);
        this.setReadOnly(this.readOnly);
        this.setValue(this.assignedValue);
    }

    private void updateValuesOfDropDown() {
        DynObjectValueItem[] availableValues = this.getAvailableValues();
        this.updateValuesOfDropDown(availableValues);
    }

    public void updateValuesOfDropDown(Object availableValues) {
        DynObjectValueItem[] x = DynObjectUtils.getAvailableValuesFrom((Object)availableValues);
        this.updateValuesOfDropDown(x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateValuesOfDropDown(DynObjectValueItem[] availableValues) {
        if (this.dropDown == null) {
            return;
        }
        this.dropDown.removeItemListener(this.dropDownListener);
        try {
            boolean modelChanged = this.isTheModelGoingToChange(availableValues);
            Object value = this.dropDown.getSelectedItem();
            this.dropDown.setModel(new DefaultComboBoxModel<DynObjectValueItem>(availableValues));
            if (value == null) {
                this.dropDown.setSelectedIndex(-1);
            } else {
                this.dropDown.setValue(value);
                if (this.dropDown.getSelectedIndex() < 0) {
                    if (modelChanged) {
                        this.setValue(null);
                        this.problemIndicator().clear();
                    } else {
                        this.problemIndicator().set("The value (" + Objects.toString(value) + ") isn't in available values");
                    }
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't update values of drop down of field '" + this.getName() + "'.", (Throwable)ex);
            this.problemIndicator().set("Can't update list of values");
        }
        finally {
            this.dropDown.addItemListener(this.dropDownListener);
        }
    }

    private boolean isTheModelGoingToChange(DynObjectValueItem[] availableValues) {
        ComboBoxModel currentValues = this.getDropDown().getModel();
        if (currentValues.getSize() != availableValues.length) {
            return true;
        }
        for (int i = 0; i < currentValues.getSize(); ++i) {
            DynObjectValueItem newValue = availableValues[i];
            Object currentValue = currentValues.getElementAt(i);
            if (newValue.equals(currentValue)) continue;
            return true;
        }
        return false;
    }

    private void updateProblemIndicator() {
        try {
            Object value = this.getDefinition().coerce((Object)this.getValueFromJComponent());
            this.getDefinition().validate(value);
            this.problemIndicator().clear();
        }
        catch (DynFieldValidateException ex) {
            this.problemIndicator().set(ex.getLocalizedMessageStack());
        }
        catch (Exception ex) {
            this.problemIndicator().set(ex.getLocalizedMessage());
        }
    }

    @Override
    public void setReadOnly(boolean readonly) {
        if (!readonly && this.isForcedReadOnly()) {
            readonly = true;
        }
        if (this.dropDown == null) {
            super.setReadOnly(readonly);
        } else {
            this.readOnly = readonly;
            if (this.jlabel != null) {
                this.jlabel.setEnabled(!readonly);
            }
            this.dropDown.setReadOnly(readonly);
        }
        this.setReadOnlyButtonsOfEvents(readonly);
    }

    public String getValueFromJComponent() {
        Object s;
        if (this.dropDown == null) {
            JSpinner jspinner;
            JTextField jtext = this.getJTextField();
            s = jtext == null ? ((jspinner = this.getJSpinnerField()) == null ? null : Objects.toString(jspinner.getValue(), null)) : jtext.getText();
        } else {
            Object selectedItem = this.dropDown.getSelectedItem();
            if (selectedItem == null) {
                s = null;
            } else if (selectedItem instanceof DynObjectValueItem) {
                DynObjectValueItem value = (DynObjectValueItem)selectedItem;
                s = Objects.toString(value.getValue(), null);
            } else {
                s = (String)selectedItem;
            }
        }
        if (StringUtils.isBlank((CharSequence)s) && this.translateEmptyToNull()) {
            return null;
        }
        return s;
    }

    public String getFromJComponent() {
        Object s;
        if (this.dropDown == null) {
            JSpinner jspinner;
            JTextField jtext = this.getJTextField();
            s = jtext == null ? ((jspinner = this.getJSpinnerField()) == null ? null : Objects.toString(jspinner.getValue(), null)) : jtext.getText();
        } else {
            Object selectedItem = this.dropDown.getSelectedItem();
            if (selectedItem == null) {
                s = null;
            } else if (selectedItem instanceof DynObjectValueItem) {
                DynObjectValueItem value = (DynObjectValueItem)selectedItem;
                s = Objects.toString(value.getLabel(), null);
            } else {
                s = (String)selectedItem;
            }
        }
        if (StringUtils.isBlank((CharSequence)s) && this.translateEmptyToNull()) {
            return null;
        }
        return s;
    }

    public void setValue(Object value) {
        this.problemIndicator().clear();
        if (this.dropDown == null) {
            JTextField jtext = this.getJTextField();
            if (jtext != null) {
                this.setTranslateEmptyToNull(value == null);
                try {
                    jtext.getDocument().removeDocumentListener(this.documentListener);
                    jtext.setText(Objects.toString(value, ""));
                }
                finally {
                    jtext.getDocument().addDocumentListener(this.documentListener);
                }
                this.fixPreferredWidth(jtext);
            } else if (this.contents instanceof JSpinner) {
                JSpinner jspinner = this.getJSpinnerField();
                jspinner.removeChangeListener(this.spinnerListener);
                this.setTranslateEmptyToNull(value == null);
                jspinner.setValue(value);
                jspinner.addChangeListener(this.spinnerListener);
            }
        } else {
            this.dropDown.removeItemListener(this.dropDownListener);
            if (value == null) {
                this.dropDown.setSelectedIndex(-1);
            } else {
                this.dropDown.setValue(value);
                if (this.dropDown.getSelectedIndex() < 0) {
                    this.problemIndicator().set("The value isn't in available values");
                }
            }
            this.dropDown.addItemListener(this.dropDownListener);
            this.updateDependantFields();
        }
        try {
            this.getDefinition().validate(value);
            this.assignedValue = this.getDefinition().coerce(value);
        }
        catch (DynFieldValidateException e) {
            this.problemIndicator().set(e.getLocalizedMessageStack());
        }
        catch (CoercionException ex) {
            this.problemIndicator().set(BaseException.getMessageStack((Throwable)ex, (int)0));
        }
    }

    private void updateDependantFields() {
        try {
            Object[] dependentFieldNames = this.getDependentFieldNames();
            if (!ArrayUtils.isEmpty((Object[])dependentFieldNames)) {
                JDynForm theForm = this.getForm();
                for (Object name : dependentFieldNames) {
                    JDynFormField field = (JDynFormField)theForm.get(name);
                    if (!(field instanceof AbstractJDynFormFieldWithValueList)) continue;
                    ((AbstractJDynFormFieldWithValueList)field).updateValuesOfDropDown();
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't update dependent fields", (Throwable)ex);
        }
    }

    private String[] getDependentFieldNames() {
        try {
            String names = this.getDefinition().getTags().getString("dynform.dependentFields");
            if (StringUtils.isBlank((CharSequence)names)) {
                return null;
            }
            String[] r = StringUtils.split((String)names, (String)",");
            return r;
        }
        catch (CoercionException ex) {
            return null;
        }
    }

    protected String getDefaultValue() {
        return "";
    }

    public Object getValue() {
        Object value = null;
        String s = this.getValueFromJComponent();
        try {
            value = this.getDefinition().coerce((Object)s);
        }
        catch (CoercionException e) {
            throw new AbstractJDynFormField.IllegalFieldValue(this, this, "Can't convert value '" + s + "' to '" + this.getDefinition().getDataType().getName() + "'.");
        }
        this.problemIndicator().clear();
        return value;
    }

    public boolean hasValidValue() {
        try {
            Object value = this.getValue();
            this.getDefinition().validate(value);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String getJTextFieldRegex() {
        return "[*]";
    }

    public class KeyAdapterRegEx
    extends KeyAdapter {
        @Override
        public void keyReleased(KeyEvent e) {
            String curText = ((JTextComponent)e.getSource()).getText();
            curText = curText.replaceAll(AbstractJDynFormFieldWithValueList.this.getJTextFieldRegex(), "");
            ((JTextComponent)e.getSource()).setText(curText);
        }
    }
}

