/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.gdal.io;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.gdal.gdal.gdal;
import org.gdal.ogr.ogr;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.BandList;
import org.gvsig.fmap.dal.coverage.datastruct.ColorItem;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.fmap.dal.coverage.util.FileUtils;
import org.gvsig.jgdal.GdalBuffer;
import org.gvsig.jgdal.GdalColorEntry;
import org.gvsig.jgdal.GdalColorTable;
import org.gvsig.jgdal.GdalDataset;
import org.gvsig.jgdal.GdalException;
import org.gvsig.jgdal.GdalRasterBand;
import org.gvsig.jgdal.GeoTransform;
import org.gvsig.raster.impl.datastruct.ColorItemImpl;
import org.gvsig.raster.impl.datastruct.DefaultNoData;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.process.RasterTask;
import org.gvsig.raster.impl.process.RasterTaskQueue;
import org.gvsig.raster.impl.store.properties.DataStoreColorInterpretation;
import org.gvsig.raster.impl.store.properties.DataStoreColorTable;
import org.gvsig.raster.impl.store.properties.DataStoreMetadata;
import org.gvsig.raster.impl.store.properties.DataStoreTransparency;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.task.TaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GdalDataSource
extends GdalDataset
implements Disposable {
    private String fileName = null;
    private String shortName = "";
    public GeoTransform trans = null;
    public int width = 0;
    public int height = 0;
    public double originX = 0.0;
    public double originY = 0.0;
    public String version = "";
    protected int rBandNr = 1;
    protected int gBandNr = 2;
    protected int bBandNr = 3;
    protected int aBandNr = 4;
    private int[] dataType = null;
    DataStoreMetadata metadata = null;
    protected boolean georeferenced = true;
    private static final Logger logger = LoggerFactory.getLogger(GdalDataSource.class);
    public int[] stepArrayX = null;
    public int[] stepArrayY = null;
    protected GdalRasterBand[] gdalBands = null;
    private double lastReadLine = -1.0;
    private int overviewWidth = -1;
    private int overviewHeight = -1;
    private int currentViewWidth = -1;
    private int currentViewHeight = -1;
    private double currentViewX = 0.0;
    private double viewportScaleX = 0.0;
    private double viewportScaleY = 0.0;
    private double stepX = 0.0;
    private double stepY = 0.0;
    public boolean isSupersampling = false;
    private boolean open = false;
    protected DataStoreTransparency fileTransparency = null;
    protected DataStoreColorTable palette = null;
    protected DataStoreColorInterpretation colorInterpr = null;
    protected AffineTransform ownTransformation = null;
    protected AffineTransform externalTransformation = new AffineTransform();
    int currentOverview = -1;
    int lastY = -1;

    public static int getGdalTypeFromRasterBufType(int rasterBufType) {
        switch (rasterBufType) {
            case 0: {
                return GdalDataset.GDT_Byte;
            }
            case 1: {
                return GdalDataset.GDT_UInt16;
            }
            case 2: {
                return GdalDataset.GDT_Int16;
            }
            case 3: {
                return GdalDataset.GDT_Int32;
            }
            case 4: {
                return GdalDataset.GDT_Float32;
            }
            case 5: {
                return GdalDataset.GDT_Float64;
            }
            case 32: {
                return GdalDataset.GDT_Unknown;
            }
            case -1: {
                return GdalDataset.GDT_Byte;
            }
        }
        return GdalDataset.GDT_Unknown;
    }

    public static int getRasterBufTypeFromGdalType(int gdalType) {
        switch (gdalType) {
            case 1: {
                return 0;
            }
            case 3: {
                return 2;
            }
            case 2: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 5;
            }
            case 4: {
                return 3;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return 32;
            }
        }
        return 32;
    }

    public GdalDataSource(String fName) throws GdalException, IOException {
        this.init(fName);
    }

    private void init(String fName) throws GdalException, IOException {
        int i;
        gdal.AllRegister();
        ogr.RegisterAll();
        this.fileName = fName;
        this.open(fName, GA_ReadOnly);
        this.open = true;
        if (this.getDataset() == null) {
            throw new GdalException("Error en la apertura del fichero. El fichero no tiene un formato v?lido.");
        }
        this.width = this.getRasterXSize();
        this.height = this.getRasterYSize();
        int[] dt = new int[this.getRasterCount()];
        for (i = 0; i < this.getRasterCount(); ++i) {
            dt[i] = this.getRasterBand(i + 1).getRasterDataType();
        }
        this.setDataType(dt);
        this.shortName = this.getDriverShortName();
        this.colorInterpr = new DataStoreColorInterpretation(this.getRasterCount());
        this.fileTransparency = new DataStoreTransparency((ColorInterpretation)this.colorInterpr);
        this.metadata = new DataStoreMetadata(this.getMetadata(), this.colorInterpr);
        this.metadata.initNoDataByBand(this.getRasterCount());
        for (i = 0; i < this.getRasterCount(); ++i) {
            GdalRasterBand rb = this.getRasterBand(i + 1);
            String colorInt = this.getColorInterpretationName(rb.getRasterColorInterpretation());
            this.metadata.setNoDataEnabled(rb.existsNoDataValue());
            if (rb.existsNoDataValue()) {
                this.metadata.setNoDataValue(i, rb.getRasterNoDataValue());
                this.metadata.setNoDataEnabled(rb.existsNoDataValue());
            }
            this.colorInterpr.setColorInterpValue(i, colorInt);
            if (colorInt.equals("Alpha")) {
                this.fileTransparency.setTransparencyBand(i);
            }
            if (rb.getRasterColorTable() == null || this.palette != null) continue;
            this.palette = new DataStoreColorTable(this.gdalColorTable2ColorItems(rb.getRasterColorTable()), false);
        }
        this.fileTransparency.setTransparencyByPixelFromMetadata(this.metadata);
        try {
            this.trans = this.getGeoTransform();
            if (!this.trans.isValid()) {
                throw new GeoTransform.GeoTransformException();
            }
            double psX = this.trans.adfgeotransform[1];
            double psY = this.trans.adfgeotransform[5];
            double rotX = this.trans.adfgeotransform[4];
            double rotY = this.trans.adfgeotransform[2];
            double offX = this.trans.adfgeotransform[0];
            double offY = this.trans.adfgeotransform[3];
            this.ownTransformation = new AffineTransform(psX, rotX, rotY, psY, offX, offY);
            this.externalTransformation = (AffineTransform)this.ownTransformation.clone();
            this.overviewWidth = this.width;
            this.overviewHeight = this.height;
            this.georeferenced = true;
        }
        catch (GeoTransform.GeoTransformException exc) {
            logger.warn("Can't retrieve transformation from file '" + fName + "' use default.");
            this.ownTransformation = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, this.height);
            this.externalTransformation = (AffineTransform)this.ownTransformation.clone();
            this.overviewWidth = this.width;
            this.overviewHeight = this.height;
            this.georeferenced = false;
        }
        catch (Exception exc) {
            logger.warn("Can't retrieve transformation from file '" + fName + "' use default.", (Throwable)exc);
            this.ownTransformation = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, this.height);
            this.externalTransformation = (AffineTransform)this.ownTransformation.clone();
            this.overviewWidth = this.width;
            this.overviewHeight = this.height;
            this.georeferenced = false;
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean existsNoDataValue() throws GdalException {
        for (int i = 0; i < this.getRasterCount(); ++i) {
            GdalRasterBand rb = this.getRasterBand(i + 1);
            if (!rb.existsNoDataValue()) continue;
            return true;
        }
        return false;
    }

    public boolean existsNoDataValue(int band) throws GdalException {
        GdalRasterBand rb = this.getRasterBand(band + 1);
        return rb.existsNoDataValue();
    }

    public NoData getNoDataValue() {
        Number value = null;
        int type = GdalDataSource.getRasterBufTypeFromGdalType(this.getDataType()[0]);
        if (this.metadata != null && this.metadata.isNoDataEnabled() && this.metadata.getNoDataValue().length > 0) {
            switch (type) {
                case 0: {
                    if (this.metadata == null || this.metadata.getNoDataValue().length == 0) {
                        value = new Byte(RasterLibrary.defaultByteNoDataValue);
                        break;
                    }
                    value = new Byte((byte)this.metadata.getNoDataValue()[0]);
                    break;
                }
                case 2: {
                    if (this.metadata == null || this.metadata.getNoDataValue().length == 0) {
                        value = new Short(RasterLibrary.defaultShortNoDataValue);
                        break;
                    }
                    value = new Short((short)this.metadata.getNoDataValue()[0]);
                    break;
                }
                case 3: {
                    if (this.metadata == null || this.metadata.getNoDataValue().length == 0) {
                        value = new Integer(RasterLibrary.defaultIntegerNoDataValue);
                        break;
                    }
                    value = new Integer((int)this.metadata.getNoDataValue()[0]);
                    break;
                }
                case 4: {
                    if (this.metadata == null || this.metadata.getNoDataValue().length == 0) {
                        value = new Float(RasterLibrary.defaultFloatNoDataValue);
                        break;
                    }
                    value = new Float(this.metadata.getNoDataValue()[0]);
                    break;
                }
                case 5: {
                    value = this.metadata == null || this.metadata.getNoDataValue().length == 0 ? new Double(RasterLibrary.defaultFloatNoDataValue) : new Double(this.metadata.getNoDataValue()[0]);
                }
            }
        }
        DefaultNoData nodata = new DefaultNoData(value, value, this.fileName);
        nodata.setNoDataTransparent(false);
        return nodata;
    }

    public void setDataType(int[] dt) {
        this.dataType = dt;
    }

    public int[] getDataType() {
        return this.dataType;
    }

    public ColorInterpretation getColorInterpretation() {
        return this.colorInterpr;
    }

    public ColorTable getColorTable() {
        return this.palette;
    }

    public Point2D worldToRasterWithoutRot(Point2D pt) {
        Point2D.Double p = new Point2D.Double();
        AffineTransform at = new AffineTransform(this.externalTransformation.getScaleX(), 0.0, 0.0, this.externalTransformation.getScaleY(), this.externalTransformation.getTranslateX(), this.externalTransformation.getTranslateY());
        try {
            at.inverseTransform(pt, p);
        }
        catch (NoninvertibleTransformException e) {
            return pt;
        }
        return p;
    }

    public Point2D worldToRaster(Point2D pt) {
        Point2D.Double p = new Point2D.Double();
        try {
            this.externalTransformation.inverseTransform(pt, p);
        }
        catch (NoninvertibleTransformException e) {
            return pt;
        }
        return p;
    }

    public Point2D rasterToWorld(Point2D pt) {
        Point2D.Double p = new Point2D.Double();
        this.externalTransformation.transform(pt, p);
        return p;
    }

    private void calcOverview(Point2D tl, Point2D br) throws GdalException {
        this.gdalBands[0] = this.getRasterBand(1);
        this.currentOverview = -1;
        if (this.gdalBands[0].getOverviewCount() > 0) {
            GdalRasterBand ovb = null;
            for (int i = this.gdalBands[0].getOverviewCount() - 1; i > 0; --i) {
                ovb = this.gdalBands[0].getOverview(i);
                if (!((double)ovb.getRasterBandXSize() > (double)this.getRasterXSize() * this.viewportScaleX)) continue;
                this.currentOverview = i;
                this.viewportScaleX *= (double)this.width / (double)ovb.getRasterBandXSize();
                this.viewportScaleY *= (double)this.height / (double)ovb.getRasterBandYSize();
                this.stepX = 1.0 / this.viewportScaleX;
                this.stepY = 1.0 / this.viewportScaleY;
                this.overviewWidth = ovb.getRasterBandXSize();
                this.overviewHeight = ovb.getRasterBandYSize();
                this.currentViewX = Math.min(tl.getX(), br.getX());
                this.lastReadLine = Math.min(tl.getY(), br.getY());
                break;
            }
        }
    }

    public void setView(double dWorldTLX, double dWorldTLY, double dWorldBRX, double dWorldBRY, int nWidth, int nHeight) throws GdalException {
        this.overviewWidth = this.width;
        this.overviewHeight = this.height;
        Point2D tl = this.worldToRaster(new Point2D.Double(dWorldTLX, dWorldTLY));
        Point2D br = this.worldToRaster(new Point2D.Double(dWorldBRX, dWorldBRY));
        this.currentViewWidth = nWidth;
        this.currentViewHeight = nHeight;
        this.currentViewX = Math.min(tl.getX(), br.getX());
        this.viewportScaleX = (double)this.currentViewWidth / (br.getX() - tl.getX());
        this.viewportScaleY = (double)this.currentViewHeight / (br.getY() - tl.getY());
        this.stepX = 1.0 / this.viewportScaleX;
        this.stepY = 1.0 / this.viewportScaleY;
        this.lastReadLine = Math.min(tl.getY(), br.getY());
        this.gdalBands = new GdalRasterBand[4];
        this.calcOverview(tl, br);
    }

    public void selectGdalBands(int nbands) throws GdalException {
        int i;
        this.gdalBands = new GdalRasterBand[nbands];
        this.gdalBands[0] = this.getRasterBand(1);
        for (i = 0; i < nbands; ++i) {
            this.gdalBands[i] = this.gdalBands[0];
        }
        this.assignDataTypeFromGdalRasterBands(this.gdalBands);
        for (i = 2; i <= nbands; ++i) {
            if (this.getRasterCount() < i) continue;
            this.gdalBands[i - 1] = this.getRasterBand(i);
            for (int j = i; j < nbands; ++j) {
                this.gdalBands[j] = this.gdalBands[i - 1];
            }
        }
        if (this.currentOverview > 0) {
            this.gdalBands[0] = this.gdalBands[0].getOverview(this.currentOverview);
            for (i = 2; i <= nbands; ++i) {
                if (this.getRasterCount() < i) continue;
                this.gdalBands[i - 1] = this.gdalBands[i - 1].getOverview(this.currentOverview);
            }
        }
    }

    private void readLine(byte[][] line, double initOffset, GdalBuffer[] gdalBuffer) {
        double j = 0.0;
        int i = 0;
        for (int iBand = 0; iBand < gdalBuffer.length; ++iBand) {
            i = 0;
            for (j = initOffset; i < this.currentViewWidth && j < (double)gdalBuffer[0].getSize(); ++i, j += this.stepX) {
                line[iBand][i] = gdalBuffer[iBand].buffByte[(int)j];
            }
        }
    }

    private void readLine(short[][] line, double initOffset, GdalBuffer[] gdalBuffer) {
        double j = 0.0;
        int i = 0;
        for (int iBand = 0; iBand < gdalBuffer.length; ++iBand) {
            i = 0;
            for (j = initOffset; i < this.currentViewWidth && j < (double)gdalBuffer[0].getSize(); ++i, j += this.stepX) {
                line[iBand][i] = (short)(gdalBuffer[iBand].buffShort[(int)j] & 0xFFFF);
            }
        }
    }

    private void readLine(int[][] line, double initOffset, GdalBuffer[] gdalBuffer) {
        double j = 0.0;
        int i = 0;
        for (int iBand = 0; iBand < gdalBuffer.length; ++iBand) {
            i = 0;
            for (j = initOffset; i < this.currentViewWidth && j < (double)gdalBuffer[0].getSize(); ++i, j += this.stepX) {
                line[iBand][i] = gdalBuffer[iBand].buffInt[(int)j] & 0xFFFFFFFF;
            }
        }
    }

    private void readLine(float[][] line, double initOffset, GdalBuffer[] gdalBuffer) {
        double j = 0.0;
        int i = 0;
        for (int iBand = 0; iBand < gdalBuffer.length; ++iBand) {
            i = 0;
            for (j = initOffset; i < this.currentViewWidth && j < (double)gdalBuffer[0].getSize(); ++i, j += this.stepX) {
                line[iBand][i] = gdalBuffer[iBand].buffFloat[(int)j];
            }
        }
    }

    private void readLine(double[][] line, double initOffset, GdalBuffer[] gdalBuffer) {
        double j = 0.0;
        int i = 0;
        for (int iBand = 0; iBand < gdalBuffer.length; ++iBand) {
            i = 0;
            for (j = initOffset; i < this.currentViewWidth && j < (double)gdalBuffer[0].getSize(); ++i, j += this.stepX) {
                line[iBand][i] = gdalBuffer[iBand].buffDouble[(int)j];
            }
        }
    }

    public Object readCompleteLine(int nLine, int band) throws GdalException {
        GdalRasterBand gdalBand = super.getRasterBand(band + 1);
        GdalBuffer gdalBuf = null;
        gdalBuf = gdalBand.readRaster(0, nLine, this.getRasterXSize(), 1, this.getRasterXSize(), 1, this.dataType[band]);
        if (this.dataType[band] == GDT_Byte) {
            return gdalBuf.buffByte;
        }
        if (this.dataType[band] == GDT_Int16 || this.dataType[band] == GDT_UInt16) {
            return gdalBuf.buffShort;
        }
        if (this.dataType[band] == GDT_Int32 || this.dataType[band] == GDT_UInt32) {
            return gdalBuf.buffInt;
        }
        if (this.dataType[band] == GDT_Float32) {
            return gdalBuf.buffFloat;
        }
        if (this.dataType[band] == GDT_Float64) {
            return gdalBuf.buffDouble;
        }
        if (this.dataType[band] == GDT_CInt16 || this.dataType[band] == GDT_CInt32 || this.dataType[band] == GDT_CFloat32 || this.dataType[band] == GDT_CFloat64) {
            return null;
        }
        return null;
    }

    public Object readBlock(int pos, int blockHeight, double scale) throws GdalException, ProcessInterruptedException {
        this.bBandNr = super.getRasterCount();
        int widthBuffer = (int)((double)this.getRasterXSize() * scale);
        int heightBuffer = (int)((double)blockHeight * scale);
        RasterTask task = RasterTaskQueue.get((String)(Thread.currentThread().getId() + ""));
        GdalRasterBand[] gdalBand = new GdalRasterBand[this.bBandNr];
        for (int iBand = 0; iBand < gdalBand.length; ++iBand) {
            gdalBand[iBand] = super.getRasterBand(iBand + 1);
        }
        GdalBuffer[] gdalBuf = new GdalBuffer[this.bBandNr];
        if (this.dataType[0] == GDT_Byte) {
            byte[][][] buf = new byte[this.bBandNr][heightBuffer][widthBuffer];
            for (int iBand = 0; iBand < gdalBuf.length; ++iBand) {
                gdalBuf[iBand] = gdalBand[iBand].readRaster(0, pos, this.getRasterXSize(), blockHeight, widthBuffer, heightBuffer, this.dataType[0]);
                for (int iRow = 0; iRow < heightBuffer; ++iRow) {
                    for (int iCol = 0; iCol < widthBuffer; ++iCol) {
                        buf[iBand][iRow][iCol] = gdalBuf[iBand].buffByte[iRow * widthBuffer + iCol];
                    }
                    if (task.getEvent() == null) continue;
                    task.manageEvent(task.getEvent());
                }
                gdalBuf[iBand].buffByte = null;
            }
            return buf;
        }
        if (this.dataType[0] == GDT_CInt16 || this.dataType[0] == GDT_Int16 || this.dataType[0] == GDT_UInt16) {
            short[][][] buf = new short[this.bBandNr][heightBuffer][widthBuffer];
            for (int iBand = 0; iBand < gdalBuf.length; ++iBand) {
                gdalBuf[iBand] = gdalBand[iBand].readRaster(0, pos, this.getRasterXSize(), blockHeight, widthBuffer, heightBuffer, this.dataType[0]);
                for (int iRow = 0; iRow < heightBuffer; ++iRow) {
                    for (int iCol = 0; iCol < widthBuffer; ++iCol) {
                        buf[iBand][iRow][iCol] = gdalBuf[iBand].buffShort[iRow * widthBuffer + iCol];
                    }
                    if (task.getEvent() == null) continue;
                    task.manageEvent(task.getEvent());
                }
                gdalBuf[iBand].buffShort = null;
            }
            return buf;
        }
        if (this.dataType[0] == GDT_CInt32 || this.dataType[0] == GDT_Int32 || this.dataType[0] == GDT_UInt32) {
            int[][][] buf = new int[this.bBandNr][heightBuffer][widthBuffer];
            for (int iBand = 0; iBand < gdalBuf.length; ++iBand) {
                gdalBuf[iBand] = gdalBand[iBand].readRaster(0, pos, this.getRasterXSize(), blockHeight, widthBuffer, heightBuffer, this.dataType[0]);
                for (int iRow = 0; iRow < heightBuffer; ++iRow) {
                    for (int iCol = 0; iCol < widthBuffer; ++iCol) {
                        buf[iBand][iRow][iCol] = gdalBuf[iBand].buffInt[iRow * widthBuffer + iCol];
                    }
                    if (task.getEvent() == null) continue;
                    task.manageEvent(task.getEvent());
                }
                gdalBuf[iBand].buffInt = null;
            }
            return buf;
        }
        if (this.dataType[0] == GDT_Float32 || this.dataType[0] == GDT_CFloat32) {
            float[][][] buf = new float[this.bBandNr][heightBuffer][widthBuffer];
            for (int iBand = 0; iBand < gdalBuf.length; ++iBand) {
                gdalBuf[iBand] = gdalBand[iBand].readRaster(0, pos, this.getRasterXSize(), blockHeight, widthBuffer, heightBuffer, this.dataType[0]);
                for (int iRow = 0; iRow < heightBuffer; ++iRow) {
                    for (int iCol = 0; iCol < widthBuffer; ++iCol) {
                        buf[iBand][iRow][iCol] = gdalBuf[iBand].buffFloat[iRow * widthBuffer + iCol];
                    }
                    if (task.getEvent() == null) continue;
                    task.manageEvent(task.getEvent());
                }
                gdalBuf[iBand].buffFloat = null;
            }
            return buf;
        }
        if (this.dataType[0] == GDT_Float64 || this.dataType[0] == GDT_CFloat64) {
            double[][][] buf = new double[this.bBandNr][heightBuffer][widthBuffer];
            for (int iBand = 0; iBand < gdalBuf.length; ++iBand) {
                gdalBuf[iBand] = gdalBand[iBand].readRaster(0, pos, this.getRasterXSize(), blockHeight, widthBuffer, heightBuffer, this.dataType[0]);
                for (int iRow = 0; iRow < heightBuffer; ++iRow) {
                    for (int iCol = 0; iCol < widthBuffer; ++iCol) {
                        buf[iBand][iRow][iCol] = gdalBuf[iBand].buffDouble[iRow * widthBuffer + iCol];
                    }
                    if (task.getEvent() == null) continue;
                    task.manageEvent(task.getEvent());
                }
                gdalBuf[iBand].buffDouble = null;
            }
            return buf;
        }
        return null;
    }

    public void readLine(Object line) throws GdalException {
        int y;
        int w = (int)(Math.ceil((double)this.currentViewWidth * this.stepX) + 1.0);
        int x = (int)this.currentViewX;
        GdalBuffer r = null;
        GdalBuffer g = null;
        GdalBuffer b = null;
        GdalBuffer a = new GdalBuffer();
        for (y = (int)this.lastReadLine; y >= this.gdalBands[0].getRasterBandYSize(); --y) {
        }
        if (x + w > this.gdalBands[0].getRasterBandXSize()) {
            w = this.gdalBands[0].getRasterBandXSize() - x;
        }
        if (this.gdalBands[0].getRasterColorTable() != null) {
            this.palette = new DataStoreColorTable(this.gdalColorTable2ColorItems(this.gdalBands[0].getRasterColorTable()), false);
            r = this.gdalBands[0].readRaster(x, y, w, 1, w, 1, this.dataType[0]);
        } else {
            a.buffByte = new byte[w];
            g = b = (r = this.gdalBands[0].readRaster(x, y, w, 1, w, 1, this.dataType[0]));
            if (this.getRasterCount() > 1 && this.gdalBands[1] != null) {
                g = this.gdalBands[1].readRaster(x, y, w, 1, w, 1, this.dataType[0]);
            }
            if (this.getRasterCount() > 2 && this.gdalBands[2] != null) {
                b = this.gdalBands[2].readRaster(x, y, w, 1, w, 1, this.dataType[0]);
            }
        }
        this.lastReadLine += this.stepY;
        double initOffset = Math.abs(this.currentViewX - (double)((int)this.currentViewX));
        GdalBuffer[] bands = new GdalBuffer[]{r, g, b};
        if (this.dataType[0] == GDT_Byte) {
            this.readLine((byte[][])line, initOffset, bands);
        } else if (this.dataType[0] == GDT_CInt16 || this.dataType[0] == GDT_Int16 || this.dataType[0] == GDT_UInt16) {
            this.readLine((short[][])line, initOffset, bands);
        } else if (this.dataType[0] == GDT_CInt32 || this.dataType[0] == GDT_Int32 || this.dataType[0] == GDT_UInt32) {
            this.readLine((int[][])line, initOffset, bands);
        } else if (this.dataType[0] == GDT_Float32 || this.dataType[0] == GDT_CFloat32) {
            this.readLine((float[][])line, initOffset, bands);
        } else if (this.dataType[0] == GDT_Float64 || this.dataType[0] == GDT_CFloat64) {
            this.readLine((double[][])line, initOffset, bands);
        }
    }

    private List<ColorItem> gdalColorTable2ColorItems(GdalColorTable table) {
        try {
            ArrayList<ColorItem> colorItems = new ArrayList<ColorItem>();
            for (int iEntry = 0; iEntry < table.getColorEntryCount(); ++iEntry) {
                GdalColorEntry entry = table.getColorEntryAsRGB(iEntry);
                ColorItemImpl colorItem = new ColorItemImpl();
                colorItem.setNameClass("");
                colorItem.setValue((double)iEntry);
                colorItem.setColor(new Color(entry.c1 & 0xFF, entry.c2 & 0xFF, entry.c3 & 0xFF, entry.c4 & 0xFF));
                colorItems.add((ColorItem)colorItem);
            }
            return colorItems;
        }
        catch (GdalException gdalException) {
            return null;
        }
    }

    private int[] calcStepBuffer(Extent dataExtent, int nWidth, int nHeight, int[] stpBuffer) {
        Extent imageExtent = this.getExtentWithoutRot();
        Extent ajustDataExtent = RasterLocator.getManager().getRasterUtils().calculateAdjustedView(dataExtent, imageExtent);
        if (!RasterLocator.getManager().getRasterUtils().compareExtents(dataExtent, ajustDataExtent)) {
            Point2D p1 = this.worldToRasterWithoutRot(new Point2D.Double(ajustDataExtent.minX(), ajustDataExtent.maxY()));
            Point2D p2 = this.worldToRasterWithoutRot(new Point2D.Double(ajustDataExtent.maxX(), ajustDataExtent.minY()));
            Point2D p3 = this.worldToRasterWithoutRot(new Point2D.Double(dataExtent.minX(), dataExtent.maxY()));
            int w = (int)Math.abs(Math.ceil(p2.getX()) - Math.floor(p1.getX()));
            int h = (int)Math.abs(Math.floor(p1.getY()) - Math.ceil(p2.getY()));
            stpBuffer[0] = (int)(p1.getX() + -p3.getX());
            stpBuffer[1] = (int)(p1.getY() + -p3.getY());
            stpBuffer[2] = stpBuffer[0] + w;
            stpBuffer[3] = stpBuffer[1] + h;
            return new int[]{w, h};
        }
        return new int[]{nWidth, nHeight};
    }

    public void readWindow(Buffer buf, BandList bandList, double ulx, double uly, double lrx, double lry, int nWidth, int nHeight, boolean adjustToExtent, TaskStatus status) throws GdalException, ProcessInterruptedException {
        ExtentImpl petExtent = new ExtentImpl(ulx, uly, lrx, lry);
        this.setView(ulx, uly, lrx, lry, nWidth, nHeight);
        Point2D tl = this.worldToRaster(new Point2D.Double(ulx, uly));
        Point2D br = this.worldToRaster(new Point2D.Double(lrx, lry));
        if (tl.getX() > br.getX()) {
            tl.setLocation(tl.getX() - 1.0, tl.getY());
        } else {
            br.setLocation(br.getX() - 1.0, br.getY());
        }
        if (tl.getY() > br.getY()) {
            tl.setLocation(tl.getX(), tl.getY() - 1.0);
        } else {
            br.setLocation(br.getX(), br.getY() - 1.0);
        }
        if (this.gdalBands.length == 0) {
            return;
        }
        this.selectGdalBands(this.getRasterCount());
        int x = (int)Math.round(Math.min(tl.getX(), br.getX()));
        int y = (int)Math.round(Math.min(tl.getY(), br.getY()));
        int[] stpBuffer = new int[]{0, 0, buf.getWidth(), buf.getHeight()};
        if (!adjustToExtent) {
            int[] wh = this.calcStepBuffer((Extent)petExtent, nWidth, nHeight, stpBuffer);
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            this.readDataCachedBuffer(buf, bandList, new int[]{x, y, wh[0], wh[1]}, wh[0], wh[1], 0, 0, stpBuffer, status);
            return;
        }
        this.readDataCachedBuffer(buf, bandList, new int[]{x, y, nWidth, nHeight}, nWidth, nHeight, 0, 0, stpBuffer, status);
    }

    public void readWindow(Buffer buf, BandList bandList, Extent ext, Rectangle adjustedWindow, TaskStatus status) throws GdalException, ProcessInterruptedException {
        this.setView(ext.getULX(), ext.getULY(), ext.getLRX(), ext.getLRY(), buf.getWidth(), buf.getHeight());
        if (this.gdalBands.length == 0) {
            return;
        }
        this.selectGdalBands(this.getRasterCount());
        int[] stpBuffer = new int[]{0, 0, buf.getWidth(), buf.getHeight()};
        adjustedWindow = this.getAdjustedWindowInOverviewCoordinates(adjustedWindow);
        this.readDataCachedBuffer(buf, bandList, new int[]{(int)adjustedWindow.getX(), (int)adjustedWindow.getY(), (int)adjustedWindow.getWidth(), (int)adjustedWindow.getHeight()}, buf.getWidth(), buf.getHeight(), 0, 0, stpBuffer, status);
    }

    private Rectangle getAdjustedWindowInOverviewCoordinates(Rectangle adjustedWindow) {
        int nWidth = (int)((long)adjustedWindow.getWidth() * (long)this.overviewWidth / (long)this.width);
        int nHeight = (int)((long)adjustedWindow.getHeight() * (long)this.overviewHeight / (long)this.height);
        int x = (int)((long)adjustedWindow.getX() * (long)this.overviewWidth / (long)this.width);
        int y = (int)((long)adjustedWindow.getY() * (long)this.overviewHeight / (long)this.height);
        return new Rectangle(x, y, nWidth, nHeight);
    }

    public void readWindow(Buffer buf, BandList bandList, double ulx, double uly, double lrx, double lry, double nWidth, double nHeight, int bufWidth, int bufHeight, boolean adjustToExtent, TaskStatus status) throws GdalException, ProcessInterruptedException {
        ExtentImpl petExtent = new ExtentImpl(ulx, uly, lrx, lry);
        this.setView(ulx, uly, lrx, lry, bufWidth, bufHeight);
        Point2D ul = this.worldToRaster(new Point2D.Double(ulx, uly));
        Point2D lr = this.worldToRaster(new Point2D.Double(lrx, lry));
        ul.setLocation(ul.getX() < 0.0 ? 1.0 : ul.getX(), ul.getY() < 0.0 ? 1.0 : ul.getY());
        lr.setLocation(lr.getX() < 0.0 ? 1.0 : lr.getX(), lr.getY() < 0.0 ? 1.0 : lr.getY());
        ul.setLocation(ul.getX() - 0.5, ul.getY() - 0.5);
        lr.setLocation(lr.getX() - 0.5, lr.getY() - 0.5);
        this.adjustPoints(ul, lr);
        if (this.gdalBands.length == 0) {
            return;
        }
        this.selectGdalBands(this.getRasterCount());
        Rectangle requestWindow = new Rectangle((int)Math.min(ul.getX(), lr.getX()), (int)Math.min(ul.getY(), lr.getY()), (int)nWidth, (int)nHeight);
        requestWindow = this.getAdjustedWindowInOverviewCoordinates(requestWindow);
        int[] stpBuffer = new int[]{0, 0, buf.getWidth(), buf.getHeight()};
        if (!adjustToExtent) {
            int[] wh = this.calcStepBuffer((Extent)petExtent, bufWidth, bufHeight, stpBuffer);
            if (requestWindow.getX() < 0.0) {
                requestWindow.setLocation(0, (int)requestWindow.getY());
            }
            if (requestWindow.getY() < 0.0) {
                requestWindow.setLocation((int)requestWindow.getX(), 0);
            }
            stpBuffer[0] = (int)((double)(stpBuffer[0] * bufWidth) / requestWindow.getWidth());
            stpBuffer[1] = (int)((double)(stpBuffer[1] * bufHeight) / requestWindow.getHeight());
            stpBuffer[2] = (int)((double)(stpBuffer[2] * bufWidth) / requestWindow.getWidth());
            stpBuffer[3] = (int)((double)(stpBuffer[3] * bufHeight) / requestWindow.getHeight());
            bufWidth = Math.abs(stpBuffer[2] - stpBuffer[0]);
            bufHeight = Math.abs(stpBuffer[3] - stpBuffer[1]);
            this.readDataCachedBuffer(buf, bandList, new int[]{(int)requestWindow.getX(), (int)requestWindow.getY(), wh[0], wh[1]}, bufWidth, bufHeight, 0, 0, stpBuffer, status);
            return;
        }
        if (requestWindow.getX() + requestWindow.getWidth() > (double)this.gdalBands[0].getRasterBandXSize()) {
            requestWindow.setSize((int)((double)this.gdalBands[0].getRasterBandXSize() - requestWindow.getX()), (int)requestWindow.getHeight());
        }
        if (requestWindow.getY() + requestWindow.getHeight() > (double)this.gdalBands[0].getRasterBandYSize()) {
            requestWindow.setSize((int)requestWindow.getWidth(), (int)((double)this.gdalBands[0].getRasterBandYSize() - requestWindow.getY()));
        }
        this.readDataCachedBuffer(buf, bandList, new int[]{(int)requestWindow.getX(), (int)requestWindow.getY(), (int)requestWindow.getWidth(), (int)requestWindow.getHeight()}, bufWidth, bufHeight, 0, 0, stpBuffer, status);
    }

    private void adjustPoints(Point2D ul, Point2D lr) {
        double a = ul.getX() - (double)((int)ul.getX());
        double b = ul.getY() - (double)((int)ul.getY());
        ul.setLocation(a > 0.95 || a < 0.05 ? (double)Math.round(ul.getX()) : ul.getX(), b > 0.95 || b < 0.05 ? (double)Math.round(ul.getY()) : ul.getY());
        lr.setLocation(a > 0.95 || a < 0.05 ? (double)Math.round(lr.getX()) : lr.getX(), b > 0.95 || b < 0.05 ? (double)Math.round(lr.getY()) : lr.getY());
    }

    public void readWindow(Buffer buf, BandList bandList, int x, int y, int w, int h, TaskStatus status) throws GdalException, ProcessInterruptedException {
        this.gdalBands = new GdalRasterBand[this.getRasterCount()];
        if (buf.getWidth() == w && buf.getHeight() == h) {
            this.isSupersampling = false;
        }
        if (this.gdalBands.length == 0) {
            return;
        }
        this.gdalBands[0] = this.getRasterBand(1);
        for (int iBand = 1; iBand < this.gdalBands.length; ++iBand) {
            this.gdalBands[iBand] = this.getRasterBand(iBand + 1);
        }
        this.assignDataTypeFromGdalRasterBands(this.gdalBands);
        int[] stpBuffer = new int[]{0, 0, buf.getWidth(), buf.getHeight()};
        this.readDataCachedBuffer(buf, bandList, new int[]{x, y, w, h}, buf.getWidth(), buf.getHeight(), 0, 0, stpBuffer, status);
    }

    private void assignDataTypeFromGdalRasterBands(GdalRasterBand[] gdalBands) throws GdalException {
        int[] dt = new int[gdalBands.length];
        for (int i = 0; i < gdalBands.length; ++i) {
            if (gdalBands[i] == null) continue;
            dt[i] = gdalBands[i].getRasterDataType();
        }
        this.setDataType(dt);
    }

    private void readDataCachedBuffer(Buffer buf, BandList bandList, int[] inputWindow, int bufWidth, int bufHeight, int stpX, int stpY, int[] stepBuffer, TaskStatus status) throws GdalException, ProcessInterruptedException {
        if (buf.isCached()) {
            int nBlocks = buf.getHeight() / buf.getBlockHeight();
            int lastblock = buf.getHeight() - nBlocks * buf.getBlockHeight();
            if (lastblock > 0) {
                ++nBlocks;
            }
            int initYSrc = inputWindow[1];
            int stepYSrc = buf.getBlockHeight() * inputWindow[3] / buf.getHeight();
            int lastBlockYSrc = lastblock * inputWindow[3] / buf.getHeight();
            int initYBuffer = 0;
            for (int i = 0; i < nBlocks; ++i) {
                int[] newWindow;
                int[] newStepBuffer;
                if (lastblock > 0 && i == nBlocks - 1) {
                    newStepBuffer = new int[]{0, initYBuffer, stepBuffer[2], initYBuffer + lastblock};
                    newWindow = new int[]{inputWindow[0], initYSrc, inputWindow[2], lastBlockYSrc};
                    this.readData(buf, bandList, newWindow, bufWidth, lastblock, 0, 0, newStepBuffer);
                    continue;
                }
                newStepBuffer = new int[]{0, initYBuffer, stepBuffer[2], initYBuffer + buf.getBlockHeight()};
                newWindow = new int[]{inputWindow[0], initYSrc, inputWindow[2], stepYSrc};
                this.readData(buf, bandList, newWindow, bufWidth, buf.getBlockHeight(), 0, 0, newStepBuffer);
                initYSrc += stepYSrc;
                initYBuffer += buf.getBlockHeight();
            }
        } else {
            this.readData(buf, bandList, inputWindow, bufWidth, bufHeight, 0, 0, stepBuffer);
        }
    }

    private void readData(Buffer buf, BandList bandList, int[] inputWindow, int bufWidth, int bufHeight, int stpX, int stpY, int[] stepBuffer) throws GdalException, ProcessInterruptedException {
        RasterTask task = RasterTaskQueue.get((String)(Thread.currentThread().getId() + ""));
        FileUtils fUtil = RasterLocator.getManager().getFileUtils();
        GdalBuffer gdalBuf = null;
        for (int iBand = 0; iBand < this.gdalBands.length; ++iBand) {
            int i;
            int col;
            int line;
            int init;
            int[] drawableBands = bandList.getBufferBandToDraw(this.fileName, iBand);
            if (drawableBands == null || drawableBands.length == 1 && drawableBands[0] == -1) continue;
            int pos = init = bufWidth * stpY + stpX;
            gdalBuf = this.gdalBands[iBand].readRaster(inputWindow[0], inputWindow[1], inputWindow[2], inputWindow[3], bufWidth, bufHeight, this.dataType[iBand]);
            int lineInputWindow = 0;
            if (this.dataType[iBand] == GdalDataset.GDT_Byte) {
                for (line = stepBuffer[1]; line < stepBuffer[3]; ++line) {
                    pos = bufWidth * (lineInputWindow - stepBuffer[0]) + init;
                    for (col = stepBuffer[0]; col < stepBuffer[2]; ++col) {
                        for (i = 0; i < drawableBands.length; ++i) {
                            buf.setElem(line, col, drawableBands[i], gdalBuf.buffByte[pos]);
                        }
                        ++pos;
                    }
                    ++lineInputWindow;
                    if (task.getEvent() == null) continue;
                    task.manageEvent(task.getEvent());
                }
                gdalBuf.buffByte = null;
                continue;
            }
            if (this.dataType[iBand] == GdalDataset.GDT_UInt16 || this.dataType[iBand] == GdalDataset.GDT_Int16 || this.dataType[iBand] == GdalDataset.GDT_CInt16) {
                for (line = stepBuffer[1]; line < stepBuffer[3]; ++line) {
                    pos = bufWidth * (lineInputWindow - stepBuffer[0]) + init;
                    for (col = stepBuffer[0]; col < stepBuffer[2]; ++col) {
                        for (i = 0; i < drawableBands.length; ++i) {
                            buf.setElem(line, col, drawableBands[i], gdalBuf.buffShort[pos]);
                        }
                        ++pos;
                    }
                    ++lineInputWindow;
                    if (task.getEvent() == null) continue;
                    task.manageEvent(task.getEvent());
                }
                gdalBuf.buffShort = null;
                continue;
            }
            if (this.dataType[iBand] == GdalDataset.GDT_UInt32 || this.dataType[iBand] == GdalDataset.GDT_Int32 || this.dataType[iBand] == GdalDataset.GDT_CInt32) {
                for (line = stepBuffer[1]; line < stepBuffer[3]; ++line) {
                    pos = bufWidth * (lineInputWindow - stepBuffer[0]) + init;
                    for (col = stepBuffer[0]; col < stepBuffer[2]; ++col) {
                        for (i = 0; i < drawableBands.length; ++i) {
                            buf.setElem(line, col, drawableBands[i], gdalBuf.buffInt[pos]);
                        }
                        ++pos;
                    }
                    ++lineInputWindow;
                    if (task.getEvent() == null) continue;
                    task.manageEvent(task.getEvent());
                }
                gdalBuf.buffInt = null;
                continue;
            }
            if (this.dataType[iBand] == GdalDataset.GDT_Float32) {
                for (line = stepBuffer[1]; line < stepBuffer[3]; ++line) {
                    pos = bufWidth * (lineInputWindow - stepBuffer[0]) + init;
                    for (col = stepBuffer[0]; col < stepBuffer[2]; ++col) {
                        for (i = 0; i < drawableBands.length; ++i) {
                            buf.setElem(line, col, drawableBands[i], gdalBuf.buffFloat[pos]);
                        }
                        ++pos;
                    }
                    ++lineInputWindow;
                    if (task.getEvent() == null) continue;
                    task.manageEvent(task.getEvent());
                }
                gdalBuf.buffFloat = null;
                continue;
            }
            if (this.dataType[iBand] != GdalDataset.GDT_Float64) continue;
            for (line = stepBuffer[1]; line < stepBuffer[3]; ++line) {
                pos = bufWidth * (lineInputWindow - stepBuffer[0]) + init;
                for (col = stepBuffer[0]; col < stepBuffer[2]; ++col) {
                    for (i = 0; i < drawableBands.length; ++i) {
                        buf.setElem(line, col, drawableBands[i], gdalBuf.buffDouble[pos]);
                    }
                    ++pos;
                }
                ++lineInputWindow;
                if (task.getEvent() == null) continue;
                task.manageEvent(task.getEvent());
            }
            gdalBuf.buffDouble = null;
        }
    }

    private void readDataByLine(Buffer buf, BandList bandList, int x, int y, int w, int yMax) throws GdalException, ProcessInterruptedException {
        GdalBuffer gdalBuf = null;
        RasterTask task = RasterTaskQueue.get((String)(Thread.currentThread().getId() + ""));
        FileUtils fUtil = RasterLocator.getManager().getFileUtils();
        for (int iBand = 0; iBand < this.gdalBands.length; ++iBand) {
            int i;
            int rasterBufLine;
            int line;
            int[] drawableBands = bandList.getBufferBandToDraw(fUtil.getFormatedRasterFileName(this.fileName), iBand);
            if (drawableBands == null || drawableBands.length == 1 && drawableBands[0] == -1) continue;
            if (this.dataType[iBand] == GdalDataset.GDT_Byte) {
                for (line = y; line < yMax; ++line) {
                    gdalBuf = this.gdalBands[iBand].readRaster(x, line, w, 1, w, 1, this.dataType[iBand]);
                    rasterBufLine = line - y;
                    for (i = 0; i < drawableBands.length; ++i) {
                        buf.setLineInBandByte(gdalBuf.buffByte, rasterBufLine, drawableBands[i]);
                    }
                    if (task.getEvent() == null) continue;
                    task.manageEvent(task.getEvent());
                }
                continue;
            }
            if (this.dataType[iBand] == GdalDataset.GDT_UInt16 || this.dataType[iBand] == GdalDataset.GDT_Int16 || this.dataType[iBand] == GdalDataset.GDT_CInt16) {
                for (line = y; line < yMax; ++line) {
                    gdalBuf = this.gdalBands[iBand].readRaster(x, line, w, 1, w, 1, this.dataType[iBand]);
                    rasterBufLine = line - y;
                    for (i = 0; i < drawableBands.length; ++i) {
                        buf.setLineInBandShort(gdalBuf.buffShort, rasterBufLine, drawableBands[i]);
                    }
                    if (task.getEvent() == null) continue;
                    task.manageEvent(task.getEvent());
                }
                continue;
            }
            if (this.dataType[iBand] == GdalDataset.GDT_UInt32 || this.dataType[iBand] == GdalDataset.GDT_Int32 || this.dataType[iBand] == GdalDataset.GDT_CInt32) {
                for (line = y; line < yMax; ++line) {
                    gdalBuf = this.gdalBands[iBand].readRaster(x, line, w, 1, w, 1, this.dataType[iBand]);
                    rasterBufLine = line - y;
                    for (i = 0; i < drawableBands.length; ++i) {
                        buf.setLineInBandInt(gdalBuf.buffInt, rasterBufLine, drawableBands[i]);
                    }
                    if (task.getEvent() == null) continue;
                    task.manageEvent(task.getEvent());
                }
                continue;
            }
            if (this.dataType[iBand] == GdalDataset.GDT_Float32) {
                for (line = y; line < yMax; ++line) {
                    gdalBuf = this.gdalBands[iBand].readRaster(x, line, w, 1, w, 1, this.dataType[iBand]);
                    rasterBufLine = line - y;
                    for (i = 0; i < drawableBands.length; ++i) {
                        buf.setLineInBandFloat(gdalBuf.buffFloat, rasterBufLine, drawableBands[i]);
                    }
                    if (task.getEvent() == null) continue;
                    task.manageEvent(task.getEvent());
                }
                continue;
            }
            if (this.dataType[iBand] != GdalDataset.GDT_Float64) continue;
            for (line = y; line < yMax; ++line) {
                gdalBuf = this.gdalBands[iBand].readRaster(x, line, w, 1, w, 1, this.dataType[iBand]);
                rasterBufLine = line - y;
                for (i = 0; i < drawableBands.length; ++i) {
                    buf.setLineInBandDouble(gdalBuf.buffDouble, rasterBufLine, drawableBands[i]);
                }
                if (task.getEvent() == null) continue;
                task.manageEvent(task.getEvent());
            }
        }
    }

    public Object[] getData(int x, int y) {
        try {
            Object[] data = new Object[this.getRasterCount()];
            block10: for (int i = 0; i < this.getRasterCount(); ++i) {
                GdalRasterBand rb = this.getRasterBand(i + 1);
                GdalBuffer r = rb.readRaster(x, y, 1, 1, 1, 1, this.dataType[i]);
                switch (this.dataType[i]) {
                    case 0: {
                        continue block10;
                    }
                    case 1: {
                        data[i] = new Integer(r.buffByte[0]);
                        continue block10;
                    }
                    case 2: 
                    case 3: {
                        data[i] = new Integer(r.buffShort[0]);
                        continue block10;
                    }
                    case 4: 
                    case 5: {
                        data[i] = new Integer(r.buffInt[0]);
                        continue block10;
                    }
                    case 6: {
                        data[i] = new Float(r.buffFloat[0]);
                        continue block10;
                    }
                    case 7: {
                        data[i] = new Double(r.buffDouble[0]);
                    }
                }
            }
            return data;
        }
        catch (GdalException e) {
            return null;
        }
    }

    public int getBlockSize() {
        return this.getBlockSize();
    }

    public AffineTransform getOwnTransformation() {
        return this.ownTransformation;
    }

    public Extent getExtentWithoutRot() {
        AffineTransform at = new AffineTransform(this.externalTransformation.getScaleX(), 0.0, 0.0, this.externalTransformation.getScaleY(), this.externalTransformation.getTranslateX(), this.externalTransformation.getTranslateY());
        Point2D.Double p1 = new Point2D.Double(0.0, 0.0);
        Point2D.Double p2 = new Point2D.Double(this.width, this.height);
        at.transform(p1, p1);
        at.transform(p2, p2);
        return new ExtentImpl((Point2D)p1, (Point2D)p2);
    }

    public void setExternalTransform(AffineTransform t) {
        this.externalTransformation = t;
    }

    public String getGdalShortName() {
        return this.shortName;
    }

    public void dispose() {
        this.open = false;
        try {
            super.close();
        }
        catch (GdalException gdalException) {
            // empty catch block
        }
        try {
            this.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void finalize() {
        this.fileTransparency = null;
        this.palette = null;
        this.colorInterpr = null;
        this.ownTransformation = null;
        this.externalTransformation = null;
        this.stepArrayX = null;
        this.stepArrayY = null;
        this.fileName = null;
        this.shortName = null;
        this.trans = null;
        this.version = null;
        this.dataType = null;
        this.metadata = null;
        if (this.gdalBands != null) {
            for (int i = 0; i < this.gdalBands.length; ++i) {
                this.gdalBands[i] = null;
            }
            this.gdalBands = null;
        }
        this.finalize();
    }
}

