/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dxf;

import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.cresques.px.Extent;
import org.gvsig.dxf.io.DxfFile;
import org.gvsig.dxf.io.DxfGroup;
import org.gvsig.dxf.io.DxfGroupVector;
import org.gvsig.dxf.px.IObjList;
import org.gvsig.dxf.px.dxf.DxfEntityMaker;
import org.gvsig.dxf.px.dxf.DxfFeatureMaker;
import org.gvsig.dxf.px.dxf.DxfHeaderManager;
import org.gvsig.dxf.px.gml.Geometry;
import org.gvsig.dxf.px.gml.LineString;
import org.gvsig.dxf.px.gml.LineString3D;
import org.gvsig.dxf.px.gml.Point;
import org.gvsig.dxf.px.gml.Point3D;
import org.gvsig.dxf.px.gml.Polygon3D;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.LoadException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.exception.WriteException;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.PerformEditingException;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProviderServices;
import org.gvsig.fmap.dal.feature.spi.memory.AbstractMemoryStoreProvider;
import org.gvsig.fmap.dal.resource.Resource;
import org.gvsig.fmap.dal.resource.ResourceAction;
import org.gvsig.fmap.dal.resource.exception.AccessResourceException;
import org.gvsig.fmap.dal.resource.exception.ResourceNotifyCloseException;
import org.gvsig.fmap.dal.resource.exception.ResourceNotifyOpenException;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.dal.store.dxf.DXFOpenStoreParameters;
import org.gvsig.fmap.dal.store.dxf.LegendBuilder;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationContext;
import org.gvsig.fmap.geom.operation.distance.PointDistance;
import org.gvsig.fmap.geom.operation.utils.PointGetAngle;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Circle;
import org.gvsig.fmap.geom.primitive.Ellipse;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.geom.type.GeometryTypeNotSupportedException;
import org.gvsig.fmap.geom.type.GeometryTypeNotValidException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.dynobject.exception.DynMethodException;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.exception.NotYetImplemented;
import org.gvsig.tools.logger.FilteredLogger;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DXFStoreProvider
extends AbstractMemoryStoreProvider
implements ResourceConsumer {
    private static final Logger logger = LoggerFactory.getLogger(DXFStoreProvider.class);
    public static final String NAME = "DXF";
    public static final String DESCRIPTION = "DXF file";
    public static final String METADATA_DEFINITION_NAME = "DXF";
    public static final String NAME_FIELD_ID = "ID";
    public static final String NAME_FIELD_GEOMETRY = "Geometry";
    public static final String NAME_FIELD_ENTITY = "Entity";
    public static final String NAME_FIELD_LAYER = "Layer";
    public static final String NAME_FIELD_COLOR = "Color";
    public static final String NAME_FIELD_ELEVATION = "Elevation";
    public static final String NAME_FIELD_THICKNESS = "Thickness";
    public static final String NAME_FIELD_TEXT = "Text";
    public static final String NAME_FIELD_HEIGHTTEXT = "HeightText";
    public static final String NAME_FIELD_ROTATIONTEXT = "Rotation";
    private static final int ID_FIELD_ID = 0;
    private static final int ID_FIELD_GEOMETRY = 1;
    private static final int ID_FIELD_ENTITY = 2;
    private static final int ID_FIELD_LAYER = 3;
    private static final int ID_FIELD_COLOR = 4;
    private static final int ID_FIELD_ELEVATION = 5;
    private static final int ID_FIELD_THICKNESS = 6;
    private static final int ID_FIELD_TEXT = 7;
    private static final int ID_FIELD_HEIGHTTEXT = 8;
    private static final int ID_FIELD_ROTATIONTEXT = 9;
    public static final Integer DEFAULT_VALUE_FIELD_COLOR = 0;
    public static final Double DEFAULT_VALUE_FIELD_THICKNESS = 0.0;
    public static final String DEFAULT_VALUE_FIELD_LAYER = "default";
    private IProjection projection;
    private ResourceProvider resource;
    private LegendBuilder legendBuilder;
    private long counterNewsOIDs = 0L;
    private Envelope envelope;
    private Writer writer;
    protected GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private SimpleTaskStatus taskStatus;

    public DXFStoreProvider(DXFOpenStoreParameters parameters, DataStoreProviderServices storeServices) throws InitializeException {
        super((DataStoreParameters)parameters, storeServices, FileHelper.newMetadataContainer((String)"DXF"));
        TaskStatusManager manager = ToolsLocator.getTaskStatusManager();
        this.taskStatus = manager.createDefaultSimpleTaskStatus("DXF");
        this.counterNewsOIDs = 0L;
        File file = this.getDXFParameters().getFile();
        this.resource = this.createResource("file", new Object[]{file.getAbsolutePath()});
        this.resource.addConsumer((ResourceConsumer)this);
        this.projection = this.getDXFParameters().getCRS();
        try {
            this.legendBuilder = (LegendBuilder)this.invokeDynMethod("getLegendBuilder", null);
        }
        catch (DynMethodException e) {
            this.legendBuilder = null;
        }
        catch (Exception e) {
            throw new InitializeException((Throwable)e);
        }
        this.initializeFeatureTypes();
    }

    private DXFOpenStoreParameters getDXFParameters() {
        return (DXFOpenStoreParameters)this.getParameters();
    }

    public String getProviderName() {
        return "DXF";
    }

    public boolean allowWrite() {
        return true;
    }

    public Object getLegend() throws OpenException {
        this.open();
        if (this.legendBuilder == null) {
            return null;
        }
        return this.legendBuilder.getLegend();
    }

    public Object getLabeling() throws OpenException {
        this.open();
        if (this.legendBuilder == null) {
            return null;
        }
        return this.legendBuilder.getLabeling();
    }

    public void open() throws OpenException {
        if (this.data != null) {
            return;
        }
        this.openEver();
    }

    private void openEver() throws OpenException {
        try {
            this.taskStatus.add();
            this.getResource().execute(new ResourceAction(){

                public Object run() throws Exception {
                    DXFData dxfData = null;
                    DXFStoreProvider.this.resource.setData(new HashMap());
                    FeatureStoreProviderServices store = DXFStoreProvider.this.getStoreServices();
                    dxfData = new DXFData();
                    dxfData.data = new ArrayList<FeatureProvider>();
                    DXFStoreProvider.this.data = dxfData.data;
                    DXFStoreProvider.this.counterNewsOIDs = 0L;
                    File file = (File)DXFStoreProvider.this.resource.get();
                    Reader reader = new Reader().initialice(DXFStoreProvider.this.getMemoryProvider(), file, DXFStoreProvider.this.projection, DXFStoreProvider.this.legendBuilder);
                    reader.begin(store);
                    dxfData.defaultFType = reader.getDefaultType().getNotEditableCopy();
                    ArrayList<FeatureType> types = new ArrayList<FeatureType>();
                    for (EditableFeatureType fType : reader.getTypes()) {
                        if (fType.getId().equals(dxfData.defaultFType.getId())) {
                            types.add(dxfData.defaultFType);
                            continue;
                        }
                        types.add(fType.getNotEditableCopy());
                    }
                    dxfData.fTypes = types;
                    DXFStoreProvider.this.resource.notifyOpen();
                    store.setFeatureTypes(dxfData.fTypes, dxfData.defaultFType);
                    reader.load();
                    dxfData.envelope = reader.getEnvelope();
                    dxfData.legendBuilder = DXFStoreProvider.this.legendBuilder;
                    dxfData.projection = DXFStoreProvider.this.projection;
                    reader.end();
                    DXFStoreProvider.this.resource.notifyClose();
                    ((Map)DXFStoreProvider.this.resource.getData()).put(DXFStoreProvider.this.projection.getAbrev(), dxfData);
                    DXFStoreProvider.this.data = dxfData.data;
                    store.setFeatureTypes(dxfData.fTypes, dxfData.defaultFType);
                    DXFStoreProvider.this.legendBuilder = dxfData.legendBuilder;
                    DXFStoreProvider.this.envelope = dxfData.getEnvelopeCopy();
                    DXFStoreProvider.this.counterNewsOIDs = DXFStoreProvider.this.data.size();
                    return null;
                }
            });
            this.taskStatus.terminate();
        }
        catch (Exception e) {
            this.data = null;
            this.taskStatus.abort();
            try {
                throw new OpenException(this.resource.getName(), (Throwable)e);
            }
            catch (AccessResourceException e1) {
                throw new OpenException(this.getProviderName(), (Throwable)e);
            }
        }
        finally {
            this.taskStatus.remove();
        }
    }

    public DataServerExplorer getExplorer() throws ReadException {
        DataManager manager = DALLocator.getDataManager();
        try {
            FilesystemServerExplorerParameters params = (FilesystemServerExplorerParameters)manager.createServerExplorerParameters("FilesystemExplorer");
            params.setRoot(this.getDXFParameters().getFile().getParent());
            return manager.openServerExplorer("FilesystemExplorer", (DataServerExplorerParameters)params);
        }
        catch (DataException e) {
            throw new ReadException(this.getProviderName(), (Throwable)e);
        }
        catch (ValidateDataParametersException e) {
            throw new ReadException(this.getProviderName(), (Throwable)e);
        }
    }

    public void performChanges(Iterator deleteds, Iterator inserteds, Iterator updateds, Iterator originalFeatureTypesUpdated) throws PerformEditingException {
        try {
            this.taskStatus.add();
            this.taskStatus.message("_preparing");
            this.getResource().execute(new ResourceAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws Exception {
                    FeatureSet features = null;
                    DisposableIterator it = null;
                    DXFStoreProvider.this.counterNewsOIDs = 0L;
                    try {
                        File file = (File)DXFStoreProvider.this.resource.get();
                        DXFStoreProvider.this.writer = new Writer().initialice(file, DXFStoreProvider.this.projection);
                        features = DXFStoreProvider.this.getStoreServices().getFeatureStore().getFeatureSet();
                        ArrayList<FeatureProvider> newdata = new ArrayList<FeatureProvider>();
                        DXFStoreProvider.this.writer.begin();
                        it = features.fastIterator();
                        DXFStoreProvider.this.taskStatus.setRangeOfValues(0L, 0L);
                        long counter = 0L;
                        while (it.hasNext()) {
                            DXFStoreProvider.this.taskStatus.setCurValue(counter++);
                            FeatureProvider featureProvider = DXFStoreProvider.this.getStoreServices().getFeatureProviderFromFeature((Feature)it.next());
                            DXFStoreProvider.this.writer.add(featureProvider);
                            featureProvider.setOID(DXFStoreProvider.this.createNewOID());
                            newdata.add(featureProvider);
                        }
                        DXFStoreProvider.this.data = newdata;
                        DXFStoreProvider.this.writer.end();
                        if (DXFStoreProvider.this.writer.getEnvelope() != null) {
                            DXFStoreProvider.this.envelope = DXFStoreProvider.this.writer.getEnvelope().getGeometry().getEnvelope();
                        }
                        DXFStoreProvider.this.resource.notifyChanges();
                        DXFStoreProvider.this.savePrjFile(file, DXFStoreProvider.this.projection);
                    }
                    finally {
                        if (it != null) {
                            it.dispose();
                        }
                        if (features != null) {
                            features.dispose();
                        }
                    }
                    return null;
                }
            });
            this.taskStatus.terminate();
        }
        catch (Exception e) {
            this.taskStatus.abort();
            throw new PerformEditingException(this.getResource().toString(), (Throwable)e);
        }
        finally {
            this.taskStatus.remove();
        }
    }

    public static void initializeFeatureType(EditableFeatureType featureType, IProjection projection, int geometrySubtype) {
        featureType.setHasOID(true);
        featureType.add(NAME_FIELD_ID, 4).setDefaultValue((Object)0).getIndex();
        EditableFeatureAttributeDescriptor attr = featureType.add(NAME_FIELD_GEOMETRY, 66);
        attr.setSRS(projection);
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        try {
            GeometryType geometryType = geometryManager.getGeometryType(0, geometrySubtype);
            attr.setGeometryType(geometryType);
        }
        catch (GeometryTypeNotSupportedException | GeometryTypeNotValidException e) {
            logger.error("Can't create geometry type 0 with subtype " + geometrySubtype, e);
            attr.setGeometryType(0);
            attr.setGeometrySubType(geometrySubtype);
        }
        featureType.setDefaultGeometryAttributeName(NAME_FIELD_GEOMETRY);
        featureType.add(NAME_FIELD_ENTITY, 8, 100).setDefaultValue((Object)"").getIndex();
        featureType.add(NAME_FIELD_LAYER, 8, 100).setDefaultValue((Object)DEFAULT_VALUE_FIELD_LAYER).getIndex();
        featureType.add(NAME_FIELD_COLOR, 4).setDefaultValue((Object)DEFAULT_VALUE_FIELD_COLOR).getIndex();
        featureType.add(NAME_FIELD_ELEVATION, 7).setDefaultValue((Object)0.0).getIndex();
        featureType.add(NAME_FIELD_THICKNESS, 7).setDefaultValue((Object)DEFAULT_VALUE_FIELD_THICKNESS).getIndex();
        featureType.add(NAME_FIELD_TEXT, 8, 100).setDefaultValue((Object)"").getIndex();
        featureType.add(NAME_FIELD_HEIGHTTEXT, 7).setDefaultValue((Object)10.0).getIndex();
        featureType.add(NAME_FIELD_ROTATIONTEXT, 7).setDefaultValue((Object)0.0).getIndex();
    }

    public boolean closeResourceRequested(ResourceProvider resource) {
        return true;
    }

    public int getOIDType() {
        return 5;
    }

    public boolean supportsAppendMode() {
        return false;
    }

    public void append(FeatureProvider featureProvider) {
        try {
            this.writer.add(featureProvider);
        }
        catch (WriteException e) {
            e.printStackTrace();
        }
    }

    public void beginAppend() {
        try {
            this.writer = new Writer().initialice((File)this.resource.get(), this.projection);
            this.writer.begin();
        }
        catch (AccessResourceException e) {
            e.printStackTrace();
        }
    }

    public void endAppend() {
        try {
            this.resource.notifyOpen();
            this.writer.end();
            this.resource.notifyClose();
            this.counterNewsOIDs = 0L;
        }
        catch (ResourceNotifyOpenException e) {
            e.printStackTrace();
        }
        catch (ResourceNotifyCloseException e) {
            e.printStackTrace();
        }
        catch (WriteException e) {
            e.printStackTrace();
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        throw new NotYetImplemented();
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        throw new NotYetImplemented();
    }

    public Object createNewOID() {
        return new Long(this.counterNewsOIDs++);
    }

    protected void initializeFeatureTypes() throws InitializeException {
        try {
            this.open();
        }
        catch (OpenException e) {
            throw new InitializeException(this.getProviderName(), (Throwable)e);
        }
    }

    public Envelope getEnvelope() throws DataException {
        this.open();
        return this.envelope;
    }

    public Object getDynValue(String name) throws DynFieldNotFoundException {
        IProjection pro;
        if ("Envelope".equalsIgnoreCase(name)) {
            try {
                return this.getEnvelope();
            }
            catch (DataException e) {
                return null;
            }
        }
        if ("CRS".equalsIgnoreCase(name) && (pro = this.getDXFParameters().getCRS()) != null) {
            return pro;
        }
        return super.getDynValue(name);
    }

    public void resourceChanged(ResourceProvider resource) {
        this.getStoreServices().notifyChange("resourceChange_DataStore", (Resource)resource);
    }

    public Object getSourceId() {
        return this.getDXFParameters().getFile();
    }

    public String getName() {
        String name = this.getDXFParameters().getFile().getName();
        return FilenameUtils.getBaseName((String)name);
    }

    public String getFullName() {
        return this.getDXFParameters().getFile().getAbsolutePath();
    }

    public ResourceProvider getResource() {
        return this.resource;
    }

    protected void doDispose() throws BaseException {
        super.doDispose();
        this.resource.removeConsumer((ResourceConsumer)this);
    }

    public class Writer {
        private Double DEFAULT_ELEVATION = new Double(0.0);
        private DxfFile.EntityFactory entityMaker;
        private IProjection proj = null;
        private int handle = 40;
        private int k = 0;
        private boolean dxf3DFile = false;
        private String fileName;
        private Envelope envelope;

        public Writer initialice(File file, IProjection projection) {
            this.proj = projection;
            this.fileName = file.getAbsolutePath();
            this.entityMaker = new DxfEntityMaker(this.proj);
            return this;
        }

        public void begin() {
            this.envelope = null;
            this.entityMaker = new DxfEntityMaker(this.proj);
        }

        public void end() throws WriteException {
            try {
                DxfFile dxfFile = new DxfFile(null, this.fileName, this.entityMaker);
                dxfFile.setCadFlag(true);
                if (this.dxf3DFile) {
                    dxfFile.setDxf3DFlag(true);
                }
                dxfFile.save(this.fileName);
                dxfFile.close();
            }
            catch (Exception e) {
                throw new WriteException(this.fileName, (Throwable)e);
            }
        }

        public void add(FeatureProvider feature) throws WriteException {
            try {
                org.gvsig.fmap.geom.Geometry geom = feature.getDefaultGeometry();
                if (geom == null) {
                    return;
                }
                GeometryType type = geom.getGeometryType();
                boolean geometrySupported = true;
                if (type.isTypeOf(1) && (type.isSubTypeOf(1) || type.isSubTypeOf(3))) {
                    this.dxf3DFile = true;
                    this.k = this.createPoint3D(this.handle, this.k, feature);
                } else if (type.isTypeOf(1) && 0 == type.getSubType()) {
                    this.k = this.createPoint2D(this.handle, this.k, feature);
                } else if (type.isTypeOf(12) && 0 == type.getSubType()) {
                    this.k = this.createArc2D(this.handle, this.k, feature);
                } else if ((type.isTypeOf(2) || type.isTypeOf(8)) && (type.isSubTypeOf(1) || type.isSubTypeOf(3))) {
                    this.dxf3DFile = true;
                    this.k = this.createPolyline3D(this.handle, this.k, feature, false);
                } else if ((type.isTypeOf(2) || type.isTypeOf(8)) && 0 == type.getSubType()) {
                    this.k = this.createLwPolyline2D(this.handle, this.k, feature, false);
                } else if (type.isTypeOf(11) && 0 == type.getSubType()) {
                    this.k = this.createCircle2D(this.handle, this.k, feature);
                } else if (type.isTypeOf(13) && 0 == type.getSubType()) {
                    this.k = this.createEllipse2D(this.handle, this.k, feature);
                } else if ((type.isTypeOf(3) || type.isTypeOf(9)) && (type.isSubTypeOf(1) || type.isSubTypeOf(3))) {
                    this.dxf3DFile = true;
                    this.k = this.createPolyline3D(this.handle, this.k, feature, true);
                } else if ((type.isTypeOf(3) || type.isTypeOf(9)) && 0 == type.getSubType()) {
                    this.k = this.createLwPolyline2D(this.handle, this.k, feature, true);
                } else {
                    geometrySupported = false;
                    logger.warn(MessageFormat.format("Geometry '{1}' not yet supported", geom.getClass().getName()));
                    ++this.k;
                }
                if (geometrySupported) {
                    if (this.envelope != null) {
                        this.envelope.add(feature.getDefaultEnvelope());
                    } else {
                        this.envelope = feature.getDefaultEnvelope().getGeometry().getEnvelope();
                    }
                }
            }
            catch (Exception e) {
                throw new WriteException(this.fileName, (Throwable)e);
            }
        }

        private boolean hasText(FeatureProvider feature) {
            if (feature.isNull(7)) {
                return false;
            }
            return !feature.get(7).equals("");
        }

        private DxfGroupVector updateProperties(FeatureProvider feature, int k) {
            Double thickness;
            Integer color;
            DxfGroupVector polv = new DxfGroupVector();
            String layer = (String)feature.get(3);
            if (StringUtils.isBlank((CharSequence)layer)) {
                layer = DXFStoreProvider.DEFAULT_VALUE_FIELD_LAYER;
            }
            if ((color = (Integer)feature.get(4)) == null) {
                color = DEFAULT_VALUE_FIELD_COLOR;
            }
            if ((thickness = (Double)feature.get(6)) == null) {
                thickness = DEFAULT_VALUE_FIELD_THICKNESS;
            }
            DxfGroup geometryLayer = new DxfGroup(8, layer);
            DxfGroup handleGroup = new DxfGroup();
            handleGroup.setCode(5);
            handleGroup.setData((Object)new Integer(this.handle + k).toString());
            DxfGroup handleColor = new DxfGroup();
            handleColor.setCode(62);
            handleColor.setData((Object)color);
            DxfGroup handleThickness = new DxfGroup();
            handleThickness.setCode(39);
            handleThickness.setData((Object)thickness);
            polv.add((Object)geometryLayer);
            polv.add((Object)handleGroup);
            polv.add((Object)handleColor);
            return polv;
        }

        private int createPoint2D(int handle, int k, FeatureProvider feature) throws Exception {
            if (this.hasText(feature)) {
                return this.createText2D(handle, k, feature);
            }
            org.gvsig.fmap.geom.primitive.Point point = DXFStoreProvider.this.geomManager.createPoint(0.0, 0.0, 0);
            double[] pointCoords = new double[6];
            PathIterator pointIt = feature.getDefaultGeometry().getPathIterator(null);
            while (!pointIt.isDone()) {
                pointIt.currentSegment(pointCoords);
                point = DXFStoreProvider.this.geomManager.createPoint(pointCoords[0], pointCoords[1], 0);
                pointIt.next();
            }
            Point2D.Double pto = new Point2D.Double(point.getX(), point.getY());
            DxfGroup px = new DxfGroup();
            DxfGroup py = new DxfGroup();
            DxfGroup pz = new DxfGroup();
            px.setCode(10);
            px.setData((Object)new Double(((Point2D)pto).getX()));
            py.setCode(20);
            py.setData((Object)new Double(((Point2D)pto).getY()));
            pz.setCode(30);
            pz.setData((Object)new Double(0.0));
            DxfGroupVector pv = this.updateProperties(feature, k);
            pv.add((Object)px);
            pv.add((Object)py);
            pv.add((Object)pz);
            this.entityMaker.createPoint(pv);
            return ++k;
        }

        private int createText2D(int handle, int k, FeatureProvider feature) throws Exception {
            String text = feature.get(7).toString();
            Double heightText = (Double)feature.get(8);
            Double rotationText = (Double)feature.get(9);
            DxfGroup handleText = new DxfGroup();
            handleText.setCode(1);
            handleText.setData((Object)text);
            DxfGroup handleHeightText = new DxfGroup();
            handleHeightText.setCode(40);
            handleHeightText.setData((Object)heightText);
            DxfGroup handleRotationText = new DxfGroup();
            handleRotationText.setCode(50);
            handleRotationText.setData((Object)rotationText);
            org.gvsig.fmap.geom.primitive.Point point = DXFStoreProvider.this.geomManager.createPoint(0.0, 0.0, 0);
            double[] pointCoords = new double[6];
            PathIterator pointIt = feature.getDefaultGeometry().getPathIterator(null);
            while (!pointIt.isDone()) {
                pointIt.currentSegment(pointCoords);
                point = DXFStoreProvider.this.geomManager.createPoint(pointCoords[0], pointCoords[1], 0);
                pointIt.next();
            }
            Point2D.Double pto = new Point2D.Double(point.getX(), point.getY());
            DxfGroup handleGroup = new DxfGroup();
            handleGroup.setCode(5);
            handleGroup.setData((Object)new Integer(handle + k).toString());
            DxfGroup px = new DxfGroup();
            DxfGroup py = new DxfGroup();
            DxfGroup pz = new DxfGroup();
            px.setCode(10);
            px.setData((Object)new Double(((Point2D)pto).getX()));
            py.setCode(20);
            py.setData((Object)new Double(((Point2D)pto).getY()));
            pz.setCode(30);
            pz.setData((Object)new Double(0.0));
            DxfGroupVector pv = this.updateProperties(feature, k);
            pv.add((Object)handleText);
            pv.add((Object)handleHeightText);
            pv.add((Object)handleRotationText);
            pv.add((Object)handleGroup);
            pv.add((Object)px);
            pv.add((Object)py);
            pv.add((Object)pz);
            this.entityMaker.createText(pv);
            return ++k;
        }

        private int createPoint3D(int handle, int k, FeatureProvider feature) throws Exception {
            if (this.hasText(feature)) {
                return this.createText3D(handle, k, feature);
            }
            org.gvsig.fmap.geom.primitive.Point point = (org.gvsig.fmap.geom.primitive.Point)DXFStoreProvider.this.geomManager.create(1, 1);
            double[] pointCoords = new double[6];
            PathIterator pointIt = feature.getDefaultGeometry().getPathIterator(null);
            while (!pointIt.isDone()) {
                pointIt.currentSegment(pointCoords);
                point = (org.gvsig.fmap.geom.primitive.Point)DXFStoreProvider.this.geomManager.create(1, 1);
                point.setCoordinateAt(0, pointCoords[0]);
                point.setCoordinateAt(1, pointCoords[1]);
                point.setCoordinateAt(2, pointCoords[2]);
                pointIt.next();
            }
            org.gvsig.fmap.geom.primitive.Point pto = (org.gvsig.fmap.geom.primitive.Point)DXFStoreProvider.this.geomManager.create(1, 1);
            pto.setCoordinateAt(0, point.getCoordinateAt(0));
            pto.setCoordinateAt(1, point.getCoordinateAt(1));
            pto.setCoordinateAt(2, point.getCoordinateAt(2));
            DxfGroup px = new DxfGroup();
            DxfGroup py = new DxfGroup();
            DxfGroup pz = new DxfGroup();
            px.setCode(10);
            px.setData((Object)new Double(pto.getX()));
            py.setCode(20);
            py.setData((Object)new Double(pto.getY()));
            pz.setCode(30);
            pz.setData((Object)new Double(pto.getCoordinateAt(2)));
            double velev = ((org.gvsig.fmap.geom.primitive.Point)feature.getDefaultGeometry()).getCoordinateAt(2);
            Double elevation = this.DEFAULT_ELEVATION;
            elevation = new Double(velev);
            DxfGroup handleElevation = new DxfGroup();
            handleElevation.setCode(38);
            handleElevation.setData((Object)elevation);
            DxfGroupVector pv = this.updateProperties(feature, k);
            pv.add((Object)handleElevation);
            pv.add((Object)px);
            pv.add((Object)py);
            pv.add((Object)pz);
            this.entityMaker.createPoint(pv);
            return ++k;
        }

        private int createText3D(int handle, int k, FeatureProvider feature) throws Exception {
            double velev = ((org.gvsig.fmap.geom.primitive.Point)feature.getDefaultGeometry()).getCoordinateAt(0);
            Double elevation = new Double(velev);
            String text = feature.get(7).toString();
            Double heightText = (Double)feature.get(8);
            Double rotationText = (Double)feature.get(9);
            DxfGroup handleText = new DxfGroup();
            handleText.setCode(1);
            handleText.setData((Object)text);
            DxfGroup handleHeightText = new DxfGroup();
            handleHeightText.setCode(40);
            handleHeightText.setData((Object)heightText);
            DxfGroup handleRotationText = new DxfGroup();
            handleRotationText.setCode(50);
            handleRotationText.setData((Object)rotationText);
            DxfGroup handleElevation = new DxfGroup();
            handleElevation.setCode(38);
            handleElevation.setData((Object)elevation);
            org.gvsig.fmap.geom.primitive.Point point = (org.gvsig.fmap.geom.primitive.Point)feature.getDefaultGeometry();
            DxfGroup handleGroup = new DxfGroup();
            handleGroup.setCode(5);
            handleGroup.setData((Object)new Integer(handle + k).toString());
            DxfGroup px = new DxfGroup();
            DxfGroup py = new DxfGroup();
            DxfGroup pz = new DxfGroup();
            px.setCode(10);
            px.setData((Object)new Double(point.getX()));
            py.setCode(20);
            py.setData((Object)new Double(point.getY()));
            pz.setCode(30);
            pz.setData((Object)new Double(point.getCoordinateAt(2)));
            DxfGroupVector pv = this.updateProperties(feature, k);
            pv.add((Object)handleElevation);
            pv.add((Object)handleText);
            pv.add((Object)handleHeightText);
            pv.add((Object)handleRotationText);
            pv.add((Object)handleGroup);
            pv.add((Object)px);
            pv.add((Object)py);
            pv.add((Object)pz);
            this.entityMaker.createText(pv);
            return ++k;
        }

        private int createLwPolyline2D(int handle, int k, FeatureProvider feature, boolean isPolygon) throws Exception {
            org.gvsig.fmap.geom.Geometry geom = feature.getDefaultGeometry();
            MultiLine lines = geom.toLines();
            for (org.gvsig.fmap.geom.Geometry line : lines) {
                DxfGroup polylineFlag = new DxfGroup();
                polylineFlag.setCode(70);
                if (isPolygon) {
                    polylineFlag.setData((Object)1);
                } else {
                    polylineFlag.setData((Object)0);
                }
                DxfGroupVector polv = this.updateProperties(feature, k);
                polv.add((Object)polylineFlag);
                ++k;
                Line curve = (Line)line;
                for (int i = 0; i < curve.getNumVertices(); ++i) {
                    org.gvsig.fmap.geom.primitive.Point point = (org.gvsig.fmap.geom.primitive.Point)curve.get(i);
                    DxfGroup xvertex = new DxfGroup();
                    xvertex.setCode(10);
                    xvertex.setData((Object)point.getX());
                    DxfGroup yvertex = new DxfGroup();
                    yvertex.setCode(20);
                    yvertex.setData((Object)point.getY());
                    polv.add((Object)xvertex);
                    polv.add((Object)yvertex);
                }
                this.entityMaker.createLwPolyline(polv);
            }
            return k;
        }

        private int createLwPolyline2D_OLD(int handle, int k, FeatureProvider feature, boolean isPolygon) throws Exception {
            boolean first = true;
            DxfGroupVector polv = this.updateProperties(feature, k);
            Vector<org.gvsig.fmap.geom.primitive.Point> vpoints = new Vector<org.gvsig.fmap.geom.primitive.Point>();
            DxfGroup polylineFlag = new DxfGroup();
            polylineFlag.setCode(70);
            if (isPolygon) {
                polylineFlag.setData((Object)new Integer(1));
            } else {
                polylineFlag.setData((Object)new Integer(0));
            }
            PathIterator theIterator = feature.getDefaultGeometry().getPathIterator(null, DXFStoreProvider.this.geomManager.getFlatness());
            double[] theData = new double[6];
            while (!theIterator.isDone()) {
                int theType = theIterator.currentSegment(theData);
                switch (theType) {
                    case 0: {
                        if (!first) {
                            for (int j = 0; j < vpoints.size(); ++j) {
                                DxfGroup xvertex = new DxfGroup();
                                xvertex.setCode(10);
                                xvertex.setData((Object)new Double(((org.gvsig.fmap.geom.primitive.Point)vpoints.get(j)).getX()));
                                DxfGroup yvertex = new DxfGroup();
                                yvertex.setCode(20);
                                yvertex.setData((Object)new Double(((org.gvsig.fmap.geom.primitive.Point)vpoints.get(j)).getY()));
                                polv.add((Object)xvertex);
                                polv.add((Object)yvertex);
                            }
                            this.entityMaker.createLwPolyline(polv);
                            polv = this.updateProperties(feature, ++k);
                        }
                        first = false;
                        polv.add((Object)polylineFlag);
                        vpoints.clear();
                        vpoints.add(DXFStoreProvider.this.geomManager.createPoint(theData[0], theData[1], 0));
                        break;
                    }
                    case 1: {
                        vpoints.add(DXFStoreProvider.this.geomManager.createPoint(theData[0], theData[1], 0));
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        polylineFlag.setData((Object)new Integer(1));
                    }
                }
                theIterator.next();
            }
            for (int j = 0; j < vpoints.size(); ++j) {
                DxfGroup xvertex = new DxfGroup();
                xvertex.setCode(10);
                xvertex.setData((Object)new Double(((org.gvsig.fmap.geom.primitive.Point)vpoints.get(j)).getX()));
                DxfGroup yvertex = new DxfGroup();
                yvertex.setCode(20);
                yvertex.setData((Object)new Double(((org.gvsig.fmap.geom.primitive.Point)vpoints.get(j)).getY()));
                polv.add((Object)xvertex);
                polv.add((Object)yvertex);
            }
            this.entityMaker.createLwPolyline(polv);
            return ++k;
        }

        private int createPolyline3D(int handle, int k, FeatureProvider feature, boolean isPolygon) throws Exception {
            org.gvsig.fmap.geom.Geometry geom = feature.getDefaultGeometry();
            MultiLine lines = geom.toLines();
            for (org.gvsig.fmap.geom.Geometry g : lines) {
                DxfGroup polylineFlag = new DxfGroup();
                polylineFlag.setCode(70);
                int flag = 0;
                if (isPolygon) {
                    flag = 1;
                }
                polylineFlag.setData((Object)flag);
                DxfGroupVector polv = this.updateProperties(feature, k);
                polv.add((Object)polylineFlag);
                ++k;
                Line line = (Line)g;
                if (this.constantElevation(line)) {
                    DxfGroup elevation = new DxfGroup();
                    elevation.setCode(38);
                    elevation.setData((Object)line.getVertex(0).getCoordinateAt(2));
                    polv.add((Object)elevation);
                    for (int i = 0; i < line.getNumVertices(); ++i) {
                        org.gvsig.fmap.geom.primitive.Point point = (org.gvsig.fmap.geom.primitive.Point)line.get(i);
                        DxfGroup xvertex = new DxfGroup();
                        xvertex.setCode(10);
                        xvertex.setData((Object)point.getX());
                        DxfGroup yvertex = new DxfGroup();
                        yvertex.setCode(20);
                        yvertex.setData((Object)point.getY());
                        polv.add((Object)xvertex);
                        polv.add((Object)yvertex);
                    }
                    this.entityMaker.createLwPolyline(polv);
                    continue;
                }
                polylineFlag.setData((Object)(flag | 8));
                DxfGroup xgroup = new DxfGroup();
                xgroup.setCode(10);
                xgroup.setData((Object)0.0);
                polv.add((Object)xgroup);
                DxfGroup ygroup = new DxfGroup();
                ygroup.setCode(20);
                ygroup.setData((Object)0.0);
                polv.add((Object)ygroup);
                DxfGroup elevation = new DxfGroup();
                elevation.setCode(30);
                elevation.setData((Object)0.0);
                polv.add((Object)elevation);
                DxfGroup subclassMarker = new DxfGroup(100, "AcDb3dPolyline");
                polv.add((Object)subclassMarker);
                this.entityMaker.createPolyline(polv);
                ++k;
                for (int i = 0; i < line.getNumVertices(); ++i) {
                    org.gvsig.fmap.geom.primitive.Point point = (org.gvsig.fmap.geom.primitive.Point)line.get(i);
                    DxfGroupVector verv = new DxfGroupVector();
                    DxfGroup entityType = new DxfGroup(0, "VERTEX");
                    verv.add((Object)entityType);
                    DxfGroup generalSubclassMarker = new DxfGroup(100, "AcDbEntity");
                    verv.add((Object)generalSubclassMarker);
                    DxfGroup layerName = new DxfGroup(8, DXFStoreProvider.DEFAULT_VALUE_FIELD_LAYER);
                    verv.add((Object)layerName);
                    DxfGroup vertexSubclassMarker = new DxfGroup(100, "AcDbVertex");
                    verv.add((Object)vertexSubclassMarker);
                    DxfGroup xvertex = new DxfGroup();
                    xvertex.setCode(10);
                    xvertex.setData((Object)point.getX());
                    DxfGroup yvertex = new DxfGroup();
                    yvertex.setCode(20);
                    yvertex.setData((Object)point.getY());
                    DxfGroup zvertex = new DxfGroup();
                    zvertex.setCode(20);
                    zvertex.setData((Object)point.getCoordinateAt(2));
                    verv.add((Object)xvertex);
                    verv.add((Object)yvertex);
                    verv.add((Object)zvertex);
                    this.entityMaker.addVertex(verv);
                    ++k;
                }
                this.entityMaker.endSeq();
                ++k;
            }
            return k;
        }

        private int createPolyline3D_OLD(int handle, int k, FeatureProvider feature, boolean isPolygon) throws Exception {
            DxfGroupVector polv = this.updateProperties(feature, k);
            Vector<org.gvsig.fmap.geom.primitive.Point> vpoints = new Vector<org.gvsig.fmap.geom.primitive.Point>();
            PathIterator theIterator = feature.getDefaultGeometry().getPathIterator(null, DXFStoreProvider.this.geomManager.getFlatness());
            double[] theData = new double[6];
            OrientablePrimitive curve = (OrientablePrimitive)feature.getDefaultGeometry();
            double[] velev = new double[curve.getNumVertices()];
            for (int i = 0; i < curve.getNumVertices(); ++i) {
                velev[i] = curve.getCoordinateAt(i, 2);
            }
            while (!theIterator.isDone()) {
                int theType = theIterator.currentSegment(theData);
                switch (theType) {
                    case 0: {
                        vpoints.add(DXFStoreProvider.this.geomManager.createPoint(theData[0], theData[1], 0));
                        break;
                    }
                    case 1: {
                        vpoints.add(DXFStoreProvider.this.geomManager.createPoint(theData[0], theData[1], 0));
                    }
                }
                theIterator.next();
            }
            if (this.constantElevation(velev)) {
                Integer flag = 0;
                DxfGroup polylineFlag = new DxfGroup();
                polylineFlag.setCode(70);
                polylineFlag.setCode(70);
                if (isPolygon) {
                    flag = flag | 1;
                }
                polylineFlag.setData((Object)flag);
                polv.add((Object)polylineFlag);
                DxfGroup elevation = new DxfGroup();
                elevation.setCode(38);
                elevation.setData((Object)new Double(velev[0]));
                polv.add((Object)elevation);
                for (int j = 0; j < vpoints.size(); ++j) {
                    DxfGroup xvertex = new DxfGroup();
                    xvertex.setCode(10);
                    xvertex.setData((Object)new Double(((org.gvsig.fmap.geom.primitive.Point)vpoints.get(j)).getX()));
                    DxfGroup yvertex = new DxfGroup();
                    yvertex.setCode(20);
                    yvertex.setData((Object)new Double(((org.gvsig.fmap.geom.primitive.Point)vpoints.get(j)).getY()));
                    polv.add((Object)xvertex);
                    polv.add((Object)yvertex);
                }
                this.entityMaker.createLwPolyline(polv);
                ++k;
            } else {
                DxfGroup polylineFlag = new DxfGroup();
                polylineFlag.setCode(70);
                Integer flag = 8;
                if (isPolygon) {
                    flag = flag | 1;
                }
                polylineFlag.setData((Object)flag);
                polv.add((Object)polylineFlag);
                DxfGroup xgroup = new DxfGroup();
                xgroup.setCode(10);
                xgroup.setData((Object)new Double(0.0));
                polv.add((Object)xgroup);
                DxfGroup ygroup = new DxfGroup();
                ygroup.setCode(20);
                ygroup.setData((Object)new Double(0.0));
                polv.add((Object)ygroup);
                DxfGroup elevation = new DxfGroup();
                elevation.setCode(30);
                elevation.setData((Object)new Double(0.0));
                polv.add((Object)elevation);
                DxfGroup subclassMarker = new DxfGroup(100, "AcDb3dPolyline");
                polv.add((Object)subclassMarker);
                this.entityMaker.createPolyline(polv);
                ++k;
                for (int j = 0; j < vpoints.size(); ++j) {
                    DxfGroupVector verv = new DxfGroupVector();
                    DxfGroup entityType = new DxfGroup(0, "VERTEX");
                    verv.add((Object)entityType);
                    DxfGroup generalSubclassMarker = new DxfGroup(100, "AcDbEntity");
                    verv.add((Object)generalSubclassMarker);
                    DxfGroup layerName = new DxfGroup(8, DXFStoreProvider.DEFAULT_VALUE_FIELD_LAYER);
                    verv.add((Object)layerName);
                    DxfGroup vertexSubclassMarker = new DxfGroup(100, "AcDbVertex");
                    verv.add((Object)vertexSubclassMarker);
                    DxfGroup xvertex = new DxfGroup();
                    xvertex.setCode(10);
                    xvertex.setData((Object)new Double(((org.gvsig.fmap.geom.primitive.Point)vpoints.get(j)).getX()));
                    DxfGroup yvertex = new DxfGroup();
                    yvertex.setCode(20);
                    yvertex.setData((Object)new Double(((org.gvsig.fmap.geom.primitive.Point)vpoints.get(j)).getY()));
                    DxfGroup zvertex = new DxfGroup();
                    zvertex.setCode(30);
                    zvertex.setData((Object)new Double(velev[j]));
                    verv.add((Object)xvertex);
                    verv.add((Object)yvertex);
                    verv.add((Object)zvertex);
                    this.entityMaker.addVertex(verv);
                    ++k;
                }
                DxfGroupVector seqv = new DxfGroupVector();
                DxfGroup entityType = new DxfGroup(0, "SEQEND");
                seqv.add((Object)entityType);
                DxfGroup generalSubclassMarker = new DxfGroup(100, "AcDbEntity");
                seqv.add((Object)generalSubclassMarker);
                DxfGroup layerName = new DxfGroup(8, DXFStoreProvider.DEFAULT_VALUE_FIELD_LAYER);
                seqv.add((Object)layerName);
                DxfGroup handleSeqGroup = new DxfGroup();
                handleSeqGroup.setCode(5);
                handleSeqGroup.setData((Object)new Integer(handle + k).toString());
                seqv.add((Object)handleSeqGroup);
                this.entityMaker.endSeq();
                ++k;
            }
            return k;
        }

        private boolean constantElevation(Line line) {
            Double elev = null;
            for (org.gvsig.fmap.geom.primitive.Point point : line) {
                if (elev == null) {
                    elev = point.getCoordinateAt(2);
                    continue;
                }
                if (elev.doubleValue() == point.getCoordinateAt(2)) continue;
                return false;
            }
            return true;
        }

        private boolean constantElevation(double[] velev) {
            boolean constant = true;
            int i = 0;
            if (i < velev.length) {
                for (int j = 0; j < velev.length; ++j) {
                    if (j <= i || velev[i] == velev[j]) continue;
                    constant = false;
                    break;
                }
            }
            return constant;
        }

        private int createCircle2D(int handle, int k, FeatureProvider feature) throws Exception {
            DxfGroupVector polv = this.updateProperties(feature, k);
            DxfGroup circleFlag = new DxfGroup();
            circleFlag.setCode(100);
            polv.add((Object)circleFlag);
            DxfGroup xvertex = new DxfGroup();
            xvertex.setCode(10);
            Circle circle = (Circle)feature.getDefaultGeometry();
            xvertex.setData((Object)new Double(circle.getCenter().getX()));
            DxfGroup yvertex = new DxfGroup();
            yvertex.setCode(20);
            yvertex.setData((Object)new Double(circle.getCenter().getY()));
            DxfGroup zvertex = new DxfGroup();
            zvertex.setCode(30);
            zvertex.setData((Object)new Double(0.0));
            DxfGroup radius = new DxfGroup();
            radius.setCode(40);
            radius.setData((Object)new Double(circle.getRadious()));
            polv.add((Object)xvertex);
            polv.add((Object)yvertex);
            polv.add((Object)zvertex);
            polv.add((Object)radius);
            this.entityMaker.createCircle(polv);
            return ++k;
        }

        private int createArc2D(int handle, int k, FeatureProvider feature) throws Exception {
            Arc arc = (Arc)feature.getDefaultGeometry();
            org.gvsig.fmap.geom.primitive.Point[] pts = new org.gvsig.fmap.geom.primitive.Point[]{arc.getInitPoint(), arc.getMiddlePoint(), arc.getEndPoint()};
            org.gvsig.fmap.geom.primitive.Point center = arc.getCenterPoint();
            GeometryOperationContext ctx = new GeometryOperationContext();
            ctx.setAttribute("geom", (Object)pts[0]);
            double radius = (Double)DXFStoreProvider.this.geomManager.invokeOperation(PointDistance.CODE, (org.gvsig.fmap.geom.Geometry)center, ctx);
            double initAngle = (Double)DXFStoreProvider.this.geomManager.invokeOperation(PointGetAngle.CODE, (org.gvsig.fmap.geom.Geometry)center, ctx);
            initAngle = Math.toDegrees(initAngle);
            ctx.setAttribute("geom", (Object)pts[1]);
            double midAngle = (Double)DXFStoreProvider.this.geomManager.invokeOperation(PointGetAngle.CODE, (org.gvsig.fmap.geom.Geometry)center, ctx);
            midAngle = Math.toDegrees(midAngle);
            ctx.setAttribute("geom", (Object)pts[2]);
            double endAngle = (Double)DXFStoreProvider.this.geomManager.invokeOperation(PointGetAngle.CODE, (org.gvsig.fmap.geom.Geometry)center, ctx);
            endAngle = Math.toDegrees(endAngle);
            if (initAngle <= endAngle) {
                if (!(initAngle <= midAngle) || !(midAngle <= endAngle)) {
                    double aux = initAngle;
                    initAngle = endAngle;
                    endAngle = aux;
                }
            } else if (initAngle >= midAngle && midAngle >= endAngle) {
                double aux = initAngle;
                initAngle = endAngle;
                endAngle = aux;
            }
            DxfGroup ax = new DxfGroup();
            DxfGroup ay = new DxfGroup();
            DxfGroup ac = new DxfGroup();
            DxfGroup ai = new DxfGroup();
            DxfGroup ae = new DxfGroup();
            ax.setCode(10);
            ax.setData((Object)new Double(center.getX()));
            ay.setCode(20);
            ay.setData((Object)new Double(center.getY()));
            ac.setCode(40);
            ac.setData((Object)new Double(radius));
            ai.setCode(50);
            ai.setData((Object)new Double(initAngle));
            ae.setCode(51);
            ae.setData((Object)new Double(endAngle));
            DxfGroupVector av = this.updateProperties(feature, k);
            av.add((Object)ax);
            av.add((Object)ay);
            av.add((Object)ac);
            av.add((Object)ai);
            av.add((Object)ae);
            this.entityMaker.createArc(av);
            return ++k;
        }

        private int createEllipse2D(int handle, int k, FeatureProvider feature) throws Exception {
            Ellipse ellipse = (Ellipse)feature.getDefaultGeometry();
            org.gvsig.fmap.geom.primitive.Point center = (org.gvsig.fmap.geom.primitive.Point)DXFStoreProvider.this.geomManager.create(1, 0);
            center.setCoordinateAt(0, (ellipse.getAxis1Start().getX() + ellipse.getAxis1End().getX()) / 2.0);
            center.setCoordinateAt(1, (ellipse.getAxis1Start().getY() + ellipse.getAxis1End().getY()) / 2.0);
            double mAxisL = ellipse.getAxis2Dist() * 2.0;
            GeometryOperationContext ctx = new GeometryOperationContext();
            ctx.setAttribute("geom", (Object)ellipse.getAxis1End());
            double maAxisL = (Double)DXFStoreProvider.this.geomManager.invokeOperation(PointDistance.CODE, (org.gvsig.fmap.geom.Geometry)ellipse.getAxis1Start(), ctx);
            Point2D.Double endPointOfMajorAxis = new Point2D.Double(ellipse.getAxis1End().getX(), ellipse.getAxis1End().getY());
            double azimut = Math.atan2(((Point2D)endPointOfMajorAxis).getX() - center.getX(), ((Point2D)endPointOfMajorAxis).getY() - center.getY());
            double azimut2 = azimut + 1.5707963267948966;
            if (azimut2 >= Math.PI * 2) {
                azimut2 -= Math.PI * 2;
            }
            Point2D.Double endPointOfMinorAxis = new Point2D.Double(center.getX() + ellipse.getAxis2Dist() * Math.sin(azimut2), center.getY() + ellipse.getAxis2Dist() * Math.cos(azimut2));
            if (mAxisL >= maAxisL) {
                double aux = mAxisL;
                mAxisL = maAxisL;
                maAxisL = aux;
                Point2D.Double pAux = endPointOfMinorAxis;
                endPointOfMinorAxis = endPointOfMajorAxis;
                endPointOfMajorAxis = pAux;
            }
            double mToMAR = mAxisL / maAxisL;
            DxfGroup x = new DxfGroup();
            DxfGroup y = new DxfGroup();
            DxfGroup xc = new DxfGroup();
            DxfGroup yc = new DxfGroup();
            DxfGroup minToMaj = new DxfGroup();
            x.setCode(10);
            x.setData((Object)new Double(center.getX()));
            y.setCode(20);
            y.setData((Object)new Double(center.getY()));
            xc.setCode(11);
            xc.setData((Object)new Double(((Point2D)endPointOfMajorAxis).getX() - center.getX()));
            yc.setCode(21);
            yc.setData((Object)new Double(((Point2D)endPointOfMajorAxis).getY() - center.getY()));
            minToMaj.setCode(40);
            minToMaj.setData((Object)new Double(mToMAR));
            DxfGroupVector av = this.updateProperties(feature, k);
            av.add((Object)x);
            av.add((Object)y);
            av.add((Object)xc);
            av.add((Object)yc);
            av.add((Object)minToMaj);
            this.entityMaker.createEllipse(av);
            return ++k;
        }

        public Envelope getEnvelope() {
            return this.envelope;
        }
    }

    public class Reader {
        private File file;
        private String fileName;
        private IProjection projection;
        private List<EditableFeatureType> types;
        private LegendBuilder leyendBuilder;
        private AbstractMemoryStoreProvider store;
        private Envelope envelope;
        private DxfFeatureMaker featureMaker;
        private DxfHeaderManager headerManager;

        public Reader initialice(AbstractMemoryStoreProvider store, File file, IProjection projection, LegendBuilder leyendBuilder) {
            this.store = store;
            this.file = file;
            this.fileName = file.getAbsolutePath();
            this.projection = projection;
            this.leyendBuilder = leyendBuilder;
            if (leyendBuilder != null) {
                leyendBuilder.initialize((FeatureStoreProvider)store);
            }
            return this;
        }

        public Envelope getEnvelope() {
            return this.envelope;
        }

        public void begin(FeatureStoreProviderServices store) throws LoadException {
            DXFStoreProvider.this.taskStatus.message("_preloading_data");
            this.featureMaker = new DxfFeatureMaker(this.projection);
            this.headerManager = new DxfHeaderManager();
            DxfFile dxfFeatureFile = new DxfFile(this.projection, this.file.getAbsolutePath(), (DxfFile.EntityFactory)this.featureMaker, (DxfFile.VarSettings)this.headerManager);
            try {
                dxfFeatureFile.load();
            }
            catch (Exception e1) {
                throw new LoadException((Throwable)e1, this.fileName);
            }
            DXFStoreProvider.this.taskStatus.message("_preparing_featureType");
            int geometrySubtype = this.featureMaker.isDxf3DFile() && this.headerManager.isWritedDxf3D() ? 1 : 0;
            EditableFeatureType featureType = store.createFeatureType(DXFStoreProvider.this.getName());
            DXFStoreProvider.initializeFeatureType(featureType, this.projection, geometrySubtype);
            this.types = new ArrayList<EditableFeatureType>();
            this.types.add(featureType);
            if (this.leyendBuilder != null) {
                DXFStoreProvider.this.taskStatus.message("_preparing_leyend");
                this.leyendBuilder.begin();
            }
        }

        public void end() {
            if (this.leyendBuilder != null) {
                this.leyendBuilder.end();
            }
        }

        public List<EditableFeatureType> getTypes() {
            return this.types;
        }

        public EditableFeatureType getDefaultType() {
            return this.types.get(0);
        }

        private Double toDouble(String value) {
            if (value == null) {
                return 0.0;
            }
            return Double.valueOf(value);
        }

        private FeatureProvider createFeature(org.gvsig.dxf.px.gml.Feature fea, FeatureType ft, int id) throws DataException {
            FeatureProvider feature = this.store.createFeatureProvider(ft);
            feature.setOID((Object)new Long(id));
            feature.set(0, (Object)id);
            feature.set(2, (Object)fea.getProp("dxfEntity"));
            feature.set(3, (Object)fea.getProp("layer"));
            feature.set(4, (Object)Integer.valueOf(fea.getProp("color")));
            feature.set(7, (Object)fea.getProp("text"));
            feature.set(8, (Object)this.toDouble(fea.getProp("textHeight")));
            feature.set(9, (Object)this.toDouble(fea.getProp("textRotation")));
            feature.set(5, (Object)this.toDouble(fea.getProp("elevation")));
            feature.set(6, (Object)this.toDouble(fea.getProp("thickness")));
            feature.set(1, null);
            return feature;
        }

        private org.gvsig.fmap.geom.Geometry processPoints(GeometryManager gManager, org.gvsig.dxf.px.gml.Feature dxffeature) throws CreateGeometryException {
            if (dxffeature.getGeometry() instanceof Point3D) {
                Point3D point = (Point3D)dxffeature.getGeometry();
                org.gvsig.dxf.geo.Point3D pto = point.getPoint3D(0);
                org.gvsig.fmap.geom.primitive.Point geom = gManager.createPoint(pto.getX(), pto.getY(), 1);
                geom.setCoordinateAt(2, pto.getZ());
                if (point.isTextPoint()) {
                    // empty if block
                }
                return geom;
            }
            if (dxffeature.getGeometry() instanceof Point) {
                Point point = (Point)dxffeature.getGeometry();
                Point2D pto = point.get(0);
                org.gvsig.fmap.geom.primitive.Point geom = gManager.createPoint(pto.getX(), pto.getY(), 0);
                if (point.isTextPoint()) {
                    // empty if block
                }
                return geom;
            }
            return null;
        }

        private org.gvsig.fmap.geom.Geometry processLines(GeometryManager gManager, org.gvsig.dxf.px.gml.Feature dxffeature) throws CreateGeometryException {
            if (dxffeature.getGeometry() instanceof LineString3D) {
                Line line = gManager.createLine(1);
                for (int j = 0; j < dxffeature.getGeometry().pointNr(); ++j) {
                    org.gvsig.dxf.geo.Point3D point = ((LineString3D)dxffeature.getGeometry()).getPoint3D(j);
                    line.addVertex(point.getX(), point.getY(), point.getZ());
                }
                return line;
            }
            if (dxffeature.getGeometry() instanceof LineString) {
                Line line = gManager.createLine(0);
                for (int j = 0; j < dxffeature.getGeometry().pointNr(); ++j) {
                    Point2D point = dxffeature.getGeometry().get(j);
                    line.addVertex(point.getX(), point.getY());
                }
                return line;
            }
            return null;
        }

        private org.gvsig.fmap.geom.Geometry processPolygons(GeometryManager gManager, org.gvsig.dxf.px.gml.Feature dxffeature) throws CreateGeometryException {
            Geometry geom = dxffeature.getGeometry();
            if (geom instanceof org.gvsig.dxf.px.gml.Polygon) {
                if (((org.gvsig.dxf.px.gml.Polygon)geom).is3D()) {
                    Polygon polygon = gManager.createPolygon(1);
                    for (int j = 0; j < dxffeature.getGeometry().pointNr(); ++j) {
                        org.gvsig.dxf.geo.Point3D point = (org.gvsig.dxf.geo.Point3D)dxffeature.getGeometry().get(j);
                        polygon.addVertex(point.getX(), point.getY(), point.getZ());
                    }
                    org.gvsig.dxf.geo.Point3D point = (org.gvsig.dxf.geo.Point3D)dxffeature.getGeometry().get(0);
                    polygon.addVertex(point.getX(), point.getY(), point.getZ());
                    return polygon;
                }
                Polygon polygon = gManager.createPolygon(0);
                for (int j = 0; j < dxffeature.getGeometry().pointNr(); ++j) {
                    Point2D point = dxffeature.getGeometry().get(j);
                    polygon.addVertex(point.getX(), point.getY());
                }
                Point2D point = dxffeature.getGeometry().get(0);
                polygon.addVertex(point.getX(), point.getY());
                return polygon;
            }
            return null;
        }

        private void addGeometryToFeature(org.gvsig.fmap.geom.Geometry geometry, FeatureProvider feature) {
            if (geometry != null) {
                feature.set(1, (Object)geometry);
                feature.setDefaultGeometry(geometry);
                if (this.envelope == null) {
                    this.envelope = geometry.getEnvelope();
                } else {
                    this.envelope.add(geometry.getEnvelope());
                }
            }
        }

        private void addfeatureToLegend(FeatureProvider feature) {
            if (this.leyendBuilder != null) {
                try {
                    this.leyendBuilder.process(feature);
                }
                catch (Exception e) {
                    logger.warn(MessageFormat.format("load: legendBuilder process fails in the feature {1}", feature));
                }
            }
        }

        public void load() throws DataException {
            org.gvsig.fmap.geom.Geometry geometry;
            org.gvsig.dxf.px.gml.Feature dxffeature;
            int i;
            this.envelope = null;
            IObjList.vector features = (IObjList.vector)this.featureMaker.getObjects();
            String acadVersion = this.headerManager.getAcadVersion();
            logger.info("load: acadVersion = '" + acadVersion + "'");
            GeometryManager gManager = GeometryLocator.getGeometryManager();
            if (!this.featureMaker.isDxf3DFile() && !this.headerManager.isWritedDxf3D()) {
                int i2;
                DXFStoreProvider.this.taskStatus.message("_fixing_3dgeometries");
                org.gvsig.dxf.px.gml.Feature[] features2D = new org.gvsig.dxf.px.gml.Feature[features.size()];
                DXFStoreProvider.this.taskStatus.setRangeOfValues(0L, (long)features.size());
                for (i2 = 0; i2 < features.size(); ++i2) {
                    int j;
                    DXFStoreProvider.this.taskStatus.setCurValue((long)i2);
                    org.gvsig.dxf.px.gml.Feature fea = (org.gvsig.dxf.px.gml.Feature)features.get(i2);
                    if (fea.getGeometry() instanceof Point3D) {
                        Point point = (Point)fea.getGeometry();
                        Point point2 = new Point();
                        for (j = 0; j < point.pointNr(); ++j) {
                            point2.add(point.get(j));
                        }
                        point2.setTextPoint(point.isTextPoint());
                        fea.setGeometry((Geometry)point2);
                        features2D[i2] = fea;
                        continue;
                    }
                    if (fea.getGeometry() instanceof LineString3D) {
                        LineString lineString = (LineString)fea.getGeometry();
                        LineString lineString2 = new LineString();
                        for (j = 0; j < lineString.pointNr(); ++j) {
                            lineString2.add(lineString.get(j));
                        }
                        fea.setGeometry((Geometry)lineString2);
                        features2D[i2] = fea;
                        continue;
                    }
                    if (!(fea.getGeometry() instanceof Polygon3D)) continue;
                    org.gvsig.dxf.px.gml.Polygon polygon = (org.gvsig.dxf.px.gml.Polygon)fea.getGeometry();
                    org.gvsig.dxf.px.gml.Polygon polygon2 = new org.gvsig.dxf.px.gml.Polygon();
                    for (j = 0; j < polygon.pointNr(); ++j) {
                        polygon2.add(polygon.get(j));
                    }
                    fea.setGeometry((Geometry)polygon2);
                    features2D[i2] = fea;
                }
                features.clear();
                for (i2 = 0; i2 < features2D.length; ++i2) {
                    features.add((Extent.Has)features2D[i2]);
                }
            }
            FilteredLogger logger = new FilteredLogger(logger, "DXFLoafing", 20);
            FeatureType ft = this.store.getStoreServices().getDefaultFeatureType();
            DXFStoreProvider.this.taskStatus.message("_loading");
            int n = 0;
            DXFStoreProvider.this.taskStatus.setRangeOfValues(0L, (long)(features.size() * 3));
            for (i = 0; i < features.size(); ++i) {
                DXFStoreProvider.this.taskStatus.setCurValue((long)n++);
                try {
                    dxffeature = (org.gvsig.dxf.px.gml.Feature)features.get(i);
                    FeatureProvider feature = this.createFeature(dxffeature, ft, i);
                    geometry = this.processPolygons(gManager, dxffeature);
                    if (geometry == null) continue;
                    this.addGeometryToFeature(geometry, feature);
                    this.store.addFeatureProvider(feature);
                    this.addfeatureToLegend(feature);
                    continue;
                }
                catch (Exception e) {
                    logger.warn("Can't proccess feature '" + i + ", of file '" + this.fileName + "'.", (Throwable)e);
                }
            }
            for (i = 0; i < features.size(); ++i) {
                DXFStoreProvider.this.taskStatus.setCurValue((long)n++);
                try {
                    dxffeature = (org.gvsig.dxf.px.gml.Feature)features.get(i);
                    FeatureProvider feature = this.createFeature(dxffeature, ft, i);
                    geometry = this.processLines(gManager, dxffeature);
                    if (geometry == null) continue;
                    this.addGeometryToFeature(geometry, feature);
                    this.store.addFeatureProvider(feature);
                    this.addfeatureToLegend(feature);
                    continue;
                }
                catch (Exception e) {
                    logger.warn("Can't proccess feature '" + i + ", of file '" + this.fileName + "'.", (Throwable)e);
                }
            }
            for (i = 0; i < features.size(); ++i) {
                DXFStoreProvider.this.taskStatus.setCurValue((long)n++);
                try {
                    dxffeature = (org.gvsig.dxf.px.gml.Feature)features.get(i);
                    FeatureProvider feature = this.createFeature(dxffeature, ft, i);
                    geometry = this.processPoints(gManager, dxffeature);
                    if (geometry == null) continue;
                    this.addGeometryToFeature(geometry, feature);
                    this.store.addFeatureProvider(feature);
                    this.addfeatureToLegend(feature);
                    continue;
                }
                catch (Exception e) {
                    logger.warn("Can't proccess feature '" + i + ", of file '" + this.fileName + "'.", (Throwable)e);
                }
            }
        }
    }

    private class DXFData {
        public List<FeatureProvider> data = null;
        public FeatureType defaultFType = null;
        public List<FeatureType> fTypes = null;
        public Envelope envelope = null;
        public IProjection projection;
        public LegendBuilder legendBuilder;

        private DXFData() {
        }

        public Envelope getEnvelopeCopy() throws CreateEnvelopeException {
            if (this.envelope == null) {
                return null;
            }
            Envelope newEnvelope = this.envelope.getDimension() == 2 ? DXFStoreProvider.this.geomManager.createEnvelope(0) : DXFStoreProvider.this.geomManager.createEnvelope(1);
            newEnvelope.setLowerCorner(this.envelope.getLowerCorner());
            newEnvelope.setUpperCorner(this.envelope.getUpperCorner());
            return newEnvelope;
        }
    }
}

