/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.utils.swing.jcomboServer;

import javax.swing.JComboBox;
import org.gvsig.utils.swing.jcomboServer.ServerData;

public class JComboServer
extends JComboBox {
    public JComboServer() {
    }

    public JComboServer(ServerData[] servers) {
        super(JComboServer.setLastAccessOrder(servers));
    }

    public ServerData getSelectedServer() {
        try {
            return (ServerData)this.getSelectedItem();
        }
        catch (ClassCastException e) {
            return new ServerData((String)this.getSelectedItem(), "", "");
        }
    }

    public void addServer(ServerData server) {
        ServerData[] servers = this.getAllServers();
        ServerData[] newServers = new ServerData[servers.length + 1];
        System.arraycopy(servers, 0, newServers, 0, servers.length);
        newServers[servers.length] = server;
        newServers = JComboServer.setLastAccessOrder(newServers);
        this.setServerList(newServers);
    }

    public ServerData[] getAllServers() {
        ServerData[] servers = new ServerData[this.getItemCount()];
        for (int i = 0; i < this.getItemCount(); ++i) {
            servers[i] = (ServerData)this.getItemAt(i);
        }
        return servers;
    }

    public void setServerList(ServerData[] servers) {
        this.removeAllItems();
        servers = JComboServer.setLastAccessOrder(servers);
        for (int i = 0; i < servers.length; ++i) {
            try {
                if (servers[i].getServerAddress().equals("")) continue;
                this.addItem(servers[i]);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void setServersOrder() {
        ServerData[] servers = this.getAllServers();
        servers = JComboServer.setLastAccessOrder(servers);
        this.setServerList(servers);
    }

    private static ServerData[] setLastAccessOrder(ServerData[] servers) {
        ServerData[] orderedServerData = new ServerData[servers.length];
        for (int i = 0; i < servers.length; ++i) {
            int pos = JComboServer.getServerPosition(servers, i);
            orderedServerData[pos] = servers[i];
        }
        return orderedServerData;
    }

    private static int getServerPosition(ServerData[] servers, int serverPos) {
        int pos = 0;
        for (int i = 0; i < servers.length; ++i) {
            if (servers[serverPos].getServerAddress().equals(servers[i].getServerAddress())) continue;
            if (servers[serverPos].getLastAccess().before(servers[i].getLastAccess())) {
                ++pos;
            }
            if (!servers[serverPos].getLastAccess().equals(servers[i].getLastAccess()) || serverPos >= i) continue;
            ++pos;
        }
        return pos;
    }
}

