/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.addlayer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.gui.WizardPanel;
import org.gvsig.app.gui.wizards.WizardListener;
import org.gvsig.app.project.DefaultProject;
import org.gvsig.gui.beans.AcceptCancelPanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddLayerDialog
extends JPanel
implements IWindow,
org.gvsig.tools.swing.api.Component,
Disposable {
    private static Logger logger = LoggerFactory.getLogger(AddLayerDialog.class);
    private static IProjection proj = null;
    private JTabbedPane jTabbedPane = null;
    private AcceptCancelPanel jPanel = null;
    private boolean accepted = false;
    private String title = PluginServices.getText((Object)this, (String)"add_layer");
    private final WizardListener wizardListener = new DialogWizardListener();

    public AddLayerDialog() {
        this.initialize();
    }

    public AddLayerDialog(String title) {
        this.title = title;
        this.initialize();
    }

    private void initialize() {
        ToolsLocator.getDisposableManager().bind((Disposable)this);
        this.setLayout(new BorderLayout());
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)22, (int)90, (int)25, (int)100);
        this.add((Component)this.getJTabbedPane(), "Center");
        this.add((Component)this.getJPanel(), "South");
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.setBounds(0, 0, this.getWindowInfo().getWidth() - 10, this.getWindowInfo().getHeight() - 10);
            this.jTabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JTabbedPane tabs = (JTabbedPane)e.getSource();
                    Component sel_tab = tabs.getSelectedComponent();
                    if (sel_tab instanceof WizardPanel) {
                        WizardPanel wipa = (WizardPanel)sel_tab;
                        AddLayerDialog.this.wizardListener.wizardStateChanged(wipa.areSettingsValid());
                    }
                }
            });
        }
        return this.jTabbedPane;
    }

    public void addTab(String title, JPanel panel) {
        this.getJTabbedPane().addTab(title, panel);
    }

    public void addWizardTab(String title, WizardPanel panel) {
        panel.addWizardListener(this.wizardListener);
        this.getJTabbedPane().addTab(title, panel);
    }

    public WizardPanel getPanel(String title) {
        for (int i = 0; i < this.getJTabbedPane().getTabCount(); ++i) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)title, (CharSequence)this.getJTabbedPane().getTitleAt(i))) continue;
            return (WizardPanel)this.getJTabbedPane().getComponentAt(i);
        }
        return null;
    }

    public JPanel getSelectedTab() {
        return (JPanel)this.getJTabbedPane().getSelectedComponent();
    }

    public void setSelectedTab(String title) {
        if (StringUtils.isBlank((CharSequence)title)) {
            return;
        }
        for (int i = 0; i < this.getJTabbedPane().getTabCount(); ++i) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)title, (CharSequence)this.getJTabbedPane().getTitleAt(i))) continue;
            this.getJTabbedPane().setSelectedIndex(i);
        }
    }

    public WindowInfo getWindowInfo() {
        WindowInfo m_viewinfo = new WindowInfo(9);
        m_viewinfo.setTitle(this.title);
        Dimension dim = this.getPreferredSize();
        m_viewinfo.setHeight(dim.height);
        m_viewinfo.setWidth(dim.width);
        return m_viewinfo;
    }

    public void updateOkButtonState() {
        if (this.getSelectedTab() instanceof WizardPanel) {
            WizardPanel wp = (WizardPanel)this.getSelectedTab();
            this.getJPanel().setOkButtonEnabled(wp.areSettingsValid());
        }
    }

    private AcceptCancelPanel getJPanel() {
        if (this.jPanel == null) {
            ActionListener okAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddLayerDialog.this.accepted = true;
                    AddLayerDialog.this.closeWindow();
                }
            };
            ActionListener cancelAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddLayerDialog.this.closeWindow();
                }
            };
            this.jPanel = new AcceptCancelPanel(okAction, cancelAction);
            this.jPanel.setOkButtonEnabled(false);
        }
        return this.jPanel;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public static IProjection getLastProjection() {
        if (proj == null) {
            proj = DefaultProject.getDefaultProjection();
        }
        return proj;
    }

    public static void setLastProjection(IProjection proj) {
        AddLayerDialog.proj = proj;
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }

    private void closeWindow() {
        if (PluginServices.getMainFrame() == null) {
            try {
                ((JDialog)this.getParent().getParent().getParent().getParent()).dispose();
            }
            catch (Exception ex) {
                logger.debug("Can't close window.", (Throwable)ex);
            }
        } else {
            PluginServices.getMDIManager().closeWindow((IWindow)this);
        }
    }

    public void dispose() {
        JTabbedPane tabbed = this.getJTabbedPane();
        for (int i = 0; i < tabbed.getTabCount(); ++i) {
            Component component = tabbed.getComponentAt(i);
            if (!(component instanceof WizardPanel)) continue;
            ((WizardPanel)component).close();
        }
        ToolsLocator.getDisposableManager().release((Disposable)this);
    }

    public JComponent asJComponent() {
        return this;
    }

    public class DialogWizardListener
    implements WizardListener {
        @Override
        public void error(Exception e) {
        }

        @Override
        public void wizardStateChanged(boolean finishable) {
            AddLayerDialog.this.getJPanel().setOkButtonEnabled(finishable);
        }
    }
}

