/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.apache.commons.io.FileUtils;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.installer.lib.api.InstallerLocator;
import org.gvsig.installer.lib.api.InstallerManager;
import org.gvsig.installer.lib.api.PackageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckSOAndArquitectureExtension
extends Extension
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CheckSOAndArquitectureExtension.class);

    public void initialize() {
    }

    public void execute(String actionCommand) {
    }

    public boolean isEnabled() {
        return false;
    }

    public boolean isVisible() {
        return false;
    }

    public void postInitialize() {
        PluginsManager pluginManager = PluginsLocator.getManager();
        pluginManager.addStartupTask("CheckOsAndArquitectre", (Runnable)this, true, 2000);
    }

    @Override
    public void run() {
        ApplicationManager application = ApplicationLocator.getManager();
        InstallerManager installmgr = InstallerLocator.getInstallerManager();
        PluginsManager pluginmgr = PluginsLocator.getManager();
        HashSet<PackageInfo> mismatchs = new HashSet<PackageInfo>();
        String recommendedArchitecture = installmgr.getArchitecture();
        try {
            PackageInfo[] pkgs;
            for (PackageInfo pkg : pkgs = installmgr.getInstalledPackages()) {
                if (!"all".equalsIgnoreCase(pkg.getArchitecture()) && !installmgr.getArchitecture().equalsIgnoreCase(pkg.getArchitecture())) {
                    recommendedArchitecture = pkg.getArchitecture();
                    mismatchs.add(pkg);
                }
                if ("all".equalsIgnoreCase(pkg.getOperatingSystemFamily()) || installmgr.getOperatingSystemFamily().equalsIgnoreCase(pkg.getOperatingSystemFamily())) continue;
                mismatchs.add(pkg);
            }
        }
        catch (Throwable e) {
            logger.info("Can't get installed packages.", e);
        }
        if (mismatchs.isEmpty()) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        for (PackageInfo pkg : mismatchs) {
            buffer.append(pkg.getName());
            buffer.append(" (");
            buffer.append(pkg.getOperatingSystem());
            buffer.append("/");
            buffer.append(pkg.getArchitecture());
            buffer.append(")");
            buffer.append("<br>\n");
        }
        String template = "<html><p>gvSIG is running on a platform $(CURRENT_ARCHITECTURE)</p>\n<br>\n<p>Packages are installed that are not compatible with your system.</p>\n<br>\n$(PACKAGES)<br>\n<p>Some are not specific to your system or architecture.</p>\n<br>\n<p>You probably need to configure a $(RECOMMENDED_ARCHITECTURE) Java environment\nfor the proper functioning of gvSIG.</p>\n</html>\n";
        try {
            String fname = "i18n/" + application.translate("_filename_warning_architecture_or_os_mismatch", new String[0]);
            URL res = this.getClass().getClassLoader().getResource(fname);
            template = FileUtils.readFileToString((File)new File(res.getFile()));
        }
        catch (Throwable e) {
            logger.info("Can't get template, use default.", e);
        }
        String msg = template.replaceAll("[$][(]PACKAGES[)]", buffer.toString());
        msg = msg.replaceAll("[%]PACKAGES[%]", buffer.toString());
        msg = msg.replaceAll("[$]PACKAGES", buffer.toString());
        msg = msg.replaceAll("[$][(]RECOMMENDED_ARCHITECTURE[)]", recommendedArchitecture);
        msg = msg.replaceAll("[%]RECOMMENDED_ARCHITECTURE[%]", recommendedArchitecture);
        msg = msg.replaceAll("[$]RECOMMENDED_ARCHITECTURE", recommendedArchitecture);
        msg = msg.replaceAll("[$][(]CURRENT_ARCHITECTURE[)]", installmgr.getArchitecture());
        msg = msg.replaceAll("[%]CURRENT_ARCHITECTURE[%]", installmgr.getArchitecture());
        msg = msg.replaceAll("[$]CURRENT_ARCHITECTURE", installmgr.getArchitecture());
        application.showDialog(new ShowMessageControler(msg), "_Warning");
    }

    public class ShowMessageView
    extends JPanel {
        private static final long serialVersionUID = 8291970039773969840L;
        JTextPane messaje = new JTextPane();
        JButton closeButton = new JButton();

        public ShowMessageView() {
            this.initializePanel();
        }

        private void addFillComponents(Container panel, int[] cols, int[] rows) {
            int index;
            Dimension filler = new Dimension(10, 10);
            boolean filled_cell_11 = false;
            CellConstraints cc = new CellConstraints();
            if (cols.length > 0 && rows.length > 0 && cols[0] == 1 && rows[0] == 1) {
                panel.add(Box.createRigidArea(filler), cc.xy(1, 1));
                filled_cell_11 = true;
            }
            for (index = 0; index < cols.length; ++index) {
                if (cols[index] == 1 && filled_cell_11) continue;
                panel.add(Box.createRigidArea(filler), cc.xy(cols[index], 1));
            }
            for (index = 0; index < rows.length; ++index) {
                if (rows[index] == 1 && filled_cell_11) continue;
                panel.add(Box.createRigidArea(filler), cc.xy(1, rows[index]));
            }
        }

        @Override
        public void applyComponentOrientation(ComponentOrientation orientation) {
            super.applyComponentOrientation(orientation);
        }

        public JPanel createPanel() {
            JPanel jpanel1 = new JPanel();
            FormLayout formlayout1 = new FormLayout("FILL:DEFAULT:NONE,FILL:DEFAULT:GROW(1.0),FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:GROW(1.0),CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
            CellConstraints cc = new CellConstraints();
            jpanel1.setLayout((LayoutManager)formlayout1);
            JScrollPane jscrollpane1 = new JScrollPane();
            jscrollpane1.setViewportView(this.messaje);
            jscrollpane1.setVerticalScrollBarPolicy(20);
            jscrollpane1.setHorizontalScrollBarPolicy(30);
            jpanel1.add((Component)jscrollpane1, new CellConstraints(2, 2, 3, 1, CellConstraints.DEFAULT, CellConstraints.FILL));
            this.closeButton.setActionCommand("JButton");
            this.closeButton.setText("JButton");
            jpanel1.add((Component)this.closeButton, cc.xy(3, 4));
            this.addFillComponents(jpanel1, new int[]{1, 2, 3, 4, 5}, new int[]{1, 2, 3, 4, 5});
            return jpanel1;
        }

        protected void initializePanel() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.createPanel(), "Center");
        }
    }

    public class ShowMessageControler
    extends ShowMessageView {
        private static final long serialVersionUID = 2641062720310466029L;

        public ShowMessageControler(String message) {
            this.messaje.setContentType("text/html");
            this.messaje.setText(message);
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ShowMessageControler.this.close();
                }
            });
            ApplicationManager application = ApplicationLocator.getManager();
            this.closeButton.setText(application.translate("Close", new String[0]));
        }

        public void close() {
            this.setVisible(false);
        }
    }
}

