/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoToolExtension
extends Extension {
    private static final Logger logger = LoggerFactory.getLogger(InfoToolExtension.class);

    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"layer-info-by-point", (Object)((Object)this));
    }

    public void execute(String s) {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return;
        }
        ViewDocument document = view.getViewDocument();
        if (s.compareTo("layer-info-by-point") == 0) {
            MapControl mapCtrl = view.getMapControl();
            mapCtrl.setTool("info");
            document.setModified(true);
        }
    }

    public boolean isEnabled() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return false;
        }
        ViewDocument document = view.getViewDocument();
        MapContext mapa = document.getMapContext();
        FLayer[] layers = mapa.getLayers().getActives();
        for (int i = 0; i < layers.length; ++i) {
            if (!layers[i].isAvailable()) continue;
            return true;
        }
        return false;
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return false;
        }
        ViewDocument document = view.getViewDocument();
        MapContext mapa = document.getMapContext();
        return mapa.getLayers().getLayersCount() > 0;
    }
}

