/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.beans.PropertyVetoException;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.andami.Arguments;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.DocumentManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemFileFilter;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorer;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.tools.dynobject.DynField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenLayerOnStart
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(OpenLayerOnStart.class);

    @Override
    public void run() {
        PluginsManager PluginManager = PluginsLocator.getManager();
        DataManager dataManager = DALLocator.getDataManager();
        ApplicationManager application = ApplicationLocator.getManager();
        ProjectManager projectManager = application.getProjectManager();
        DocumentManager viewManager = projectManager.getDocumentManager(ViewManager.TYPENAME);
        MapContextManager mapContextManager = MapContextLocator.getMapContextManager();
        Project project = application.getProjectManager().getCurrentProject();
        Arguments args = PluginManager.getArguments();
        ArrayList params = new ArrayList(args.parameters());
        params.remove(0);
        params.remove(0);
        for (String param : params) {
            if (StringUtils.isEmpty((CharSequence)param) || !param.endsWith(".gvsproj")) continue;
            try {
                File f = new File(param);
                application.getUIManager().closeAllWindows();
                project = projectManager.createProject();
                project.loadState(f);
                projectManager.setCurrentProject(project);
            }
            catch (Throwable th) {
                logger.warn("Can't load project '" + param + "'.", th);
            }
            break;
        }
        ViewDocument viewDoc = null;
        FilesystemServerExplorer explorer = null;
        FilesystemFileFilter filter = null;
        IProjection proj = null;
        for (String param : params) {
            try {
                DynField[] fields;
                File f;
                if (FilenameUtils.isExtension((String)param, (String)"gvproj")) continue;
                if (explorer == null) {
                    DataServerExplorerParameters explorerparams = dataManager.createServerExplorerParameters("FilesystemExplorer");
                    explorer = (FilesystemServerExplorer)dataManager.openServerExplorer("FilesystemExplorer", explorerparams);
                    filter = explorer.getFilter(6, "All formats");
                }
                if (!filter.accept(f = new File(param))) continue;
                if (viewDoc == null) {
                    viewDoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
                    if (viewDoc == null || !viewDoc.getMapContext().getLayers().isEmpty()) {
                        application.getUIManager().closeAllWindows();
                        viewDoc = (ViewDocument)((Object)viewManager.createDocument());
                        project.addDocument(viewDoc);
                    }
                    proj = viewDoc.getMapContext().getProjection();
                    IView viewWindow = (IView)viewManager.getMainWindow(viewDoc);
                    application.getUIManager().addWindow((IWindow)viewWindow, 10);
                    try {
                        application.getUIManager().setMaximum((IWindow)viewWindow, true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
                DataStoreParameters storeParams = explorer.createStoreParameters(f);
                for (DynField field : fields = storeParams.getDynClass().getDynFields()) {
                    if (field.getType() != 65 || !field.isMandatory() || storeParams.getDynValue(field.getName()) != null) continue;
                    storeParams.setDynValue(field.getName(), (Object)proj);
                }
                DataStore store = dataManager.openStore(storeParams.getDataStoreName(), storeParams);
                FLayer layer = mapContextManager.createLayer(store.getName(), store);
                viewDoc.getMapContext().getLayers().add(layer);
            }
            catch (Throwable th) {
                logger.warn("Can't load layer '" + param + "'.", th);
            }
        }
    }
}

