/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.awt.Component;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import java.util.zip.ZipFile;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.Launcher;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.actioninfo.ActionInfo;
import org.gvsig.andami.actioninfo.ActionInfoManager;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.plugins.IExtension;
import org.gvsig.andami.plugins.status.IExtensionStatus;
import org.gvsig.andami.plugins.status.IUnsavedData;
import org.gvsig.andami.plugins.status.UnsavedData;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.andami.ui.wizard.UnsavedDataPanel;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.gui.ProjectPreviewPanel;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.gui.ProjectWindow;
import org.gvsig.app.project.documents.gui.projectpanel.ProjectDocumentsPanelPageFactory;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.filedialogchooser.FileDialogChooser;
import org.gvsig.filedialogchooser.FileDialogChooserManager;
import org.gvsig.propertypage.PropertiesPageFactory;
import org.gvsig.propertypage.PropertiesPageManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.arguments.Arguments;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.gvsig.utils.GenericFileFilter;
import org.gvsig.utils.save.AfterSavingListener;
import org.gvsig.utils.save.BeforeSavingListener;
import org.gvsig.utils.save.SaveEvent;
import org.gvsig.utils.swing.threads.IMonitorableTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectExtension
extends Extension
implements IExtensionStatus {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectExtension.class);
    private static String projectPath = null;
    private ProjectWindow projectFrame;
    private Project p;
    private String lastSavePath;
    private WindowInfo seedProjectWindow;
    public static final String PROJECT_FILE_CHOOSER_ID = "PROJECT_FILECHOOSER_ID";
    public static String PROJECTENCODING = "UTF-8";
    private final List<BeforeSavingListener> beforeSavingListeners;
    private final List<AfterSavingListener> afterSavingListeners = new ArrayList<AfterSavingListener>();

    public ProjectExtension() {
        this.beforeSavingListeners = new ArrayList<BeforeSavingListener>();
    }

    public void initialize() {
        this.initializeDocumentActionsExtensionPoint();
        this.registerDocuments();
        this.registerIcons();
        PropertiesPageManager propertiesManager = ToolsUtilLocator.getPropertiesPageManager();
        propertiesManager.registerFactory((PropertiesPageFactory)new ProjectDocumentsPanelPageFactory());
        File projectFile = this.getProjectFileFromArguments();
        if (projectFile != null) {
            PluginsLocator.getManager().addStartupTask("Open project", (Runnable)new OpenInitialProjectTask(projectFile), true, 1000);
        }
    }

    private void registerIcons() {
        IconThemeHelper.registerIcon((String)"action", (String)"application-project-new", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"application-project-open", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"application-project-save", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"application-project-save-as", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"project", (String)"project-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"project", (String)"temporary-table-icon", (Object)((Object)this));
    }

    private File getProjectFileFromArguments() {
        String[] theArgs = PluginServices.getArguments();
        if (theArgs.length < 3) {
            return null;
        }
        String lastArg = theArgs[theArgs.length - 1];
        if (StringUtils.isEmpty((CharSequence)lastArg)) {
            return null;
        }
        if (lastArg.startsWith("-")) {
            return null;
        }
        if (!lastArg.toLowerCase().endsWith(".gvsproj".toLowerCase())) {
            LOG.info("Do not open project file, does not have the expected extension '.gvsproj' (" + lastArg + ").");
            return null;
        }
        File projectFile = new File(lastArg);
        if (!projectFile.exists()) {
            LOG.info("Do not open project file, '" + projectFile.getAbsolutePath() + "' do not exist.");
            return null;
        }
        return projectFile;
    }

    public ProjectWindow getProjectFrame() {
        if (this.projectFrame == null) {
            this.projectFrame = new ProjectWindow();
        }
        return this.projectFrame;
    }

    public void showProjectWindow() {
        if (this.seedProjectWindow != null) {
            if (this.seedProjectWindow.isClosed()) {
                this.seedProjectWindow.setClosed(false);
                return;
            }
            WindowInfo winProps = this.seedProjectWindow;
            this.seedProjectWindow = null;
            PluginServices.getMDIManager().addWindow((IWindow)this.getProjectFrame());
            PluginServices.getMDIManager().changeWindowInfo((IWindow)this.getProjectFrame(), winProps);
        } else {
            PluginServices.getMDIManager().addWindow((IWindow)this.getProjectFrame());
        }
    }

    public void showProjectWindow(WindowInfo wi) {
        this.seedProjectWindow = wi;
        this.showProjectWindow();
    }

    private boolean saveProject() {
        boolean saved;
        if (projectPath == null) {
            saved = this.saveAsProject(null);
        } else {
            long t1 = System.currentTimeMillis();
            saved = this.writeProject(new File(projectPath), this.p, false);
            long t2 = System.currentTimeMillis();
            PluginServices.getLogger().info("Project saved. " + (t2 - t1) + " miliseconds");
            this.getProjectFrame().setProject(this.p);
        }
        return saved;
    }

    private boolean saveAsProject(File file) {
        boolean saved = false;
        if (this.lastSavePath == null) {
            this.lastSavePath = projectPath;
        }
        if (file == null) {
            FileDialogChooserManager fileDialogChooserManager = ToolsUtilLocator.getFileDialogChooserManager();
            FileDialogChooser jfc = fileDialogChooserManager.create(PROJECT_FILE_CHOOSER_ID);
            if (this.lastSavePath == null) {
                jfc.setCurrentDirectory(this.getPreferredProjectsFolder());
            } else {
                jfc.setCurrentDirectory(new File(this.lastSavePath));
            }
            jfc.setDialogTitle(PluginServices.getText((Object)((Object)this), (String)"guardar_proyecto"));
            GenericFileFilter projExtensionFilter = new GenericFileFilter(".gvsproj", MessageFormat.format(PluginServices.getText((Object)((Object)this), (String)"tipo_fichero_proyecto"), ".gvsproj"));
            jfc.addChoosableFileFilter((FileFilter)projExtensionFilter);
            jfc.setFileFilter((FileFilter)projExtensionFilter);
            if (jfc.showSaveDialog((Component)PluginServices.getMainFrame()) != 0) {
                return saved;
            }
            file = jfc.getSelectedFile();
        }
        if (!file.getPath().toLowerCase().endsWith(".gvsproj".toLowerCase())) {
            file = new File(file.getPath() + ".gvsproj");
        }
        saved = this.writeProject(file, this.p);
        String filePath = file.getAbsolutePath();
        this.lastSavePath = FilenameUtils.getPath((String)filePath);
        this.getProjectFrame().setProject(this.p);
        return saved;
    }

    private boolean askSave() {
        if (this.p != null && this.p.hasChanged()) {
            Launcher.TerminationProcess process = Launcher.getTerminationProcess();
            UnsavedDataPanel panel = process.getUnsavedDataPanel();
            panel.setHeaderText(PluginServices.getText((Object)((Object)this), (String)"_Select_resources_to_save_before_closing_current_project"));
            panel.setAcceptText(PluginServices.getText((Object)((Object)this), (String)"save_resources"), PluginServices.getText((Object)((Object)this), (String)"Save_the_selected_resources_and_close_current_project"));
            panel.setCancelText(PluginServices.getText((Object)((Object)this), (String)"Cancel"), PluginServices.getText((Object)((Object)this), (String)"Return_to_current_project"));
            try {
                int closeCurrProj = process.manageUnsavedData();
                if (closeCurrProj == 1) {
                    return false;
                }
            }
            catch (Exception e) {
                LOG.error("Some data can not be saved", (Throwable)e);
            }
        }
        return true;
    }

    public void execute(String command) {
        this.execute(command, null);
    }

    public void execute(String actionCommand, Object[] args) {
        ApplicationManager application = ApplicationLocator.getApplicationManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        Arguments arguments = Arguments.create((Object[])args);
        switch (actionCommand) {
            case "application-project-new": {
                if (!this.askSave()) {
                    return;
                }
                projectPath = null;
                application.getUIManager().closeAllWindows();
                this.setProject(ProjectManager.getInstance().createProject());
                this.showProjectWindow();
                application.getMainFrame().setTitle(i18n.getTranslation("sin_titulo"));
                break;
            }
            case "application-project-open": {
                if (!this.askSave()) {
                    return;
                }
                File projectFile = (File)arguments.get(0, File.class, null);
                if (projectFile != null && !projectFile.exists()) {
                    LOG.warn("Can't load project '" + projectFile.getAbsolutePath() + "', file not exist.");
                    projectFile = null;
                }
                if (projectFile == null) {
                    FileDialogChooserManager fileDialogChooserManager = ToolsUtilLocator.getFileDialogChooserManager();
                    FileDialogChooser jfc = fileDialogChooserManager.create(PROJECT_FILE_CHOOSER_ID);
                    if (this.lastSavePath == null) {
                        jfc.setCurrentDirectory(this.getPreferredProjectsFolder());
                    } else {
                        jfc.setCurrentDirectory(new File(this.lastSavePath));
                    }
                    ProjectPreviewPanel preview = new ProjectPreviewPanel();
                    jfc.setAccessory((JComponent)preview);
                    jfc.addPropertyChangeListener((PropertyChangeListener)preview);
                    GenericFileFilter projExtensionFilter = new GenericFileFilter(".gvsproj", i18n.getTranslation("tipo_fichero_proyecto"));
                    jfc.addChoosableFileFilter((FileFilter)projExtensionFilter);
                    GenericFileFilter bakExtensionFilter = new GenericFileFilter(".gvsproj.bak", i18n.getTranslation("tipo_fichero_proyecto_bak"));
                    jfc.addChoosableFileFilter((FileFilter)bakExtensionFilter);
                    jfc.setFileFilter((FileFilter)projExtensionFilter);
                    if (jfc.showOpenDialog((Component)application.getMainFrame()) != 0) {
                        return;
                    }
                    projectFile = jfc.getSelectedFile();
                }
                this.setProject(ProjectManager.getInstance().createProject());
                this.loadProject(projectFile);
                break;
            }
            case "application-project-save": {
                try {
                    Launcher.manageUnsavedData((String)"there_are_unsaved_resources");
                }
                catch (Exception e) {
                    LOG.warn("Can't manage unsaved data", (Throwable)e);
                }
                break;
            }
            case "application-project-save-as": {
                File file = (File)arguments.get(0, File.class, null);
                this.saveAsProject(file);
                break;
            }
        }
    }

    private void loadProject(final File projectFile) {
        final ApplicationManager application = ApplicationLocator.getApplicationManager();
        application.getUIManager().closeAllWindows();
        PluginsLocator.getActionInfoManager().setAllDisabled(true);
        application.refreshMenusAndToolBars();
        Thread task = new Thread(() -> {
            final Project o = this.readProject(projectFile);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        if ("bak".equals(FilenameUtils.getExtension((String)projectFile.getAbsolutePath()))) {
                            ProjectExtension.setPath(null);
                        } else {
                            ProjectExtension.setPath(projectFile.getAbsolutePath());
                        }
                        if (o != null) {
                            ProjectExtension.this.setProject(o);
                        }
                        ProjectExtension.this.getProjectFrame().setProject(ProjectExtension.this.p);
                        application.getMainFrame().setTitle(projectFile.getName());
                    }
                    finally {
                        PluginsLocator.getActionInfoManager().setAllDisabled(false);
                        application.message("", 1);
                        application.refreshMenusAndToolBars();
                    }
                }
            });
        }, "LoadProject");
        task.start();
    }

    private File getPreferredProjectsFolder() throws LocatorException {
        Preferences prefs = Preferences.userRoot().node("gvsig.foldering");
        String v = prefs.get("ProjectsFolder", null);
        if (StringUtils.isBlank((CharSequence)v)) {
            return null;
        }
        return new File(v);
    }

    private void createEmptyProject() {
        this.setProject(ProjectManager.getInstance().createProject());
        this.p.setName(PluginServices.getText((Object)((Object)this), (String)"untitled"));
        this.p.setModified(false);
        PluginServices.getMainFrame().setTitle(PluginServices.getText((Object)((Object)this), (String)"sin_titulo"));
        this.setProject(this.p);
        this.showProjectWindow();
    }

    public void postInitialize() {
        PluginsManager pluginsManager = PluginsLocator.getManager();
        pluginsManager.addStartupTask("createEmptyProject", () -> this.createEmptyProject(), true, 1000);
    }

    public boolean writeProject(File file, Project p) {
        return this.writeProject(file, p, true);
    }

    public boolean writeProject(File file, Project p, boolean askConfirmation) {
        int resp;
        I18nManager i18n = ToolsLocator.getI18nManager();
        ApplicationManager application = ApplicationLocator.getManager();
        if (askConfirmation && file.exists() && (resp = application.confirmDialog(i18n.getTranslation("fichero_ya_existe_seguro_desea_guardarlo"), i18n.getTranslation("guardar"), 0, 3, "Overwrite_project_file")) != 0) {
            return false;
        }
        LOG.info("Writing project '" + file.getAbsolutePath() + "'.");
        try {
            this.fireBeforeSavingFileEvent(new SaveEvent((Object)this, 0, file));
            BufferedImage img = ApplicationLocator.getManager().getUIManager().getImagePreview();
            img = this.scale(img, 0.4);
            p.saveState(file, img);
            PluginServices.getMainFrame().setTitle(file.getName());
            ProjectExtension.setPath(file.toString());
        }
        catch (LocatorException e) {
            application.messageDialog(i18n.getTranslation("_Problems_saving_the_project_XnlX_It_is_possible_that_this_was_not_saved_properly_and_can_not_be_loaded_again"), null, i18n.getTranslation("guardar"), 0, "Problems_saving_the_project");
            LOG.warn("Error writing project '" + file.getAbsolutePath() + "'.", (Throwable)e);
            return false;
        }
        LOG.warn("Wrote project '" + file.getAbsolutePath() + "'.");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValidZIP(File file) {
        ZipFile zipfile = null;
        try {
            zipfile = new ZipFile(file);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (zipfile != null) {
                    zipfile.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private BufferedImage scale(BufferedImage before, double factor) {
        int w = (int)((double)before.getWidth() * factor);
        int h = (int)((double)before.getHeight() * factor);
        BufferedImage after = new BufferedImage(w, h, 1);
        AffineTransform at = new AffineTransform();
        at.scale(factor, factor);
        AffineTransformOp scaleOp = new AffineTransformOp(at, 2);
        after = scaleOp.filter(before, after);
        return after;
    }

    public Project readProject(String path) {
        Project project = ProjectManager.getInstance().createProject();
        project.loadState(new File(path));
        return project;
    }

    public Project readProject(File file) {
        Project project = ProjectManager.getInstance().createProject();
        project.loadState(file);
        Set<String> unloadedObjects = project.getUnloadedObjects();
        List<Exception> errors = project.getLoadErrors();
        if (!CollectionUtils.isEmpty(unloadedObjects)) {
            StringBuilder builder = new StringBuilder();
            builder.append("Unloaded elements loading the project:\n");
            Iterator<String> it = unloadedObjects.iterator();
            while (it.hasNext()) {
                builder.append("\t");
                builder.append(it.next());
                builder.append("\n");
            }
            LOG.warn(builder.toString());
        }
        if (!CollectionUtils.isEmpty(unloadedObjects) || !CollectionUtils.isEmpty(errors)) {
            ApplicationManager application = ApplicationLocator.getManager();
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            application.messageDialog(i18nManager.getTranslation("_some_project_elements_could_not_be_loaded") + "\n" + i18nManager.getTranslation("_maybe_you_need_to_install_any_plugins") + "\n" + i18nManager.getTranslation("_Recovered_data_may_be_corrupted") + "\n\n" + i18nManager.getTranslation("_see_error_log_for_more_information"), i18nManager.getTranslation("warning"), 2);
        }
        return project;
    }

    public Project getProject() {
        return this.p;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    public void setProject(Project p) {
        this.p = p;
        this.getProjectFrame().setProject(p);
    }

    private void registerDocuments() {
        ViewManager.register();
    }

    private void initializeDocumentActionsExtensionPoint() {
        ExtensionPointManager epMan = ToolsLocator.getExtensionPointManager();
        epMan.add("DocumentActions_View", "Context menu options of the view document list in the project window (register instances of org.gvsig.app.project.AbstractDocumentContextMenuAction)");
    }

    public static String getPath() {
        return projectPath;
    }

    public static void setPath(String path) {
        projectPath = path;
    }

    public IWindow getProjectWindow() {
        return this.getProjectFrame();
    }

    public IExtensionStatus getStatus() {
        return this;
    }

    public boolean hasUnsavedData() {
        return this.p.hasChanged();
    }

    public IUnsavedData[] getUnsavedData() {
        if (this.hasUnsavedData()) {
            UnsavedProject data = new UnsavedProject((IExtension)this);
            IUnsavedData[] dataArray = new IUnsavedData[]{data};
            return dataArray;
        }
        return null;
    }

    public IMonitorableTask[] getRunningProcesses() {
        return null;
    }

    public boolean hasRunningProcesses() {
        return false;
    }

    public synchronized void addListener(BeforeSavingListener l) {
        if (l == null) {
            return;
        }
        if (!this.beforeSavingListeners.contains(l)) {
            this.beforeSavingListeners.add(l);
        }
    }

    public synchronized void addListener(AfterSavingListener l) {
        if (l == null) {
            return;
        }
        if (!this.afterSavingListeners.contains(l)) {
            this.afterSavingListeners.add(l);
        }
    }

    public synchronized BeforeSavingListener[] getBeforeSavingListeners() {
        return this.beforeSavingListeners.toArray(new BeforeSavingListener[0]);
    }

    public synchronized AfterSavingListener[] getAfterSavingListeners() {
        return this.afterSavingListeners.toArray(new AfterSavingListener[0]);
    }

    public synchronized void removeListener(BeforeSavingListener l) {
        if (l == null) {
            return;
        }
        this.beforeSavingListeners.remove(l);
    }

    public synchronized void removeListener(AfterSavingListener l) {
        if (l == null) {
            return;
        }
        this.afterSavingListeners.remove(l);
    }

    protected void fireBeforeSavingFileEvent(SaveEvent evt) {
        if (evt.getID() != 0 || evt.getFile() == null) {
            return;
        }
        Iterator<BeforeSavingListener> iter = this.beforeSavingListeners.iterator();
        while (iter.hasNext()) {
            iter.next().beforeSaving(evt);
        }
    }

    protected void fireAfterSavingFileEvent(SaveEvent evt) {
        if (evt.getID() != 1 || evt.getFile() == null) {
            return;
        }
        Iterator<AfterSavingListener> iter = this.afterSavingListeners.iterator();
        while (iter.hasNext()) {
            iter.next().afterSaving(evt);
        }
    }

    public class UnsavedProject
    extends UnsavedData {
        public UnsavedProject(IExtension extension) {
            super(extension);
        }

        public String getDescription() {
            if (ProjectExtension.getPath() == null) {
                return PluginServices.getText((Object)((Object)ProjectExtension.this), (String)"Unnamed_new_gvsig_project_");
            }
            return PluginServices.getText((Object)((Object)ProjectExtension.this), (String)"Modified_project_");
        }

        public String getResourceName() {
            if (ProjectExtension.getPath() == null) {
                return PluginServices.getText((Object)((Object)ProjectExtension.this), (String)"_Project_not_saved");
            }
            return ProjectExtension.getPath();
        }

        public boolean saveData() {
            return ProjectExtension.this.saveProject();
        }

        public String getIcon() {
            return "project-icon";
        }
    }

    private class OpenInitialProjectTask
    implements Runnable {
        private final File projectFile;

        public OpenInitialProjectTask(File projectFile) {
            this.projectFile = projectFile;
        }

        @Override
        public void run() {
            if (this.projectFile == null) {
                return;
            }
            ActionInfoManager actionManager = PluginsLocator.getActionInfoManager();
            ActionInfo action = actionManager.getAction("application-project-open");
            action.execute((Object)this.projectFile);
        }
    }
}

