/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.swing.JExpressionBuilder;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectByAttributes {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectByAttributes.class);

    public void showWindow(String title, final FeatureStore store, WindowManager.MODE mode) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager windowManager = ToolsSwingLocator.getWindowManager();
        DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
        final JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        final JExpressionBuilder builder = dataSwingManager.createQueryFilterExpresion(store);
        panel.add((Component)builder.asJComponent(), "Center");
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(2, 4, 4));
        buttons.add(new JButton(new AbstractAction(i18n.getTranslation("_New_selection")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectByAttributes.this.setSelection(store, builder.getExpression());
            }
        }));
        buttons.add(new JButton(new AbstractAction(i18n.getTranslation("_Add_to_selection")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectByAttributes.this.addToSelection(store, builder.getExpression());
            }
        }));
        buttons.add(new JButton(new AbstractAction(i18n.getTranslation("_Filter_selection")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectByAttributes.this.filterSelection(store, builder.getExpression());
            }
        }));
        buttons.add(new JButton(new AbstractAction(i18n.getTranslation("_Close")){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.setVisible(false);
            }
        }));
        panel.add((Component)buttons, "South");
        windowManager.showWindow((JComponent)panel, title, mode);
    }

    public void setSelection(FeatureStore store, Expression expression) {
        try {
            DataManager manager = DALLocator.getDataManager();
            FeatureSelection currentSelection = store.getFeatureSelection();
            FeatureQuery query = store.createFeatureQuery();
            query.setFilter(manager.createExpresion(expression));
            FeatureSet selection = store.getFeatureSet(query);
            currentSelection.deselectAll();
            currentSelection.select(selection);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't build selecction from filter expression.", (Throwable)ex);
        }
    }

    public void addToSelection(FeatureStore store, Expression expression) {
        try {
            DataManager manager = DALLocator.getDataManager();
            FeatureSelection currentSelection = store.getFeatureSelection();
            FeatureQuery query = store.createFeatureQuery();
            query.setFilter(manager.createExpresion(expression));
            FeatureSet selection = store.getFeatureSet(query);
            currentSelection.select(selection);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't build selecction from filter expression.", (Throwable)ex);
        }
    }

    public void filterSelection(FeatureStore store, Expression expression) {
        try {
            DataManager manager = DALLocator.getDataManager();
            FeatureSelection currentSelection = store.getFeatureSelection();
            FeatureQuery query = store.createFeatureQuery();
            query.setFilter(manager.createExpresion(expression));
            FeatureSet set = store.getFeatureSet(query);
            FeatureSelection newSelection = store.createFeatureSelection();
            for (Feature feature : set) {
                if (!currentSelection.isSelected(feature)) continue;
                newSelection.select(feature);
            }
            store.setSelection((FeatureSet)newSelection);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't build selecction from filter expression.", (Throwable)ex);
        }
    }
}

