/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.cresques.cts.IProjection;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.featureform.swing.CreateJFeatureFormException;
import org.gvsig.featureform.swing.JFeaturesForm;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.Circle;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.layers.vectorial.SpatialEvaluatorsFactory;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.PointBehavior;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.ServiceException;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.icontheme.IconTheme;

public class ShowLayerAsForm
extends Extension {
    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"layer-show-form", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layer-selectforediting", (Object)((Object)this));
    }

    public void execute(String actionCommand) {
        ApplicationManager application = ApplicationLocator.getManager();
        if ("layer-show-form".equalsIgnoreCase(actionCommand)) {
            ViewDocument doc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
            if (doc == null) {
                return;
            }
            FLayer[] layers = doc.getMapContext().getLayers().getActives();
            for (int i = 0; i < layers.length; ++i) {
                FLayer layer = layers[i];
                if (!layer.isAvailable() || !(layer instanceof FLyrVect)) continue;
                try {
                    FLyrVect vectLayer = (FLyrVect)layer;
                    FeatureStore featureStore = vectLayer.getFeatureStore();
                    FeatureType type = featureStore.getDefaultFeatureType();
                    if (!type.supportReferences()) continue;
                    JFeaturesForm form = this.createform(featureStore);
                    form.addAction((Action)new SelectFeatureInTheViewAction(doc, form, layer));
                    form.showForm(WindowManager.MODE.WINDOW);
                    continue;
                }
                catch (Exception ex) {
                    String msg = "Can't show form for layer '" + layer.getName() + "'.";
                    logger.warn(msg, (Throwable)ex);
                    application.messageDialog(msg + "\n\n(See the error log for more information)", "Warning", 2);
                }
            }
        }
    }

    private JFeaturesForm createform(FeatureStore featureStore) throws CreateJFeatureFormException, ServiceException, DataException {
        DataSwingManager swingManager = DALSwingLocator.getSwingManager();
        JFeaturesForm form = swingManager.createJFeaturesForm(featureStore);
        form.setTerminateEditingOnClose(false);
        return form;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument doc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (doc == null) {
            return false;
        }
        return doc.getMapContext().hasActiveVectorLayers();
    }

    private static class SelectFeatureInTheViewAction
    extends AbstractAction
    implements PointListener {
        private final JFeaturesForm form;
        private final ViewDocument doc;
        private MapControl mapControl = null;
        private String previousTool = null;
        private final FLyrVect layer;

        public SelectFeatureInTheViewAction(ViewDocument doc, JFeaturesForm form, FLayer layer) {
            I18nManager i18nManager = ToolsLocator.getI18nManager();
            IconTheme iconTheme = ToolsSwingLocator.getIconThemeManager().getDefault();
            this.doc = doc;
            this.form = form;
            this.putValue("Name", null);
            this.putValue("ShortDescription", i18nManager.getTranslation("_Select_feature_in_the_View"));
            this.putValue("SmallIcon", iconTheme.get("layer-selectforediting"));
            this.putValue("ActionCommandKey", "selectInTheView");
            if (layer instanceof FLyrVect) {
                this.layer = (FLyrVect)layer;
                this.setEnabled(true);
            } else {
                this.layer = null;
                this.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ApplicationManager application = ApplicationLocator.getManager();
            if (this.layer == null) {
                return;
            }
            if (this.mapControl == null) {
                IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
                if (view != null) {
                    MapControl theMapControl = view.getMapControl();
                    this.previousTool = theMapControl.getCurrentTool();
                    theMapControl.addBehavior("layer-selectforediting", (Behavior)new PointBehavior((PointListener)this));
                    theMapControl.setTool("layer-selectforediting");
                    this.mapControl = theMapControl;
                    theMapControl.requestFocus();
                }
            } else {
                this.mapControl.setTool(this.previousTool);
                this.mapControl = null;
                this.previousTool = null;
            }
        }

        public void point(PointEvent event) throws BehaviorException {
            ApplicationManager application = ApplicationLocator.getManager();
            try {
                Point point = event.getMapPoint();
                double tolerance = this.mapControl.getViewPort().toMapDistance(7);
                GeometryManager manager = GeometryLocator.getGeometryManager();
                Circle circle = (Circle)manager.create(11, 0);
                circle.setPoints(point, tolerance);
                FeatureStore featureStore = this.form.getFeatureStore();
                FeatureType featureType = featureStore.getDefaultFeatureType();
                FeatureQuery featureQuery = featureStore.createFeatureQuery();
                featureQuery.setFeatureType(featureType);
                Geometry query_geo = this.layer.transformToSourceCRS((Geometry)circle, true);
                IProjection query_proj = this.mapControl.getMapContext().getProjection();
                if (this.layer.getCoordTrans() != null) {
                    query_proj = this.layer.getCoordTrans().getPOrig();
                }
                Evaluator iee = SpatialEvaluatorsFactory.getInstance().intersects(query_geo, query_proj, featureStore);
                featureQuery.setFilter(iee);
                featureQuery.setAttributeNames(null);
                this.form.setQuery(featureQuery);
                this.mapControl.setTool(this.previousTool);
                this.mapControl = null;
                this.previousTool = null;
            }
            catch (Exception e) {
                application.message("Can't filter form.", 2);
                throw new RuntimeException("Can't create filter", e);
            }
        }

        public void pointDoubleClick(PointEvent event) throws BehaviorException {
            this.point(event);
        }

        public Image getImageCursor() {
            return IconThemeHelper.getImage((String)"cursor-info-by-point");
        }

        public boolean cancelDrawing() {
            return false;
        }
    }
}

