/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.util.List;
import javax.swing.JComponent;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.gui.selectionByTheme.DefaultSelectionByThemeModel;
import org.gvsig.app.gui.selectionByTheme.MySelectionByThemeListener;
import org.gvsig.app.gui.selectionByTheme.SelectionByTheme;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewSelectionByTheme
extends Extension {
    private static final Logger logger = LoggerFactory.getLogger(ViewSelectionByTheme.class);

    public void initialize() {
        this.registerIcons();
    }

    private void registerIcons() {
        IconThemeHelper.registerIcon((String)"action", (String)"selection-select-by-layer", (Object)((Object)this));
    }

    public void execute(String actionCommand) {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return;
        }
        ViewDocument document = view.getViewDocument();
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (actionCommand.equalsIgnoreCase("selection-select-by-layer")) {
            SelectionByTheme dlg = new SelectionByTheme();
            dlg.setModel(new DefaultSelectionByThemeModel());
            dlg.addSelectionListener(new MySelectionByThemeListener(dlg.getTaskStatus()));
            ToolsSwingLocator.getWindowManager().showWindow((JComponent)dlg, i18n.getTranslation("Seleccion_por_capa"), WindowManager.MODE.TOOL);
            document.setModified(true);
        }
    }

    public boolean isEnabled() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return false;
        }
        ViewDocument document = view.getViewDocument();
        if (document == null) {
            return false;
        }
        List layers = document.getMapContext().getLayers().getLayers(FLayers.LAYER_ACTIVE.and(FLayers.LAYER_AVALAIBLE).and(FLayers.LAYER_SELECTION_AVAILABLE));
        return layers.size() >= 1;
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)((Object)application.getActiveComponent(ViewDocument.class));
        if (view == null) {
            return false;
        }
        ViewDocument document = view.getViewDocument();
        return document.getMapContext().hasVectorLayers();
    }
}

