/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.clipboard;

import javax.json.JsonArray;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyFeaturesToClipboardExtension
extends Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger(CopyFeaturesToClipboardExtension.class);

    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"layer-modify-clipboard-copy", (Object)((Object)this));
    }

    public void execute(String actionCommand) {
        if (actionCommand.compareToIgnoreCase("layer-modify-clipboard-copy") != 0) {
            return;
        }
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument viewdoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (viewdoc == null) {
            return;
        }
        MapContext mapContext = viewdoc.getMapContext();
        FLyrVect layer = mapContext.getLayers().getFirstActiveVectorLayer();
        if (layer == null) {
            return;
        }
        try {
            FeatureSelection selection = layer.getFeatureStore().getFeatureSelection();
            JsonArray json = selection.toJSON();
            application.putInClipboard(json.toString());
            I18nManager i18n = ToolsLocator.getI18nManager();
            application.messageDialog(i18n.getTranslation("_Number_of_features_copied_to_clipboard") + ":   " + selection.getSize(), null, i18n.getTranslation("_Copy_selected_features_to_clipboard"), 1, "CopyFeaturesToClipboard");
        }
        catch (Exception e) {
            LOGGER.warn("Can't get the selection as JSON.", (Throwable)e);
        }
    }

    public boolean isEnabled() {
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument viewdoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (viewdoc == null) {
            return false;
        }
        MapContext mapContext = viewdoc.getMapContext();
        FLyrVect layer = mapContext.getLayers().getFirstActiveVectorLayer();
        if (layer == null) {
            return false;
        }
        if (!layer.isAvailable() || !layer.isVisible()) {
            return false;
        }
        try {
            FeatureStore store = layer.getFeatureStore();
            if (store == null) {
                return false;
            }
            return !store.isFeatureSelectionEmpty();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't get selection from layer '" + layer.getName() + "'.", (Throwable)ex);
            return false;
        }
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        return application.getActiveDocument(ViewManager.TYPENAME) != null;
    }
}

