/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.clipboard;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.logger.FilteredLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasteFeaturesFromClipboardExtension
extends Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger(PasteFeaturesFromClipboardExtension.class);

    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"layer-modify-clipboard-paste", (Object)((Object)this));
    }

    public void execute(String actionCommand) {
        int n;
        JsonArray jsonArray;
        if (actionCommand.compareToIgnoreCase("layer-modify-clipboard-paste") != 0) {
            return;
        }
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument viewdoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (viewdoc == null) {
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        String clipboardValue = application.getFromClipboard();
        if (StringUtils.isBlank((CharSequence)clipboardValue)) {
            application.messageDialog(i18n.getTranslation("_Clipboard_has_no_valid_info_or_is_empty"), null, i18n.getTranslation("_Pasting_features_from_clipboard"), 1, "ClipboardEmptyWhenPasteFeatures");
            return;
        }
        try {
            JsonReader jsonReader = Json.createReader((Reader)new StringReader(clipboardValue));
            jsonArray = jsonReader.readArray();
            jsonReader.close();
        }
        catch (Exception ex) {
            LOGGER.warn("Can't get JSON from the clipboard.", (Throwable)ex);
            application.messageDialog(i18n.getTranslation("_Clipboard_has_no_valid_info_or_is_empty"), null, i18n.getTranslation("_Pasting_features_from_clipboard"), 2, "ClipboardNotValidWhenPasteFeatures");
            return;
        }
        if (jsonArray.size() < 1) {
            application.messageDialog(i18n.getTranslation("_No_features_found_in_clipboard"), null, i18n.getTranslation("_Pasting_features_from_clipboard"), 2, "ClipboardNotHasElementsWhenPasteFeatures");
            return;
        }
        MapContext mapContext = viewdoc.getMapContext();
        List layers = mapContext.getLayers().getLayers((Predicate)new Predicate<FLayer>(){

            @Override
            public boolean test(FLayer layer) {
                return layer instanceof FLyrVect && layer.isActive() && layer.isAvailable() && layer.isEditing();
            }
        });
        if (layers.isEmpty()) {
            return;
        }
        FLyrVect layer = (FLyrVect)layers.get(0);
        FeatureStore store = layer.getFeatureStore();
        FeatureType ft = store.getDefaultFeatureTypeQuietly();
        boolean hasPk = false;
        if (!jsonArray.isEmpty()) {
            JsonObject fjson0 = (JsonObject)jsonArray.get(0);
            for (String name : fjson0.keySet()) {
                Iterator attr = ft.getAttributeDescriptor(name);
                if (attr == null || !attr.isPrimaryKey()) continue;
                hasPk = true;
                break;
            }
        }
        final boolean copyPk = hasPk ? (n = application.confirmDialog(i18n.getTranslation("_Copy_primary_key_values_XQuestionX"), i18n.getTranslation("_Pasting_features_from_clipboard"), 0, 3, "_CopyPrimaryKeyWhenPasteFeaturesFromClipboard")) == 0 : false;
        ArrayList<EditableFeature> features = new ArrayList<EditableFeature>();
        FilteredLogger theLogger = new FilteredLogger(LOGGER, "PasteFeatures", 10);
        for (Object obj : jsonArray) {
            if (!(obj instanceof JsonObject)) continue;
            JsonObject fjson = (JsonObject)obj;
            try {
                EditableFeature f = store.createNewFeature(false);
                f.copyFrom(fjson, (Predicate)new Predicate<FeatureAttributeDescriptor>(){

                    @Override
                    public boolean test(FeatureAttributeDescriptor attr) {
                        return copyPk || !attr.isPrimaryKey();
                    }
                });
                features.add(f);
            }
            catch (Exception ex) {
                theLogger.warn("Can't create feature from JSON.", (Throwable)ex);
            }
        }
        if (features.isEmpty()) {
            application.messageDialog(i18n.getTranslation("_No_features_found_in_clipboard"), null, i18n.getTranslation("_Pasting_features_from_clipboard"), 2, "ClipboardNotHasFeaturesWhenPasteFeatures");
            return;
        }
        int inserteds = 0;
        theLogger = new FilteredLogger(LOGGER, "PasteFeatures", 10);
        Envelope envelope = GeometryUtils.createEnvelope((int)0);
        for (EditableFeature feature : features) {
            try {
                store.insert(feature);
                ++inserteds;
                try {
                    envelope.add(feature.getDefaultGeometry());
                }
                catch (Exception ex) {
                    theLogger.warn("Can't calculate envelope.", (Throwable)ex);
                }
            }
            catch (Exception ex) {
                theLogger.warn("Can't insert feature.", (Throwable)ex);
            }
        }
        StringBuilder msg = new StringBuilder();
        msg.append(i18n.getTranslation("_Number_of_features_pasted_from_clipboard"));
        msg.append(":   ");
        msg.append(inserteds);
        msg.append("\n");
        msg.append(i18n.getTranslation("_Number_of_features_from_clipboard_discarded_due_to_bad_format"));
        msg.append(":   ");
        msg.append(jsonArray.size() - inserteds);
        if (inserteds < 1 || envelope.isEmpty()) {
            application.messageDialog(msg.toString(), null, i18n.getTranslation("_Pasting_features_from_clipboard"), 2, "ClipboardNotInsertFeaturesWhenPasteFeatures");
            return;
        }
        msg.append("\n\n");
        msg.append(i18n.getTranslation("_Zoom_to_added_features_question"));
        int r = application.confirmDialog(msg.toString(), i18n.getTranslation("_Pasting_features_from_clipboard"), 0, 3, "ZoomToInsertedFeaturesWhenPasteFeatures");
        if (r == 1) {
            return;
        }
        try {
            viewdoc.getMapContext().getViewPort().setEnvelope(envelope);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't zoom to envelope.", (Throwable)ex);
        }
    }

    public boolean isEnabled() {
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument viewdoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (viewdoc == null) {
            return false;
        }
        String clipboardValue = application.getFromClipboard();
        if (StringUtils.isBlank((CharSequence)clipboardValue)) {
            return false;
        }
        MapContext mapContext = viewdoc.getMapContext();
        final MutableInt numActiveVectorial = new MutableInt(0);
        final MutableInt numActiveVectorialEditable = new MutableInt(0);
        List layers = mapContext.getLayers().getLayers((Predicate)new Predicate<FLayer>(){

            @Override
            public boolean test(FLayer layer) {
                if (layer instanceof FLyrVect && layer.isActive() && layer.isAvailable()) {
                    numActiveVectorial.increment();
                    if (layer.isEditing()) {
                        numActiveVectorialEditable.increment();
                    }
                }
                return false;
            }
        });
        return numActiveVectorialEditable.intValue() == 1 && numActiveVectorial.intValue() == 1;
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        return application.getActiveDocument(ViewManager.TYPENAME) != null;
    }
}

