/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.develtools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkListener;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.actioninfo.ActionInfo;
import org.gvsig.andami.actioninfo.ActionInfoManager;
import org.gvsig.app.extension.develtools.IconThemeDevelTool;
import org.gvsig.desktopopen.DesktopOpen;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoPanel
extends JPanel {
    private static Logger logger = LoggerFactory.getLogger(InfoPanel.class);
    private static final long serialVersionUID = 7164653790859770568L;
    private JButton accept = null;
    private JButton copy = null;
    private JTextPane text = null;

    public static void showPanel(String title, WindowManager.MODE mode, String html) {
        InfoPanel panel = new InfoPanel(html, null);
        WindowManager wm = ToolsSwingLocator.getWindowManager();
        wm.showWindow((JComponent)panel, title, mode);
    }

    public static void showPanel(String title, WindowManager.MODE mode, String html, HyperlinkListener hyperlinkListener) {
        InfoPanel panel = new InfoPanel(html, hyperlinkListener);
        WindowManager wm = ToolsSwingLocator.getWindowManager();
        wm.showWindow((JComponent)panel, title, mode);
    }

    public static void save2file(String name, String contents) {
        try {
            File file = File.createTempFile("gvsig-" + name + "-", ".html");
            FileWriter fwriter = new FileWriter(file);
            fwriter.append(contents);
            fwriter.close();
        }
        catch (IOException e) {
            logger.warn("Can't save contents to temp file gvsig-" + name, (Throwable)e);
        }
    }

    public InfoPanel(String html, HyperlinkListener hyperlinkListener) {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(500, 300));
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.text = new JTextPane();
        this.text.setContentType("text/html");
        this.text.setEditable(false);
        this.text.setText(html);
        this.text.setCaretPosition(0);
        if (hyperlinkListener != null) {
            this.text.addHyperlinkListener(hyperlinkListener);
        }
        JScrollPane scrollPane = new JScrollPane(this.text);
        scrollPane.setPreferredSize(new Dimension(500, 220));
        this.accept = new JButton("Accept");
        this.accept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                InfoPanel.this.setVisible(false);
            }
        });
        this.copy = new JButton("Copy to clipboard");
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ToolsSwingLocator.getToolsSwingManager().putInClipboard(InfoPanel.this.text.getText(), "html");
            }
        });
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 2));
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(this.copy);
        buttonsPanel.add(this.accept);
        this.add((Component)scrollPane, "Center");
        this.add((Component)buttonsPanel, "South");
        this.setVisible(true);
    }

    public static void showInBrowser(String name, String title, String html) {
        try {
            FoldersManager fm = ToolsLocator.getFoldersManager();
            File f = fm.createTemporaryFile(name + ".html", html);
            DesktopOpen desktopOpen = ToolsUtilLocator.getToolsUtilManager().createDesktopOpen();
            desktopOpen.browse(f.toURI());
        }
        catch (Exception ex) {
            IconThemeDevelTool.LOGGER.warn("Can't show in desktop browser", (Throwable)ex);
            InfoPanel.showInInternalViewer(name, title, html);
        }
    }

    public static void showInInternalViewer(String name, String title, String html) {
        InfoPanel.save2file(name, html);
        InfoPanel.showPanel(title, WindowManager.MODE.WINDOW, html);
    }

    public static void showInPDFViewer(String name, String title, String html) {
        ActionInfoManager actionManager = PluginsLocator.getActionInfoManager();
        ActionInfo showPdf = actionManager.getAction("show-pdf");
        if (showPdf == null) {
            InfoPanel.showInInternalViewer(name, title, html);
        } else {
            showPdf.execute(new Object[]{"--title=", title, "--mode=", WindowManager.MODE.WINDOW, "--source=", html});
        }
    }
}

