/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.develtools;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.gvsig.app.extension.develtools.InfoPanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceFactory;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceDevelTool {
    private static Logger logger = LoggerFactory.getLogger(PersistenceDevelTool.class);

    public void showPersistenceFactories() {
        String html = this.getPersistenceFactories();
        InfoPanel.save2file("persistenceinfo", html);
        InfoPanel.showPanel("Persistence factories", WindowManager.MODE.WINDOW, html);
    }

    public String getPersistenceFactories() {
        int warningsCounter = 0;
        ArrayList<PersistenceInfo> classes = new ArrayList<PersistenceInfo>();
        TreeSet<Class> referencedClasses = new TreeSet<Class>(new ClassComparator());
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        PersistenceManager.Factories factories = manager.getFactories();
        for (PersistenceFactory factory : factories) {
            List theClasses = factory.getManagedClasses();
            for (Class theClass : theClasses) {
                DynStruct definition = manager.getDefinition(theClass);
                List defs = factory.getDefinitions();
                if (definition == null && defs != null && !defs.isEmpty()) {
                    for (int i = 0; i < defs.size(); ++i) {
                        definition = (DynStruct)defs.get(i);
                        classes.add(new PersistenceInfo(factory, theClass, definition));
                    }
                    continue;
                }
                classes.add(new PersistenceInfo(factory, theClass, definition));
            }
        }
        Collections.sort(classes);
        StringBuffer buffer = new StringBuffer();
        StringBuffer warnings = new StringBuffer();
        buffer.append("<html>\n");
        buffer.append("<body>\n");
        buffer.append("<h2>Supported persistent classes</h2>\n");
        buffer.append("<br>\n");
        buffer.append("<ol>\n");
        for (PersistenceInfo classInfo : classes) {
            StringBuffer classBuffer = new StringBuffer();
            boolean warning = false;
            classBuffer.append("  <li>\n    ");
            classBuffer.append("Class: <i>");
            classBuffer.append(classInfo.getClassName());
            classBuffer.append("</i><br>\n    Persistent: <i>");
            if (Persistent.class.isAssignableFrom(classInfo.theClass)) {
                classBuffer.append(" yes.");
                if (!classInfo.hasSaveToState()) {
                    classBuffer.append("<br>\n    <b>This class doesn't implement saveToState</b>");
                    ++warningsCounter;
                    warning = true;
                }
                if (!classInfo.hasLoadFromState()) {
                    classBuffer.append("<br>\n    <b>This class doesn't implement loadFromState</b>");
                    ++warningsCounter;
                    warning = true;
                }
            } else {
                classBuffer.append(" through a factory.");
            }
            classBuffer.append("<br>\n    Factory: <i>");
            classBuffer.append(classInfo.getFactoryName()).append("</i><br>\n    Definition name: <i>");
            classBuffer.append(classInfo.getDefinitionName()).append("</i><br>\n    Description: \n");
            classBuffer.append(classInfo.getDefinitionDescription()).append("<br>\n    ");
            DataTypesManager dataTypesManager = ToolsLocator.getDataTypesManager();
            DynStruct definition = classInfo.definition;
            if (definition == null) {
                classBuffer.append("Definition for ").append(classInfo.getClassName()).append(" is null.<br>\n    ");
                ++warningsCounter;
                warning = true;
            } else {
                DynField[] fields = definition.getDynFields();
                for (int i = 0; i < fields.length; ++i) {
                    DynField field = fields[i];
                    if (dataTypesManager.isContainer(field.getType())) {
                        if (field.getClassOfItems() == null) {
                            classBuffer.append("Field <b>").append(field.getName()).append("</b> as container (").append(field.getDataType().getName()).append("),  can't has class for value of items.<br>\n    ");
                            ++warningsCounter;
                            warning = true;
                            continue;
                        }
                        classBuffer.append("Field ").append(field.getName()).append(" as container (").append(field.getDataType().getName()).append(") of '").append(field.getClassOfItems().getName()).append("'.<br>\n    ");
                        referencedClasses.add(field.getClassOfItems());
                        continue;
                    }
                    if (dataTypesManager.isObject(field.getType())) {
                        if (field.getClassOfValue() == null) {
                            classBuffer.append("Field <b>").append(field.getName()).append(" as object </b> can't has class of value.<br>\n    ");
                            ++warningsCounter;
                            warning = true;
                            continue;
                        }
                        classBuffer.append("Field ").append(field.getName()).append(" as object '").append(field.getClassOfValue()).append("'.<br>\n    ");
                        referencedClasses.add(field.getClassOfValue());
                        continue;
                    }
                    classBuffer.append("Field ").append(field.getName()).append(" as '").append(field.getDataType().getName()).append("'.<br>\n    ");
                }
            }
            classBuffer.append("<br>\n  </li>\n");
            buffer.append(classBuffer);
            if (!warning) continue;
            warnings.append(classBuffer);
        }
        buffer.append("</ol>\n");
        buffer.append("<br>\n");
        buffer.append("<br>\n");
        buffer.append("<h2>Persistent classes with problems</h2>\n");
        buffer.append("<ol>\n");
        buffer.append(warnings);
        buffer.append("</ol>\n");
        buffer.append("<br>\n<p>Total warnigs: ").append(warningsCounter).append("</p>");
        buffer.append("<h2>Not persistents used classes</h2>\n");
        buffer.append("<ol>\n");
        for (Class theClass : referencedClasses) {
            if (manager.getFactories().get(theClass) != null) continue;
            if (Persistent.class.isAssignableFrom(theClass)) {
                buffer.append("  <li>\n");
                buffer.append("    <i>").append(theClass.getName()).append("</i> Persistent without factory<br>\n");
                buffer.append("  </li>\n");
            } else {
                buffer.append("  <li>\n");
                buffer.append("    <i>").append(theClass.getName()).append("</i><br>\n");
                buffer.append("  </li>\n");
            }
            ++warningsCounter;
        }
        buffer.append("</ol>\n");
        buffer.append("</body>\n");
        buffer.append("</html>\n");
        return buffer.toString();
    }

    public class ClassComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 == null || o2 == null || ((Class)o1).getName() == null) {
                logger.warn("Esto no deberia estar pasando.");
                return 0;
            }
            return ((Class)o1).getName().compareTo(((Class)o2).getName());
        }
    }

    public class PersistenceInfo
    implements Comparable<PersistenceInfo> {
        PersistenceFactory factory;
        Class theClass;
        DynStruct definition;

        PersistenceInfo(PersistenceFactory factory, Class theClass, DynStruct definition) {
            this.factory = factory;
            this.theClass = theClass;
            this.definition = definition;
        }

        boolean hasSaveToState() {
            try {
                Method method = this.theClass.getMethod("saveToState", PersistentState.class);
                if (method == null) {
                    return false;
                }
            }
            catch (NoSuchMethodException | SecurityException ex) {
                return false;
            }
            return true;
        }

        boolean hasLoadFromState() {
            try {
                Method method = this.theClass.getMethod("loadFromState", PersistentState.class);
                if (method == null) {
                    return false;
                }
            }
            catch (NoSuchMethodException | SecurityException ex) {
                return false;
            }
            return true;
        }

        String getDefinitionName() {
            if (this.definition == null) {
                return "";
            }
            return this.definition.getFullName();
        }

        String getDefinitionDescription() {
            if (this.definition == null) {
                return "";
            }
            return this.definition.getDescription();
        }

        String getClassName() {
            if (this.theClass == null) {
                return "";
            }
            return this.theClass.getName();
        }

        String getFactoryName() {
            if (this.factory == null) {
                return "";
            }
            return this.factory.getClass().getName();
        }

        @Override
        public int compareTo(PersistenceInfo other) {
            int r = this.factory.getClass().getName().compareTo(other.factory.getClass().getName());
            if (r == 0) {
                return this.theClass.getName().compareTo(other.theClass.getName());
            }
            return r;
        }
    }
}

