/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.selectioncount;

import javax.swing.JLabel;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.events.AtomicEvent;
import org.gvsig.fmap.mapcontext.events.listeners.AtomicEventListener;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.LayerCollectionEvent;
import org.gvsig.fmap.mapcontext.layers.LayerEvent;
import org.gvsig.fmap.mapcontext.layers.LayerListener;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.MapControlCreationListener;
import org.gvsig.fmap.mapcontrol.MapControlLocator;
import org.gvsig.fmap.mapcontrol.MapControlManager;
import org.gvsig.gui.beans.controls.IControl;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectionCount
implements LayerListener,
Observer {
    private static Logger logger = LoggerFactory.getLogger(SelectionCount.class);
    private IControl control;

    public SelectionCount(IControl control) {
        this.control = control;
        MapControlManager mapControlManager = MapControlLocator.getMapControlManager();
        mapControlManager.addMapControlCreationListener(new MapControlCreationListener(){

            public MapControl mapControlCreated(MapControl mapControl) {
                final MapContext mapContext = mapControl.getMapContext();
                mapContext.addAtomicEventListener(new AtomicEventListener(){

                    public void atomicEvent(AtomicEvent e) {
                        SelectionCount.this.doAtomicEvent(mapContext, e);
                    }
                });
                return mapControl;
            }
        });
    }

    public void doAtomicEvent(MapContext mapContext, AtomicEvent e) {
        LayerCollectionEvent[] events = e.getLayerCollectionEvents();
        for (int i = 0; i < events.length; ++i) {
            FLayer fLayer;
            if (events[i].getEventType() == 0) {
                fLayer = events[i].getAffectedLayer();
                fLayer.addLayerListener((LayerListener)this);
            }
            if (events[i].getEventType() != 2) continue;
            fLayer = events[i].getAffectedLayer();
            fLayer.removeLayerListener((LayerListener)this);
            this.showFeatureCount();
        }
    }

    public void visibilityChanged(LayerEvent e) {
    }

    public void activationChanged(LayerEvent e) {
        FLayer fLayer;
        if (e.getEventType() == 1 && (fLayer = e.getSource()).isAvailable()) {
            this.showFeatureCount();
            if (fLayer.isActive()) {
                if (fLayer instanceof FLyrVect) {
                    FLyrVect lyrVect = (FLyrVect)fLayer;
                    lyrVect.getFeatureStore().addObserver((Observer)this);
                }
            } else if (fLayer instanceof FLyrVect) {
                FLyrVect lyrVect = (FLyrVect)fLayer;
                lyrVect.getFeatureStore().deleteObserver((Observer)this);
            }
        }
    }

    public void nameChanged(LayerEvent e) {
    }

    public void editionChanged(LayerEvent e) {
    }

    public void drawValueChanged(LayerEvent e) {
    }

    public void update(Observable observable, Object notification) {
        FeatureStoreNotification event;
        if (notification instanceof FeatureStoreNotification && ((event = (FeatureStoreNotification)notification).getType() == "after_Delete_Feature" || event.getType() == "after_Insert_Feature" || event.getType() == "after_FinishEditing_DataStore" || event.getType() == "after_SelectionChange_DataStore") && event.getSource() instanceof FeatureStore) {
            this.showFeatureCount();
        }
    }

    public void showFeatureCount() {
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument viewDoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (viewDoc == null) {
            return;
        }
        MapContext mapContext = viewDoc.getMapContext();
        Long totalFeaturesCount = 0L;
        Long selectedFeaturesCount = 0L;
        if (mapContext != null) {
            FLayer[] actives = mapContext.getLayers().getActives();
            if (actives != null && actives.length > 0) {
                for (FLayer fLayer : actives) {
                    FLyrVect lyrVect;
                    FeatureStore featureStore;
                    if (!(fLayer instanceof FLyrVect) || (featureStore = (lyrVect = (FLyrVect)fLayer).getFeatureStore()) == null) continue;
                    try {
                        totalFeaturesCount = totalFeaturesCount + featureStore.getFeatureCount();
                    }
                    catch (DataException e) {
                        logger.warn("Problem obtaining total features count");
                        totalFeaturesCount = 0L;
                    }
                    try {
                        FeatureSelection featureSelection = featureStore.getFeatureSelection();
                        if (featureSelection == null) continue;
                        selectedFeaturesCount = selectedFeaturesCount + featureSelection.getSize();
                    }
                    catch (DataException e) {
                        logger.warn("Problem obtaining selected features count");
                        selectedFeaturesCount = 0L;
                    }
                }
                this.messageToStatusBar(totalFeaturesCount, selectedFeaturesCount);
            } else {
                this.clean();
            }
        } else {
            this.clean();
        }
    }

    public void clean() {
        if (this.control != null && this.control instanceof JLabel) {
            JLabel jlabel = (JLabel)this.control;
            jlabel.setText("");
        }
    }

    private void messageToStatusBar(Long totalFeaturesCount, Long selectedFeaturesCount) {
        String strTotal = totalFeaturesCount != null ? totalFeaturesCount.toString() : "N/A";
        String strSelected = selectedFeaturesCount != null ? selectedFeaturesCount.toString() : "N/A";
        if (this.control != null && this.control instanceof JLabel) {
            JLabel jlabel = (JLabel)this.control;
            jlabel.setText(strSelected + "/" + strTotal);
        }
    }
}

