/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.command;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.IWindowListener;
import org.gvsig.andami.ui.mdiManager.SingletonWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.gui.command.CommandTableModel;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.gui.beans.DefaultBean;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.undo.UndoRedoInfo;
import org.gvsig.tools.undo.UndoRedoStack;

public class CommandStackDialog
extends DefaultBean
implements SingletonWindow,
IWindowListener,
Observer {
    private JTable commandTable = null;
    private JPanel topPanel = null;
    private UndoRedoStack undoRedoStack;
    private JSlider commandSlider = null;
    private int lowLimit;
    private int currentValue = -1;
    private int currentSliderValue = -1;
    private JPanel sliderPanel = null;
    protected boolean refreshing;
    private JPanel centerPanel = null;
    private JScrollPane jScrollPane = null;
    private JPanel tablePanel = null;
    private static final ImageIcon imodify = IconThemeHelper.getImageIcon((String)"edit-undo-redo-actions-modify");
    private static final ImageIcon iadd = IconThemeHelper.getImageIcon((String)"edit-undo-redo-actions-add");
    private static final ImageIcon idel = IconThemeHelper.getImageIcon((String)"edit-undo-redo-actions-delete");
    private CommandTableModel commandTableModel = null;
    private String labelModel;

    public CommandStackDialog() {
        this.initialize();
    }

    public void setModel(UndoRedoStack cr1) {
        if (this.undoRedoStack != null) {
            if (this.undoRedoStack.equals(cr1)) {
                return;
            }
            this.undoRedoStack.deleteObserver((Observer)this);
        }
        this.undoRedoStack = cr1;
        this.undoRedoStack.addObserver((Observer)this);
        this.initTable();
        this.initSlider();
        this.currentValue = this.commandTableModel.getPos();
        this.refreshControls();
        this.refreshSliderSize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(328, 229);
        this.add(this.getJScrollPane(), "Center");
    }

    private JTable getTable() {
        if (this.commandTable == null) {
            this.commandTable = new JTable();
        }
        return this.commandTable;
    }

    private void initTable() {
        this.commandTableModel = new CommandTableModel(this.undoRedoStack);
        this.commandTable.setModel(this.commandTableModel);
        this.commandTable.setSelectionMode(0);
        this.commandTable.setSelectionBackground(Color.orange);
        this.commandTable.setSelectionForeground(Color.black);
        this.commandTable.setShowGrid(false);
        this.commandTable.getTableHeader().setBackground(Color.white);
        TableColumn tc = this.commandTable.getColumnModel().getColumn(0);
        tc.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                UndoRedoInfo info = (UndoRedoInfo)value;
                switch (info.getType()) {
                    case 1: {
                        label.setIcon(iadd);
                        break;
                    }
                    case 0: {
                        label.setIcon(idel);
                        break;
                    }
                    default: {
                        label.setIcon(imodify);
                    }
                }
                if (CommandStackDialog.this.commandTableModel.getPos() < row) {
                    label.setBackground(Color.lightGray);
                } else {
                    label.setBackground(Color.orange);
                }
                return label;
            }
        });
        this.commandTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int newpos = CommandStackDialog.this.commandTable.getSelectedRow();
                if (newpos >= 0) {
                    CommandStackDialog.this.commandTableModel.setPos(newpos);
                    ApplicationLocator.getManager().refreshMenusAndToolBars();
                }
            }
        });
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel();
        }
        return this.topPanel;
    }

    public WindowInfo getWindowInfo() {
        WindowInfo m_viewinfo = new WindowInfo(53);
        I18nManager i18n = ToolsLocator.getI18nManager();
        if (StringUtils.isBlank((CharSequence)this.labelModel)) {
            m_viewinfo.setTitle(i18n.getTranslation("pila_de_comandos"));
        } else {
            m_viewinfo.setTitle(i18n.getTranslation("pila_de_comandos") + " - " + this.labelModel);
        }
        return m_viewinfo;
    }

    public Object getWindowModel() {
        return this.undoRedoStack;
    }

    public void windowActivated() {
        this.validate();
    }

    public void windowClosed() {
    }

    public void commandRepaint() {
        this.setValue(this.commandTableModel.getPos(), true);
        this.refreshSliderSize();
    }

    private void refreshControls() {
        int normalizedValue = (int)((float)(this.commandTableModel.getRowCount() - (this.currentValue + 1)) / (float)this.commandTableModel.getRowCount() * 100.0f);
        if (this.commandTableModel.getRowCount() > 0) {
            normalizedValue += 100 / (this.commandTableModel.getRowCount() * 2);
        }
        this.refreshSlider(normalizedValue);
        this.commandTable.repaint();
    }

    private void refreshSlider(int normalizedValue) {
        if (!this.refreshing) {
            this.refreshing = true;
            this.getJSlider().setValue(normalizedValue);
            this.refreshing = false;
        }
    }

    private void refreshSliderSize() {
        if (!this.refreshing) {
            Dimension size = new Dimension(this.commandSlider.getPreferredSize().width, (this.commandTableModel.getRowCount() + 1) * this.getTable().getRowHeight());
            JScrollBar verticalScrollBar = this.getJScrollPane().getVerticalScrollBar();
            verticalScrollBar.setValue(this.commandTableModel.getPos() * this.getTable().getRowHeight());
            this.commandSlider.setPreferredSize(size);
            this.commandSlider.setSize(size);
            this.validate();
        }
    }

    private JSlider getJSlider() {
        if (this.commandSlider == null) {
            this.commandSlider = new JSlider(1, 0, 100, 0);
        }
        return this.commandSlider;
    }

    private void initSlider() {
        this.commandSlider.setPreferredSize(new Dimension(this.commandSlider.getPreferredSize().width, this.getTable().getRowCount() * this.getTable().getRowHeight()));
        this.commandSlider.addChangeListener(new ChangeListener(){

            @Override
            public synchronized void stateChanged(ChangeEvent e) {
                if (!CommandStackDialog.this.refreshing) {
                    int value = CommandStackDialog.this.getTablePosFromSlider();
                    if (CommandStackDialog.this.currentSliderValue != value) {
                        CommandStackDialog.this.refreshing = true;
                        CommandStackDialog.this.currentSliderValue = value;
                        CommandStackDialog.this.commandTableModel.setPos(value);
                        ApplicationLocator.getManager().refreshMenusAndToolBars();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ViewDocument view = (ViewDocument)ApplicationLocator.getManager().getActiveDocument(ViewManager.TYPENAME);
                                if (view != null) {
                                    view.getMapContext().invalidate();
                                }
                            }
                        });
                        CommandStackDialog.this.refreshing = false;
                    }
                }
            }
        });
        this.setValue(this.commandTableModel.getRowCount() - 1 - this.commandTableModel.getPos(), true);
    }

    private int getTablePosFromSlider() {
        if (this.commandTableModel.getRowCount() == 0) {
            return -1;
        }
        int value = this.getJSlider().getValue();
        value = (int)((double)value * 0.01 * (double)this.commandTableModel.getRowCount());
        value = this.commandTableModel.getRowCount() - 1 - value;
        if (value == -1) {
            return 0;
        }
        return value;
    }

    public void setValue(int number, boolean fireEvent) {
        int rowCount = this.commandTableModel.getRowCount();
        if (number < this.lowLimit) {
            number = this.lowLimit;
        }
        if (number > rowCount - 1) {
            number = rowCount;
        }
        if (number != this.currentValue) {
            this.currentValue = number;
            if (fireEvent) {
                this.callValueChanged(this.currentValue);
            }
        }
        this.refreshControls();
    }

    private JPanel getSliderPanel() {
        if (this.sliderPanel == null) {
            this.sliderPanel = new JPanel();
            this.sliderPanel.add(this.getJSlider());
        }
        return this.sliderPanel;
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(new BorderLayout());
            this.centerPanel.add((Component)this.getTablePanel(), "Center");
            this.centerPanel.add((Component)this.getSliderPanel(), "West");
        }
        return this.centerPanel;
    }

    private JPanel getTablePanel() {
        if (this.tablePanel == null) {
            this.tablePanel = new JPanel();
            this.tablePanel.setLayout(new BorderLayout());
            this.tablePanel.add((Component)this.getTable(), "Center");
            this.tablePanel.add((Component)this.getTopPanel(), "North");
        }
        return this.tablePanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getCenterPanel());
        }
        return this.jScrollPane;
    }

    public void update(Observable observable, Object notification) {
        if (notification instanceof FeatureStoreNotification) {
            FeatureStoreNotification featureStoreNotification = (FeatureStoreNotification)notification;
            String type = featureStoreNotification.getType();
            if ("after_FinishEditing_DataStore".equals(type) || "after_CancelEditing_DataStore".equals(type)) {
                ApplicationLocator.getManager().getUIManager().closeWindow((IWindow)this);
                featureStoreNotification.getSource().deleteObserver((Observer)this);
                return;
            }
            if ("after_Insert_Feature".equals(type) || "after_Delete_Feature".equals(type) || "after_Update_Feature".equals(type) || "after_SelectionChange_DataStore".equals(type) || "after_Redo_DataStore".equals(type) || "after_Undo_DataStore".equals(type)) {
                this.commandRepaint();
            }
        }
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }

    public void setLabelModel(String labelModel) {
        this.labelModel = labelModel;
    }
}

