/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.preferencespage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.preferences.AbstractPreferencePage;
import org.gvsig.andami.preferences.StoreException;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.gui.preferencespage.ViewPage;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.gui.beans.swing.JBlank;
import org.gvsig.utils.XMLEntity;

public class ViewBehaviorPage
extends AbstractPreferencePage {
    private static final int FACTORY_DEFAULT_MAPCONTEXT_FRAME_RATE = 3;
    protected String id = ViewBehaviorPage.class.getName();
    private ScreenRefreshRatePanel refreshRate;
    private static final String MAPCONTROL_ENABLE_ANIMATION_KEY_NAME = "MapControlEnableAnimation";
    private static final String MAPCONTROL_REFRESH_RATE_KEY_NAME = "MapControlRefreshRate";

    public ViewBehaviorPage() {
        this.setParentID(ViewPage.id);
        this.addComponent((Component)new JBlank(1, 1));
        this.refreshRate = new ScreenRefreshRatePanel();
        this.addComponent(this.refreshRate);
    }

    public void setChangesApplied() {
        this.setChanged(false);
    }

    public void storeValues() throws StoreException {
        boolean bAnimationEnabled;
        int frameRate = this.refreshRate.getFrameRate();
        boolean bl = bAnimationEnabled = frameRate > 0;
        if (frameRate > 0) {
            MapContext.setDrawFrameRate((int)frameRate);
        }
        MapControl.setDrawAnimationEnabled((boolean)bAnimationEnabled);
        IWindow[] windows = PluginServices.getMDIManager().getAllWindows();
        for (int i = 0; i < windows.length; ++i) {
            if (!(windows[i] instanceof AbstractViewPanel)) continue;
            AbstractViewPanel view = (AbstractViewPanel)windows[i];
            view.getMapControl().applyFrameRate();
        }
        PluginServices ps = PluginServices.getPluginServices((Object)((Object)this));
        XMLEntity xml = ps.getPersistentXML();
        xml.putProperty(MAPCONTROL_REFRESH_RATE_KEY_NAME, MapContext.getDrawFrameRate());
        xml.putProperty(MAPCONTROL_ENABLE_ANIMATION_KEY_NAME, MapControl.isDrawAnimationEnabled());
    }

    public String getID() {
        return this.id;
    }

    public ImageIcon getIcon() {
        return null;
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitle() {
        return PluginServices.getText((Object)((Object)this), (String)"behavior");
    }

    public void initializeDefaults() {
        this.refreshRate.setFrameRate(3);
    }

    public void initializeValues() {
        PluginServices ps = PluginServices.getPluginServices((Object)((Object)this));
        XMLEntity xml = ps.getPersistentXML();
        if (xml.contains(MAPCONTROL_REFRESH_RATE_KEY_NAME)) {
            MapContext.setDrawFrameRate((int)xml.getIntProperty(MAPCONTROL_REFRESH_RATE_KEY_NAME));
        }
        if (xml.contains(MAPCONTROL_ENABLE_ANIMATION_KEY_NAME)) {
            MapControl.setDrawAnimationEnabled((boolean)xml.getBooleanProperty(MAPCONTROL_ENABLE_ANIMATION_KEY_NAME));
        }
        int frameRate = MapContext.getDrawFrameRate();
        if (!MapControl.isDrawAnimationEnabled()) {
            frameRate = 0;
        }
        this.refreshRate.setFrameRate(frameRate);
    }

    public boolean isValueChanged() {
        return super.hasChanged();
    }

    public String getParentID() {
        if (super.getParentID() == null) {
            this.setParentID(ViewPage.id);
        }
        return super.getParentID();
    }

    private class ScreenRefreshRatePanel
    extends JPanel {
        private static final long serialVersionUID = -68376902499946576L;
        private JSlider sldRefreshRate;

        public ScreenRefreshRatePanel() {
            this.setPreferredSize(new Dimension(500, 200));
            TitledBorder border = BorderFactory.createTitledBorder(PluginServices.getText((Object)this, (String)"options.view.behavior.screen_refreshrate"));
            this.setBorder(border);
            this.setLayout(new BorderLayout(15, 15));
            JPanel aux = new JPanel(new BorderLayout());
            aux.add((Component)new JLabel(PluginServices.getText((Object)this, (String)"options.view.behavior.screen_refreshrate.none")), "West");
            JPanel aux2 = new JPanel(new FlowLayout(1));
            aux2.add((Component)new JLabel(PluginServices.getText((Object)this, (String)"options.view.behavior.screen_refreshrate.half")), "Center");
            aux.add(aux2);
            aux.add((Component)new JLabel(PluginServices.getText((Object)this, (String)"options.view.behavior.screen_refreshrate.full")), "East");
            this.add((Component)aux, "North");
            aux = new JPanel(new BorderLayout());
            aux.add((Component)this.getSldRefreshRate(), "North");
            aux.add((Component)new JBlank(10, 20), "South");
            this.add((Component)aux, "Center");
            this.add((Component)new JLabel(PluginServices.getText((Object)this, (String)"options.view.behavior.screen_refresh_rate.help")), "South");
        }

        private JSlider getSldRefreshRate() {
            if (this.sldRefreshRate == null) {
                this.sldRefreshRate = new JSlider(0, 30);
            }
            return this.sldRefreshRate;
        }

        public int getFrameRate() {
            return this.getSldRefreshRate().getValue();
        }

        public void setFrameRate(int sampleRate) {
            if (sampleRate <= 30) {
                this.getSldRefreshRate().setValue(sampleRate);
            }
        }
    }
}

