/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project;

import java.awt.geom.Rectangle2D;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectExtent
implements Persistent {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(ProjectExtent.class);
    public static final String PERSISTENCE_DEFINITION_NAME = "org.gvsig.app.project.ProjectExtent";
    private Envelope extent = null;
    private String description = null;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public Envelope getExtent() {
        if (this.extent == null) {
            try {
                this.extent = geomManager.createEnvelope(0);
            }
            catch (CreateEnvelopeException e) {
                logger.warn("Can't create envelop.", (Throwable)e);
            }
        }
        return this.extent;
    }

    public void setExtent(Envelope envelope) {
        this.extent = envelope;
    }

    public void setExtent(Rectangle2D rectangle2D) {
        try {
            this.extent = geomManager.createEnvelope(rectangle2D.getMinX(), rectangle2D.getMinY(), rectangle2D.getMaxX(), rectangle2D.getMaxY(), 0);
        }
        catch (CreateEnvelopeException e) {
            logger.warn("Can't create envelope.", (Throwable)e);
            throw new RuntimeException("Can't create envelope.", e);
        }
    }

    public String getEncuadre() {
        Point lower = this.extent.getLowerCorner();
        Point upper = this.extent.getUpperCorner();
        return lower.getX() + "," + lower.getY() + "," + upper.getX() + "," + upper.getY();
    }

    public void setEncuadre(String encuadre) {
        String[] coords = encuadre.split(",");
        try {
            this.extent = geomManager.createEnvelope(Double.parseDouble(coords[0]), Double.parseDouble(coords[1]), Double.parseDouble(coords[2]), Double.parseDouble(coords[3]), 0);
        }
        catch (NumberFormatException e) {
            logger.warn("Incorrect format string.", (Throwable)e);
            throw new RuntimeException("Incorrect format string.", e);
        }
        catch (CreateEnvelopeException e) {
            logger.warn("Can't create envelope.", (Throwable)e);
            throw new RuntimeException("Can't create envelope.", e);
        }
    }

    public String toString() {
        return this.description;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.extent = (Envelope)state.get("envelope");
        this.description = state.getString("description");
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("description", this.description);
        state.set("envelope", (Persistent)this.extent);
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition(PERSISTENCE_DEFINITION_NAME);
        if (definition == null) {
            definition = manager.addDefinition(ProjectExtent.class, PERSISTENCE_DEFINITION_NAME, "org.gvsig.app.project.ProjectExtent  persistence definition", null, null);
            definition.addDynFieldObject("envelope").setMandatory(true).setClassOfValue(Envelope.class);
            definition.addDynFieldString("description").setMandatory(true);
        }
    }
}

