/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.app.project.documents.Document;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyPasteDocsUtils {
    private static Logger logger = LoggerFactory.getLogger(CopyPasteDocsUtils.class);
    private static File clipboardFolder = null;
    private static String CLIPBOARD_FILE_NAME_PREFIX = "gvSIG_docs_clipboard_";
    private static String CLIPBOARD_FILE_NAME_EXTENSION = "tmp";
    private static int MAX_FILE_COUNT = 1000;

    private CopyPasteDocsUtils() {
    }

    private static PersistenceManager getPersMan() {
        return ToolsLocator.getPersistenceManager();
    }

    private static File getClipboardFolder() {
        if (clipboardFolder == null) {
            File appf = PluginsLocator.getManager().getApplicationHomeFolder();
            clipboardFolder = new File(appf, "clipboard-documents");
            clipboardFolder.mkdirs();
        }
        return clipboardFolder;
    }

    public static List<File> getClipboardFiles(String typeName) {
        File folder;
        ArrayList<File> resp = new ArrayList<File>();
        String filebase = CLIPBOARD_FILE_NAME_PREFIX;
        if (typeName != null) {
            filebase = filebase + typeName;
        }
        if (!(folder = CopyPasteDocsUtils.getClipboardFolder()).exists() || !folder.isDirectory()) {
            return resp;
        }
        File[] ff = folder.listFiles();
        for (int i = 0; i < ff.length; ++i) {
            if (!ff[i].getName().startsWith(filebase)) continue;
            resp.add(ff[i]);
        }
        return resp;
    }

    private static File getFirstUnusedClipboardFile(String docTypeName) throws IOException {
        if (docTypeName == null || docTypeName.length() == 0) {
            throw new IOException("Doc type name cannot be empty");
        }
        String filename = null;
        for (int i = 0; i < MAX_FILE_COUNT; ++i) {
            filename = CLIPBOARD_FILE_NAME_PREFIX + docTypeName + "_" + Integer.toString(i) + "." + CLIPBOARD_FILE_NAME_EXTENSION;
            File resp = new File(CopyPasteDocsUtils.getClipboardFolder(), filename);
            if (resp.exists()) continue;
            resp.deleteOnExit();
            return resp;
        }
        throw new IOException("Clipboard is full for documents: " + docTypeName);
    }

    public static void clearClipboard(String docTypeName) throws IOException {
        File folder;
        String filebase = CLIPBOARD_FILE_NAME_PREFIX;
        if (docTypeName != null) {
            filebase = filebase + docTypeName;
        }
        if (!(folder = CopyPasteDocsUtils.getClipboardFolder()).exists() || !folder.isDirectory()) {
            return;
        }
        File[] ff = folder.listFiles();
        Throwable exc = null;
        for (int i = 0; i < ff.length; ++i) {
            if (!ff[i].getName().startsWith(filebase)) continue;
            try {
                ff[i].delete();
                continue;
            }
            catch (Exception e) {
                if (exc != null) continue;
                exc = e;
            }
        }
        if (exc != null) {
            throw new IOException(exc.getMessage());
        }
    }

    public static List<Document> getClipboardDocuments(String typeName) throws IOException, PersistenceException {
        ArrayList<Document> resp = new ArrayList<Document>();
        List<File> ff = CopyPasteDocsUtils.getClipboardFiles(typeName);
        File infile = null;
        FileInputStream is = null;
        Object obj = null;
        Document doc = null;
        for (int i = 0; i < ff.size(); ++i) {
            infile = ff.get(i);
            is = new FileInputStream(infile);
            obj = CopyPasteDocsUtils.getPersMan().getObject((InputStream)is);
            ((InputStream)is).close();
            if (!(obj instanceof Document)) continue;
            doc = (Document)obj;
            if (typeName != null && doc.getTypeName().compareTo(typeName) != 0) continue;
            resp.add(doc);
        }
        return resp;
    }

    public static void saveToClipboard(List<Document> docs) throws IOException, PersistenceException {
        if (docs == null || docs.size() == 0) {
            return;
        }
        HashMap<String, ArrayList<Document>> separ = new HashMap<String, ArrayList<Document>>();
        Document doc = null;
        ArrayList<Document> list = null;
        for (int i = 0; i < docs.size(); ++i) {
            doc = docs.get(i);
            if (doc == null || doc.getTypeName() == null) continue;
            list = (ArrayList<Document>)separ.get(doc.getTypeName());
            if (list == null) {
                list = new ArrayList<Document>();
                list.add(doc);
                separ.put(doc.getTypeName(), list);
                continue;
            }
            list.add(doc);
        }
        Iterator iter = separ.keySet().iterator();
        String k = null;
        while (iter.hasNext()) {
            k = (String)iter.next();
            CopyPasteDocsUtils.saveToClipboard(k, (List)separ.get(k));
        }
    }

    private static void saveToClipboard(String typeName, List<Document> docs) throws IOException, PersistenceException {
        CopyPasteDocsUtils.clearClipboard(typeName);
        File f = null;
        FileOutputStream os = null;
        PersistentState state = null;
        for (int i = 0; i < docs.size(); ++i) {
            state = CopyPasteDocsUtils.getPersMan().getState((Object)docs.get(i), true);
            if (state.getContext().getErrors() != null) {
                throw state.getContext().getErrors();
            }
            f = CopyPasteDocsUtils.getFirstUnusedClipboardFile(typeName);
            os = new FileOutputStream(f);
            CopyPasteDocsUtils.getPersMan().saveState(state, (OutputStream)os);
            ((OutputStream)os).close();
        }
    }

    public static String getLastMessage(Throwable ex) {
        Throwable p;
        if (ex == null) {
            return "-";
        }
        for (p = ex; p.getCause() != null && p.getCause() != p; p = p.getCause()) {
        }
        return p.getMessage();
    }
}

