/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view;

import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.extension.AddLayer;
import org.gvsig.app.gui.preferencespage.LayerOrderPage;
import org.gvsig.app.project.ProjectPreferences;
import org.gvsig.app.project.documents.DocumentManager;
import org.gvsig.app.project.documents.view.BaseViewDocument;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.BaseLayerCollectionListener;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.LayerCollectionEvent;
import org.gvsig.fmap.mapcontext.layers.LayerCollectionListener;
import org.gvsig.fmap.mapcontext.layers.order.LayerOrderManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultViewDocument
extends BaseViewDocument {
    private static Logger logger = LoggerFactory.getLogger(DefaultViewDocument.class);
    private static final long serialVersionUID = 676711512482334764L;
    public static final String PERSISTENCE_DEFINITION_NAME = "DefaultViewDocument";

    public DefaultViewDocument() {
        this(null);
    }

    public DefaultViewDocument(DocumentManager factory) {
        super(factory);
        ProjectPreferences preferences = (ProjectPreferences)ApplicationLocator.getManager().getPreferences("project");
        MapContext viewMapContext = new MapContext(new ViewPort(preferences.getDefaultProjection()));
        ViewPort vp = viewMapContext.getViewPort();
        vp.setBackColor(preferences.getDefaultViewBackColor());
        vp.setDistanceUnits(preferences.getDefaultDistanceUnits());
        vp.setDistanceArea(preferences.getDefaultDistanceArea());
        LayerOrderManager lom = this.getCurrentOrderManager();
        viewMapContext.setOrderManager(lom);
        if (viewMapContext.getProjection().isProjected()) {
            vp.setMapUnits(1);
        } else {
            vp.setMapUnits(8);
        }
        this.setMapContext(viewMapContext);
        MapContext overviewMapContext = new MapContext(new ViewPort(viewMapContext.getProjection()));
        vp = overviewMapContext.getViewPort();
        vp.setBackColor(preferences.getDefaultOverviewBackColor());
        this.setMapOverViewContext(overviewMapContext);
        this.getMapContext().getLayers().addLayerCollectionListener((LayerCollectionListener)new SetViewPortExtentWhenAddLayerListener(this.getMapContext().getViewPort()));
        this.getMapOverViewContext().getLayers().addLayerCollectionListener((LayerCollectionListener)new SetViewPortExtentWhenAddLayerListener(this.getMapOverViewContext().getViewPort()));
    }

    private LayerOrderManager getCurrentOrderManager() {
        DynObject props = this.getPluginProperties();
        Object val_obj = null;
        if (props.hasDynValue(LayerOrderPage.PREFERENCES_ID)) {
            val_obj = props.getDynValue(LayerOrderPage.PREFERENCES_ID);
        }
        if (val_obj != null && val_obj instanceof LayerOrderManager) {
            LayerOrderManager lom = (LayerOrderManager)val_obj;
            return lom;
        }
        logger.info("No order manager found in persistence.");
        return MapContextLocator.getDefaultOrderManager();
    }

    private DynObject getPluginProperties() {
        PluginsManager pluginsManager = PluginsLocator.getManager();
        return pluginsManager.getPlugin(AddLayer.class).getPluginProperties();
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
    }

    @Override
    public String exportDocumentAsText() {
        return null;
    }

    @Override
    public void setStateFromText(String text) {
    }

    private class SetViewPortExtentWhenAddLayerListener
    extends BaseLayerCollectionListener {
        private Thread th = null;
        private final ViewPort viewPort;

        public SetViewPortExtentWhenAddLayerListener(ViewPort viewPort) {
            this.viewPort = viewPort;
        }

        public synchronized void layerAdded(LayerCollectionEvent e) {
            FLayer layer;
            if (this.th != null) {
                return;
            }
            if (this.viewPort.getEnvelope() == null && (layer = e.getAffectedLayer()).isAvailable()) {
                this.th = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ApplicationManager application = ApplicationLocator.getManager();
                            I18nManager i18n = ToolsLocator.getI18nManager();
                            application.message(i18n.getTranslation("_Calculating_envelope"), 1);
                            Envelope envelope = layer.getFullEnvelope();
                            if (SetViewPortExtentWhenAddLayerListener.this.viewPort.getEnvelope() == null) {
                                DefaultViewDocument.this.getMapContext().zoomToEnvelope(envelope);
                            }
                            application.message("", 1);
                        }
                        catch (ReadException readException) {
                            // empty catch block
                        }
                    }
                }, "AddLayerToView");
                this.th.start();
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

