/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.gvsig.app.project.documents.view.gui.ViewInformationArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultViewInformationArea
implements ViewInformationArea {
    protected final Logger logger = LoggerFactory.getLogger(DefaultViewInformationArea.class);
    private final Map<String, ViewInformationArea.ViewInformationAreaElement> elements = new HashMap<String, ViewInformationArea.ViewInformationAreaElement>();
    private JPanel panel = null;
    private JTabbedPane tab = null;

    @Override
    public void add(final JComponent component, String id, int priority, String label, Icon icon, String tip) {
        this.add(new org.gvsig.tools.swing.api.Component(){

            public JComponent asJComponent() {
                return component;
            }
        }, id, priority, label, icon, tip);
    }

    @Override
    public void add(org.gvsig.tools.swing.api.Component component, String id, int priority, String label, Icon icon, String tip) {
        Element element = new Element(component, id, priority, label, icon, tip);
        this.elements.put(id, element);
        this.update();
    }

    @Override
    public ViewInformationArea.ViewInformationAreaElement get(String id) {
        ViewInformationArea.ViewInformationAreaElement x = this.elements.get(id);
        return x;
    }

    @Override
    public Iterator<ViewInformationArea.ViewInformationAreaElement> iterator() {
        Iterator<ViewInformationArea.ViewInformationAreaElement> x = this.elements.values().iterator();
        return x;
    }

    @Override
    public void remove(String id) {
        this.elements.remove(id);
        this.update();
    }

    @Override
    public void update() {
        if (this.panel == null) {
            return;
        }
        this.panel.removeAll();
        if (this.elements.isEmpty()) {
            return;
        }
        ArrayList<ViewInformationArea.ViewInformationAreaElement> elements = new ArrayList<ViewInformationArea.ViewInformationAreaElement>(this.elements.values());
        if (elements.size() == 1) {
            Element element = (Element)elements.get(0);
            this.panel.add((Component)element.asJComponent(), "Center");
            return;
        }
        Collections.sort(elements, new Comparator<Element>(){

            @Override
            public int compare(Element o1, Element o2) {
                return Integer.compare(o1.getPriority(), o2.getPriority());
            }
        });
        JTabbedPane tab = new JTabbedPane();
        tab.setTabPlacement(3);
        tab.setTabLayoutPolicy(1);
        for (Element element : elements) {
            tab.addTab(element.getLabel(), element.getIcon(), element.asJComponent(), element.getTip());
        }
        int index = 0;
        if (this.tab != null) {
            index = this.tab.getSelectedIndex();
        }
        if (index < 0) {
            index = 0;
        } else if (index >= tab.getTabCount()) {
            index = tab.getTabCount() - 1;
        }
        try {
            tab.setSelectedIndex(index);
        }
        catch (Exception exception) {
            this.logger.warn("Can't restore the selected tab", (Throwable)exception);
        }
        this.tab = tab;
        this.panel.add((Component)this.tab, "Center");
    }

    public JComponent asJComponent() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setLayout(new BorderLayout());
            this.update();
        }
        return this.panel;
    }

    private static class Element
    implements ViewInformationArea.ViewInformationAreaElement {
        private final org.gvsig.tools.swing.api.Component component;
        private final String id;
        private String label;
        private Icon icon;
        private int priority;
        private String tip;

        public Element(org.gvsig.tools.swing.api.Component component, String id, int priority, String label, Icon icon, String tip) {
            this.component = component;
            this.id = id;
            this.priority = priority;
            this.label = label;
            this.icon = icon;
            this.tip = tip;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public org.gvsig.tools.swing.api.Component getComponent() {
            return this.component;
        }

        public JComponent asJComponent() {
            return this.component.asJComponent();
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public void setLabel(String label) {
            this.label = label;
        }

        @Override
        public String getTip() {
            return this.tip;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        @Override
        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        @Override
        public void setPriority(int priority) {
            this.priority = priority;
        }

        @Override
        public void setTip(String tip) {
            this.tip = tip;
        }
    }
}

