/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.legend.edition.gui;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class ValueCellEditor
extends JTextField
implements TableCellEditor {
    private ArrayList listeners = new ArrayList();

    public ValueCellEditor() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ValueCellEditor.this.stopCellEditing();
                } else if (e.getKeyCode() == 27) {
                    ValueCellEditor.this.cancelCellEditing();
                }
            }
        });
    }

    @Override
    public Object getCellEditorValue() {
        return this.getValue(this.getText());
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value == null) {
            this.setText("");
        } else {
            this.setText(value.toString());
        }
        return this;
    }

    @Override
    public void cancelCellEditing() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            CellEditorListener l = (CellEditorListener)this.listeners.get(i);
            ChangeEvent evt = new ChangeEvent(this);
            l.editingCanceled(evt);
        }
    }

    @Override
    public boolean stopCellEditing() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            CellEditorListener l = (CellEditorListener)this.listeners.get(i);
            ChangeEvent evt = new ChangeEvent(this);
            l.editingStopped(evt);
        }
        return true;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }

    private Object getValue(String s) {
        Object val = null;
        try {
            val = Integer.valueOf(s);
            return val;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                val = Long.valueOf(s);
                return val;
            }
            catch (NumberFormatException numberFormatException2) {
                try {
                    val = Float.valueOf(s);
                    return val;
                }
                catch (NumberFormatException numberFormatException3) {
                    try {
                        val = Double.valueOf(s);
                        return val;
                    }
                    catch (NumberFormatException numberFormatException4) {
                        val = s;
                        return val;
                    }
                }
            }
        }
    }
}

