/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.legend.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.app.gui.panels.ColorChooserPanel;
import org.gvsig.app.project.documents.view.legend.gui.ILegendPanel;
import org.gvsig.app.project.documents.view.legend.gui.JSymbolPreviewButton;
import org.gvsig.app.project.documents.view.legend.gui.Quantities;
import org.gvsig.app.project.documents.view.legend.gui.SymbolTable;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.exceptions.LegendLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.operations.ClassifiableVectorial;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.IInterval;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorialIntervalLegend;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.gui.beans.swing.JButton;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.FInterval;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.VectorialIntervalLegend;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.IMultiShapeSymbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorialInterval
extends JPanel
implements ILegendPanel {
    private static final Logger logger = LoggerFactory.getLogger(VectorialInterval.class);
    private GridBagLayoutPanel pnlGeneral = null;
    protected JComboBox cmbField = null;
    protected JTextField txtNumIntervals = null;
    private ColorChooserPanel colorChooserPanel = null;
    private ColorChooserPanel colorChooserPanel1 = null;
    protected JCheckBox chkdefaultvalues = null;
    protected JComboBox cmbIntervalType = null;
    private JPanel panelS = null;
    private JButton bintervals = null;
    private JButton bInsert = null;
    protected JButton bDelAll = null;
    protected JButton bDel = null;
    private int count = 0;
    protected ClassifiableVectorial layer;
    protected VectorialIntervalLegend theLegend;
    protected IVectorialIntervalLegend auxLegend = null;
    protected SymbolTable symbolTable;
    private MyListener listener = new MyListener();
    protected JPanel pnlCenter = null;
    protected JPanel optionPanel;
    private JPanel pnlNorth;
    protected JSymbolPreviewButton defaultSymbolPrev;
    private GridBagLayoutPanel defaultSymbolPanel = new GridBagLayoutPanel();
    private MapContextManager mapContextManager = MapContextLocator.getMapContextManager();

    public VectorialInterval() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(700, 300);
        this.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.add((Component)this.getPnlNorth(), "North");
        this.add((Component)this.getPnlButtons(), "South");
        this.add((Component)this.getPnlCenter(), "Center");
        this.setOptionPanel(this.getOptionPanel());
    }

    private JPanel getPnlNorth() {
        if (this.pnlNorth == null) {
            this.pnlNorth = new JPanel(new GridLayout(1, 2, 5, 5));
            this.pnlNorth.add(this.getGeneralPanel());
        }
        return this.pnlNorth;
    }

    private JPanel getGeneralPanel() {
        if (this.pnlGeneral == null) {
            this.pnlGeneral = new GridBagLayoutPanel();
            this.pnlGeneral.setBorder((Border)BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"fields")));
            this.pnlGeneral.addComponent(PluginServices.getText((Object)this, (String)"Campo_de_clasificacion_XcolonX"), (Component)this.getCmbFields(), new Insets(2, 5, 2, 5));
            this.pnlGeneral.addComponent(PluginServices.getText((Object)this, (String)"tipo_de_intervalo_XcolonX"), (Component)this.getCmbIntervalTypes(), new Insets(2, 5, 2, 5));
            JPanel aux = new JPanel(new FlowLayout(3, 0, 0));
            aux.add(this.getTxtNumIntervals());
            this.pnlGeneral.addComponent(PluginServices.getText((Object)this, (String)"No_de_intervalos_XcolonX"), (Component)aux, new Insets(2, 5, 2, 5));
            this.defaultSymbolPanel.add((Component)this.getChkDefaultvalues(), null);
            this.pnlGeneral.addComponent((Component)this.defaultSymbolPanel, new Insets(10, 25, 2, 5));
        }
        return this.pnlGeneral;
    }

    public JPanel getOptionPanel() {
        if (this.optionPanel == null) {
            this.optionPanel = new JPanel(new FlowLayout(3));
            this.optionPanel.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"color_ramp")));
            GridBagLayoutPanel aux = new GridBagLayoutPanel();
            aux.addComponent(PluginServices.getText((Object)this, (String)"Color_inicio_XcolonX"), (Component)this.getColorChooserPanel());
            aux.addComponent(PluginServices.getText((Object)this, (String)"Color_final_XcolonX"), (Component)this.getColorChooserPanel1());
            this.optionPanel.add((Component)aux);
        }
        return this.optionPanel;
    }

    private void setOptionPanel(JPanel p) {
        this.getPnlNorth().remove(this.getOptionPanel());
        this.getPnlNorth().add((Component)p, "North");
    }

    private JComboBox getCmbFields() {
        if (this.cmbField == null) {
            this.cmbField = new JComboBox();
            this.cmbField.setActionCommand("FIELD_SELECTED");
            this.cmbField.addActionListener(this.listener);
            this.cmbField.setVisible(true);
        }
        return this.cmbField;
    }

    private JTextField getTxtNumIntervals() {
        if (this.txtNumIntervals == null) {
            this.txtNumIntervals = new JTextField(5);
            this.txtNumIntervals.setText("5");
        }
        return this.txtNumIntervals;
    }

    private ColorChooserPanel getColorChooserPanel() {
        if (this.colorChooserPanel == null) {
            this.colorChooserPanel = new ColorChooserPanel();
            this.colorChooserPanel.setBounds(new Rectangle(108, 49, 54, 20));
            this.colorChooserPanel.setAlpha(255);
            this.colorChooserPanel.setColor(Color.red);
        }
        return this.colorChooserPanel;
    }

    private ColorChooserPanel getColorChooserPanel1() {
        if (this.colorChooserPanel1 == null) {
            this.colorChooserPanel1 = new ColorChooserPanel();
            this.colorChooserPanel1.setBounds(new Rectangle(251, 49, 54, 20));
            this.colorChooserPanel1.setAlpha(255);
            this.colorChooserPanel1.setColor(Color.blue);
        }
        return this.colorChooserPanel1;
    }

    protected JCheckBox getChkDefaultvalues() {
        if (this.chkdefaultvalues == null) {
            this.chkdefaultvalues = new JCheckBox();
            this.chkdefaultvalues.setText(PluginServices.getText((Object)this, (String)"resto_valores") + ": ");
            this.chkdefaultvalues.setBounds(new Rectangle(342, 26, 141, 20));
            this.chkdefaultvalues.setSelected(false);
            this.chkdefaultvalues.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (VectorialInterval.this.chkdefaultvalues.isSelected()) {
                        VectorialInterval.this.auxLegend.useDefaultSymbol(true);
                    } else {
                        VectorialInterval.this.auxLegend.useDefaultSymbol(false);
                    }
                }
            });
        }
        return this.chkdefaultvalues;
    }

    private JComboBox getCmbIntervalTypes() {
        if (this.cmbIntervalType == null) {
            this.cmbIntervalType = new JComboBox();
            this.cmbIntervalType.setActionCommand("INTERVAL_TYPE");
            this.cmbIntervalType.addActionListener(this.listener);
            this.cmbIntervalType.addItem(PluginServices.getText((Object)this, (String)"equal_intervals"));
            this.cmbIntervalType.addItem(PluginServices.getText((Object)this, (String)"natural_intervals"));
            this.cmbIntervalType.addItem(PluginServices.getText((Object)this, (String)"quantile_intervals"));
            this.cmbIntervalType.setVisible(true);
        }
        return this.cmbIntervalType;
    }

    protected JPanel getPnlButtons() {
        if (this.panelS == null) {
            this.panelS = new JPanel();
            this.panelS.setPreferredSize(new Dimension(417, 32));
            this.panelS.add((Component)this.getBintervals(), null);
            this.panelS.add((Component)this.getBInsert(), null);
            this.panelS.add((Component)this.getBDelAll(), null);
            this.panelS.add((Component)this.getBDel(), null);
        }
        return this.panelS;
    }

    private JButton getBintervals() {
        if (this.bintervals == null) {
            this.bintervals = new JButton();
            this.bintervals.setActionCommand("ADD_ALL_VALUES");
            this.bintervals.addActionListener((ActionListener)this.listener);
            this.bintervals.setText(PluginServices.getText((Object)this, (String)"Calcular_intervalos"));
        }
        return this.bintervals;
    }

    private JButton getBInsert() {
        if (this.bInsert == null) {
            this.bInsert = new JButton();
            this.bInsert.setActionCommand("ADD_VALUE");
            this.bInsert.addActionListener((ActionListener)this.listener);
            this.bInsert.setText(PluginServices.getText((Object)this, (String)"Anadir"));
        }
        return this.bInsert;
    }

    private JButton getBDelAll() {
        if (this.bDelAll == null) {
            this.bDelAll = new JButton();
            this.bDelAll.setActionCommand("REMOVE_ALL");
            this.bDelAll.addActionListener((ActionListener)this.listener);
            this.bDelAll.setText(PluginServices.getText((Object)this, (String)"Quitar_todos"));
        }
        return this.bDelAll;
    }

    private JButton getBDel() {
        if (this.bDel == null) {
            this.bDel = new JButton();
            this.bDel.setText(PluginServices.getText((Object)this, (String)"Quitar"));
            this.bDel.setActionCommand("REMOVE");
            this.bDel.addActionListener((ActionListener)this.listener);
        }
        return this.bDel;
    }

    protected void fillTableValues() {
        this.symbolTable.removeAllItems();
        try {
            IInterval[] arrayIntervalos = this.calculateIntervals();
            if (arrayIntervalos == null) {
                return;
            }
            NumberFormat.getInstance().setMaximumFractionDigits(2);
            this.auxLegend.clear();
            int stepR = 0;
            int stepG = 0;
            int stepB = 0;
            Color startColor = this.colorChooserPanel.getColor();
            Color endColor = this.colorChooserPanel1.getColor();
            int r = startColor.getRed();
            int g = startColor.getGreen();
            int b = startColor.getBlue();
            if (arrayIntervalos.length > 1) {
                stepR = (int)Math.floor((endColor.getRed() - r) / (arrayIntervalos.length - 1));
                stepG = (int)Math.floor((endColor.getGreen() - g) / (arrayIntervalos.length - 1));
                stepB = (int)Math.floor((endColor.getBlue() - b) / (arrayIntervalos.length - 1));
            }
            this.auxLegend = (IVectorialIntervalLegend)MapContextLocator.getMapContextManager().createLegend("VectorialInterval");
            this.auxLegend.setShapeType(this.layer.getShapeType());
            this.auxLegend.useDefaultSymbol(false);
            this.auxLegend.setStartColor(startColor);
            this.auxLegend.setEndColor(endColor);
            int geomType = this.layer.getGeometryType().getType();
            int numSymbols = 0;
            for (int k = 0; k < arrayIntervalos.length; ++k) {
                int resp;
                IInterval interval = arrayIntervalos[k];
                ISymbol theSymbol = null;
                Color col = new Color(r, g, b);
                int intervalos = arrayIntervalos.length - 1;
                if (intervalos == k) {
                    col = endColor;
                }
                if ((theSymbol = this.mapContextManager.getSymbolManager().createSymbol(geomType, col)) instanceof IMultiShapeSymbol) {
                    IMultiShapeSymbol mss = (IMultiShapeSymbol)theSymbol;
                    mss.getLineSymbol().setLineColor(col);
                    mss.getFillSymbol().setFillColor(col);
                }
                theSymbol.setDescription(NumberFormat.getInstance().format(interval.getMin()) + " - " + NumberFormat.getInstance().format(interval.getMax()));
                r += stepR;
                g += stepG;
                b += stepB;
                this.auxLegend.addSymbol((Object)interval, theSymbol);
                if (++numSymbols <= 100 || (resp = JOptionPane.showConfirmDialog(this, PluginServices.getText((Object)this, (String)"mas_de_100_simbolos"), PluginServices.getText((Object)this, (String)"quiere_continuar"), 0, 2)) != 1 && resp != -1) continue;
                return;
            }
            this.symbolTable.fillTableFromSymbolList(this.auxLegend.getSymbols(), this.auxLegend.getValues(), this.auxLegend.getDescriptions());
        }
        catch (DataException e) {
            NotificationManager.addError((String)PluginServices.getText((Object)this, (String)"could_not_get_shape_type"), (Throwable)e);
        }
        catch (LegendLayerException e) {
            NotificationManager.addError((String)PluginServices.getText((Object)this, (String)"failed_computing_intervals"), (Throwable)e);
        }
        this.bDelAll.setEnabled(true);
        this.bDel.setEnabled(true);
    }

    protected IInterval[] calculateIntervals() throws LegendLayerException {
        int intervalCount = 1;
        try {
            intervalCount = (int)Double.parseDouble(this.txtNumIntervals.getText());
            if (intervalCount < 1) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, PluginServices.getText((Object)this, (String)"invalid_interval_count_value"));
            return null;
        }
        try {
            this.auxLegend.setIntervalType(this.getCmbIntervalTypes().getSelectedIndex());
            return this.auxLegend.calculateIntervals(((FLyrVect)this.layer).getFeatureStore(), (String)this.cmbField.getSelectedItem(), intervalCount, this.layer.getShapeType());
        }
        catch (DataException e) {
            return null;
        }
    }

    public void setData(FLayer layer, ILegend legend) {
        this.layer = (ClassifiableVectorial)layer;
        int shapeType = 0;
        try {
            shapeType = this.layer.getShapeType();
        }
        catch (DataException e) {
            NotificationManager.addError((String)PluginServices.getText((Object)this, (String)"generating_intervals"), (Throwable)e);
        }
        if (this.symbolTable != null) {
            this.pnlCenter.remove(this.symbolTable);
        }
        this.getDefaultSymbolPrev(shapeType);
        this.symbolTable = new SymbolTable(this, "intervals", shapeType);
        this.pnlCenter.add(this.symbolTable);
        this.fillFieldNames();
        if (VectorialIntervalLegend.class.equals(legend.getClass())) {
            this.auxLegend = (VectorialIntervalLegend)legend.cloneLegend();
            this.chkdefaultvalues.setSelected(this.auxLegend.isUseDefaultSymbol());
            this.cmbField.getModel().setSelectedItem(this.auxLegend.getClassifyingFieldNames()[0]);
            Object[] auxValues = this.auxLegend.getValues();
            ArrayList<ISymbol> symbols = new ArrayList<ISymbol>();
            ArrayList<Object> values = new ArrayList<Object>();
            ArrayList<String> descriptions = new ArrayList<String>();
            for (int i = 0; i < auxValues.length; ++i) {
                Object key = auxValues[i];
                if (key == null) continue;
                IInterval auxInterval = null;
                if (!(key instanceof IInterval)) continue;
                auxInterval = (IInterval)key;
                ISymbol symbol = this.auxLegend.getSymbolByInterval(auxInterval);
                symbols.add(symbol);
                values.add(auxValues[i]);
                descriptions.add(symbol.getDescription());
            }
            this.symbolTable.fillTableFromSymbolList(symbols.toArray(new ISymbol[0]), values.toArray(), descriptions.toArray(new String[0]));
            this.colorChooserPanel.setColor(this.auxLegend.getStartColor());
            this.colorChooserPanel1.setColor(this.auxLegend.getEndColor());
            this.colorChooserPanel.repaint();
            this.colorChooserPanel1.repaint();
            if (this.auxLegend.isUseDefaultSymbol()) {
                this.txtNumIntervals.setText(String.valueOf(this.auxLegend.getSymbols().length - 1));
            } else {
                this.txtNumIntervals.setText(String.valueOf(this.auxLegend.getSymbols().length));
            }
        } else {
            this.auxLegend = new VectorialIntervalLegend();
            this.auxLegend.setShapeType(shapeType);
            this.auxLegend.useDefaultSymbol(false);
        }
        this.defaultSymbolPrev.setSymbol(this.auxLegend.getDefaultSymbol());
        this.cmbIntervalType.setSelectedIndex(this.auxLegend.getIntervalType());
    }

    public void getDefaultSymbolPrev(int shapeType) {
        if (this.defaultSymbolPrev == null) {
            this.defaultSymbolPrev = new JSymbolPreviewButton(shapeType);
            this.defaultSymbolPrev.setPreferredSize(new Dimension(110, 20));
            this.defaultSymbolPanel.add((Component)this.defaultSymbolPrev, null);
        }
    }

    protected void fillFieldNames() {
        FeatureStore rs = null;
        ArrayList<String> nomFields = null;
        try {
            rs = ((FLyrVect)this.layer).getFeatureStore();
            nomFields = new ArrayList<String>();
            for (FeatureAttributeDescriptor descriptor : rs.getDefaultFeatureType()) {
                int type = descriptor.getType();
                if (type != 4 && type != 7 && type != 6 && type != 5 && type != 19) continue;
                nomFields.add(descriptor.getName());
            }
        }
        catch (DataException e) {
            NotificationManager.addError((String)PluginServices.getText((Object)this, (String)"recovering_recordset"), (Throwable)e);
        }
        DefaultComboBoxModel<Object> cM = new DefaultComboBoxModel<Object>(nomFields.toArray());
        this.cmbField.setModel(cM);
        this.symbolTable.removeAllItems();
    }

    public ILegend getLegend() {
        this.fillSymbolListFromTable();
        if (this.defaultSymbolPrev.getSymbol() != null) {
            this.auxLegend.setDefaultSymbol(this.defaultSymbolPrev.getSymbol());
        }
        this.auxLegend.useDefaultSymbol(this.chkdefaultvalues.isSelected());
        this.auxLegend.setIntervalType(this.cmbIntervalType.getSelectedIndex());
        this.theLegend = (VectorialIntervalLegend)this.auxLegend.cloneLegend();
        return this.theLegend;
    }

    private void fillSymbolListFromTable() {
        ISymbol theSymbol;
        IInterval theInterval = null;
        this.auxLegend.clear();
        String fieldName = (String)this.cmbField.getSelectedItem();
        this.auxLegend.setClassifyingFieldNames(new String[]{fieldName});
        ISymbol defsym = null;
        if (this.chkdefaultvalues.isSelected() && this.defaultSymbolPrev.getSymbol() != null) {
            defsym = this.defaultSymbolPrev.getSymbol();
            String description = PluginServices.getText((Object)this, (String)"default");
            defsym.setDescription(description);
            this.auxLegend.setDefaultSymbol(defsym);
            this.auxLegend.useDefaultSymbol(true);
        } else {
            this.auxLegend.useDefaultSymbol(false);
        }
        try {
            FeatureStore rs = ((FLyrVect)this.layer).getFeatureStore();
            FeatureType featureType = rs.getDefaultFeatureType();
            this.auxLegend.setClassifyingFieldTypes(new int[]{featureType.getAttributeDescriptor(fieldName).getType()});
        }
        catch (DataException e) {
            NotificationManager.addError((String)PluginServices.getText((Object)this, (String)"recovering_recordset"), (Throwable)e);
        }
        for (int row = 0; row < this.symbolTable.getRowCount(); ++row) {
            if (!(this.symbolTable.getFieldValue(row, 1) instanceof FInterval)) continue;
            theInterval = (IInterval)this.symbolTable.getFieldValue(row, 1);
            theSymbol = (ISymbol)this.symbolTable.getFieldValue(row, 0);
            theSymbol.setDescription((String)this.symbolTable.getFieldValue(row, 2));
            this.auxLegend.addSymbol((Object)theInterval, theSymbol);
        }
        if (this.auxLegend.isUseDefaultSymbol()) {
            theSymbol = this.auxLegend.getDefaultSymbol();
            this.auxLegend.addSymbol((Object)theSymbol.getDescription(), theSymbol);
        }
    }

    private JPanel getPnlCenter() {
        if (this.pnlCenter == null) {
            this.pnlCenter = new JPanel();
        }
        return this.pnlCenter;
    }

    public String getDescription() {
        return PluginServices.getText((Object)this, (String)"Muestra_los_elementos_de_la_capa_usando_una_gama_de_colores_en_funcion_del_valor_de_un_determinado_campo_de_atributos") + ".";
    }

    public ImageIcon getIcon() {
        return IconThemeHelper.getImageIcon((String)"legend-overview-vectorial-interval");
    }

    public Class getParentClass() {
        return Quantities.class;
    }

    public String getTitle() {
        return PluginServices.getText((Object)this, (String)"Intervalos");
    }

    public JPanel getPanel() {
        return this;
    }

    public Class getLegendClass() {
        return VectorialIntervalLegend.class;
    }

    private boolean isNumericField(int fieldType) {
        return fieldType == 7 || fieldType == 6 || fieldType == 5 || fieldType == 4 || fieldType == 19;
    }

    public boolean isSuitableFor(FLayer layer) {
        if (!layer.isAvailable()) {
            return false;
        }
        if (layer instanceof FLyrVect) {
            try {
                FeatureStore sds = ((FLyrVect)layer).getFeatureStore();
                FeatureType featureType = sds.getDefaultFeatureType();
                for (FeatureAttributeDescriptor descriptor : featureType) {
                    if (!descriptor.getDataType().isNumeric()) continue;
                    return true;
                }
            }
            catch (DataException e) {
                return false;
            }
        }
        return false;
    }

    class MyListener
    implements ActionListener {
        MyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox cb;
            if (e.getActionCommand() == "FIELD_SELECTED") {
                cb = (JComboBox)e.getSource();
                String fieldName = (String)cb.getSelectedItem();
                VectorialInterval.this.symbolTable.removeAllItems();
                VectorialInterval.this.auxLegend.setClassifyingFieldNames(new String[]{fieldName});
            } else if (e.getActionCommand() == "INTERVAL_TYPE") {
                cb = (JComboBox)e.getSource();
                if (VectorialInterval.this.auxLegend != null && cb.getSelectedIndex() != VectorialInterval.this.auxLegend.getIntervalType()) {
                    VectorialInterval.this.auxLegend.setIntervalType(cb.getSelectedIndex());
                    VectorialInterval.this.symbolTable.removeAllItems();
                }
            }
            if (e.getActionCommand() == "ADD_ALL_VALUES") {
                VectorialInterval.this.fillTableValues();
            }
            if (e.getActionCommand() == "ADD_VALUE") {
                try {
                    VectorialInterval.this.symbolTable.addTableRecord(VectorialInterval.this.mapContextManager.getSymbolManager().createSymbol(VectorialInterval.this.layer.getShapeType()), new FInterval(0.0, 0.0), "0 - 0");
                }
                catch (DataException e1) {
                    NotificationManager.addError((String)PluginServices.getText((Object)this, (String)"could_not_get_shape_type"), (Throwable)e1);
                }
            }
            if (e.getActionCommand() == "REMOVE_ALL") {
                VectorialInterval.this.symbolTable.removeAllItems();
            }
            if (e.getActionCommand() == "REMOVE") {
                VectorialInterval.this.symbolTable.removeSelectedRows();
            }
        }
    }
}

