/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.legend.gui.legendactions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.documents.view.legend.gui.LegendFileFilter;
import org.gvsig.app.project.documents.view.legend.gui.LegendsPanel;
import org.gvsig.app.project.documents.view.legend.gui.legendactions.AbstractLoadSaveLegendAction;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.exceptions.WriteLegendException;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.driver.ILegendWriter;
import org.gvsig.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveLegendAction
extends AbstractLoadSaveLegendAction {
    private static final long serialVersionUID = -382469306285635077L;
    private static final Logger logger = LoggerFactory.getLogger(SaveLegendAction.class);

    public SaveLegendAction() {
        this.putValue("Name", PluginServices.getText((Object)this, (String)"Guardar_leyenda") + "...");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!(e.getSource() instanceof LegendsPanel)) {
            return;
        }
        try {
            this.saveLegend((LegendsPanel)e.getSource());
        }
        catch (Exception exc) {
            logger.warn("_Unable_to_save_legend", (Throwable)exc);
            JOptionPane.showMessageDialog(ApplicationLocator.getManager().getRootComponent(), Messages.getText((String)"_Unable_to_save_legend") + "\n\n" + exc.getMessage(), Messages.getText((String)"legend"), 2);
        }
    }

    private void saveLegend(LegendsPanel legends) throws Exception {
        List<LegendFileFilter> filters = this.getLegendFileFilters(true);
        if (filters.isEmpty()) {
            JOptionPane.showMessageDialog(ApplicationLocator.getManager().getRootComponent(), Messages.getText((String)"_No_output_format_available"), Messages.getText((String)"legend"), 2);
            return;
        }
        ILegend legend = legends.getLegend();
        MapContextManager mcoman = MapContextLocator.getMapContextManager();
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(false);
        for (int i = 0; i < filters.size(); ++i) {
            fileChooser.addChoosableFileFilter(filters.get(i));
        }
        if (fileChooser.showSaveDialog(ApplicationLocator.getManager().getRootComponent()) == 0) {
            ILegendWriter lw;
            LegendFileFilter lff = (LegendFileFilter)fileChooser.getFileFilter();
            File selfile = fileChooser.getSelectedFile();
            if (!selfile.getAbsolutePath().toLowerCase().endsWith("." + lff.getFileExtension().toLowerCase())) {
                selfile = new File(selfile.getAbsolutePath() + "." + lff.getFileExtension().toLowerCase());
            }
            if ((lw = mcoman.createLegendWriter(legend.getClass(), lff.getFileExtension())) == null) {
                throw new WriteLegendException(legend, (Throwable)new Exception("Unable to create legend writer."));
            }
            lw.write(legend, selfile, lff.getFileExtension());
        }
    }
}

