/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toc;

import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.DefaultViewPanel;
import org.gvsig.app.project.documents.view.toc.ITocOrderListener;
import org.gvsig.app.project.documents.view.toc.TocItemBranch;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;

public class DnDJTree
extends JTree
implements TreeSelectionListener,
DragGestureListener,
DropTargetListener,
DragSourceListener {
    protected ArrayList m_Listeners = new ArrayList();
    private static DnDJTree oDnDtocOrigin = null;
    private static DnDJTree oDnDtocDestination = null;
    protected TreePath SelectedTreePath = null;
    protected DefaultMutableTreeNode SelectedNode = null;
    private DragSource dragSource = DragSource.getDefaultDragSource();
    private DropTarget dropTarget;

    public DnDJTree(TreeModel treeModel) {
        super(treeModel);
        DragGestureRecognizer dgr = this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        dgr.setSourceActions(dgr.getSourceActions() & 0xFFFFFFFB);
        this.setDropTarget();
    }

    public void invalidateListeners() {
        this.removeDropListener();
        this.removeTreeListener();
    }

    private void addDropListener() {
        this.dropTarget = new DropTarget(this, this);
    }

    private void removeDropListener() {
        this.dropTarget = null;
    }

    private void addTreeListener() {
        this.addTreeSelectionListener(this);
    }

    private void removeTreeListener() {
        this.removeTreeSelectionListener(this);
    }

    public void setDropTarget() {
        this.addTreeListener();
        this.addDropListener();
    }

    public DefaultMutableTreeNode getSelectedNode() {
        return this.SelectedNode;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        if (((MouseEvent)((MouseDragGestureRecognizer)e.getSource()).getTriggerEvent()).getButton() == 3) {
            return;
        }
        DefaultMutableTreeNode dragNode = this.getSelectedNode();
        if (dragNode != null) {
            if (!(dragNode.getUserObject() instanceof Transferable)) {
                return;
            }
            Transferable transferable = (Transferable)dragNode.getUserObject();
            int action = e.getDragAction();
            oDnDtocOrigin = this;
            this.dragSource.startDrag(e, null, transferable, this);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dsde) {
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        try {
            int newPos;
            Transferable tr = e.getTransferable();
            if (!tr.isDataFlavorSupported(TocItemBranch.INFO_FLAVOR)) {
                e.rejectDrop();
                return;
            }
            TocItemBranch childInfo = (TocItemBranch)tr.getTransferData(TocItemBranch.INFO_FLAVOR);
            Point loc = e.getLocation();
            TreePath destinationPath = this.getPathForLocation(loc.x, loc.y);
            final String msg = this.testDropTarget(destinationPath, this.SelectedTreePath);
            if (msg != null) {
                e.rejectDrop();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        System.err.println(msg);
                    }
                });
                return;
            }
            if (!this.testSameComponent(e)) {
                e.rejectDrop();
                return;
            }
            DefaultMutableTreeNode nodoTocado = (DefaultMutableTreeNode)destinationPath.getLastPathComponent();
            DefaultMutableTreeNode oldParent = (DefaultMutableTreeNode)this.getSelectedNode().getParent();
            if (nodoTocado.getParent().equals(this.getSelectedNode())) {
                return;
            }
            if (oldParent == null) {
                return;
            }
            int oldPos = oldParent.getIndex(this.getSelectedNode());
            if (!(nodoTocado.getUserObject() instanceof TocItemBranch)) {
                nodoTocado = (DefaultMutableTreeNode)nodoTocado.getParent();
            }
            DefaultMutableTreeNode destParent = null;
            if (((TocItemBranch)nodoTocado.getUserObject()).getLayer() instanceof FLayers) {
                newPos = 0;
                destParent = nodoTocado;
            } else {
                destParent = (DefaultMutableTreeNode)nodoTocado.getParent();
                newPos = destParent.getIndex(nodoTocado);
            }
            int action = e.getDropAction();
            boolean copyAction = action == 1;
            DefaultMutableTreeNode newChild = new DefaultMutableTreeNode(childInfo);
            if (this.getSelectedNode().getAllowsChildren()) {
                int childs = this.getSelectedNode().getChildCount();
                for (int i = 0; i < childs; ++i) {
                    newChild.add((MutableTreeNode)this.getSelectedNode().getChildAt(0));
                }
            }
            try {
                if (!copyAction) {
                    oldParent.remove(this.getSelectedNode());
                    destParent.insert(newChild, newPos);
                }
                if (copyAction) {
                    e.acceptDrop(1);
                } else {
                    e.acceptDrop(2);
                }
            }
            catch (IllegalStateException ils) {
                e.rejectDrop();
            }
            e.getDropTargetContext().dropComplete(true);
            DefaultTreeModel model = (DefaultTreeModel)this.getModel();
            model.reload(this.getSelectedNode().getRoot());
            FLayers lpo = null;
            FLayers lpd = null;
            lpo = oldParent.getUserObject() instanceof TocItemBranch ? (FLayers)((TocItemBranch)oldParent.getUserObject()).getLayer() : ((TocItemBranch)this.getSelectedNode().getUserObject()).getLayer().getParentLayer();
            lpd = destParent.getUserObject() instanceof TocItemBranch ? (FLayers)((TocItemBranch)destParent.getUserObject()).getLayer() : ((TocItemBranch)nodoTocado.getUserObject()).getLayer().getParentLayer();
            if (destParent.equals(oldParent)) {
                this.callListeners(oldPos, newPos, lpd);
            } else {
                this.callListeners(lpo, lpd, ((TocItemBranch)newChild.getUserObject()).getLayer());
            }
        }
        catch (IOException io) {
            e.rejectDrop();
        }
        catch (UnsupportedFlavorException ufe) {
            e.rejectDrop();
        }
    }

    public void dropRoot(TreeNode tn) {
        DefaultMutableTreeNode nodoTocado = (DefaultMutableTreeNode)tn;
        if (this.getSelectedNode() == null) {
            return;
        }
        DefaultMutableTreeNode oldParent = (DefaultMutableTreeNode)this.getSelectedNode().getParent();
        if (oldParent != null) {
            int oldPos = oldParent.getIndex(this.getSelectedNode());
            DefaultMutableTreeNode destParent = null;
            int newPos = 0;
            destParent = nodoTocado;
            DefaultMutableTreeNode newChild = (DefaultMutableTreeNode)this.getSelectedNode().clone();
            oldParent.remove(this.getSelectedNode());
            destParent.insert(newChild, newPos);
            IWindow[] views = PluginServices.getMDIManager().getAllWindows();
            for (int i = 0; i < views.length; ++i) {
                if (!(views[i] instanceof DefaultViewPanel)) continue;
                ((DefaultTreeModel)((DefaultViewPanel)views[i]).getTOC().getTree().getModel()).reload(oldParent);
            }
            DefaultTreeModel model = (DefaultTreeModel)this.getModel();
            model.reload(destParent);
            FLayers lpo = null;
            FLayers lpd = null;
            lpo = ((TocItemBranch)this.getSelectedNode().getUserObject()).getLayer().getParentLayer();
            for (int i = 0; i < views.length; ++i) {
                if (!(views[i] instanceof DefaultViewPanel) || !((DefaultViewPanel)views[i]).getTOC().getTree().equals(this)) continue;
                lpd = ((DefaultViewPanel)views[i]).getMapControl().getMapContext().getLayers();
            }
            if (destParent.equals(oldParent)) {
                this.callListeners(oldPos, newPos, lpd);
            } else {
                this.callListeners(lpo, lpd, ((TocItemBranch)newChild.getUserObject()).getLayer());
            }
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        String msg;
        Point cursorLocationBis = e.getLocation();
        TreePath destinationPath = this.getPathForLocation(cursorLocationBis.x, cursorLocationBis.y);
        if (this.testSameComponent(e) && (msg = this.testDropTarget(destinationPath, this.SelectedTreePath)) == null) {
            e.acceptDrag(2);
            return;
        }
        e.rejectDrag();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    private void setSelectedNode(DefaultMutableTreeNode smtn) {
        if (smtn != null) {
            this.SelectedNode = smtn;
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent evt) {
        this.SelectedTreePath = evt.getNewLeadSelectionPath();
        if (this.SelectedTreePath == null) {
            this.setSelectedNode(null);
        } else {
            this.setSelectedNode((DefaultMutableTreeNode)this.SelectedTreePath.getLastPathComponent());
        }
    }

    private String testDropTarget(TreePath destination, TreePath dropper) {
        boolean destinationPathIsNull;
        boolean bl = destinationPathIsNull = destination == null;
        if (destinationPathIsNull) {
            return "Invalid drop location.";
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)destination.getLastPathComponent();
        if (!node.getAllowsChildren()) {
            return "This node does not allow children";
        }
        if (destination.equals(dropper)) {
            return "Destination cannot be same as source";
        }
        return null;
    }

    private boolean testSameComponent(DropTargetEvent e) {
        oDnDtocDestination = this;
        return oDnDtocOrigin == oDnDtocDestination;
    }

    public boolean addOrderListener(ITocOrderListener arg0) {
        return this.m_Listeners.add(arg0);
    }

    public boolean removeOrderListener(ITocOrderListener arg0) {
        return this.m_Listeners.remove(arg0);
    }

    private void callListeners(int oldPos, int newPos, FLayers lpd) {
        for (int i = 0; i < this.m_Listeners.size(); ++i) {
            ITocOrderListener listener = (ITocOrderListener)this.m_Listeners.get(i);
            listener.orderChanged(oldPos, newPos, lpd);
        }
    }

    private void callListeners(FLayers lpo, FLayers lpd, FLayer ls) {
        for (int i = 0; i < this.m_Listeners.size(); ++i) {
            ITocOrderListener listener = (ITocOrderListener)this.m_Listeners.get(i);
            listener.parentChanged(lpo, lpd, ls);
        }
    }
}

