/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toc;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.app.project.documents.view.IContextMenuAction;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.app.project.documents.view.toc.actions.ChangeSymbolTocMenuEntry;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TocItemLeaf
implements ITocItem {
    private static Logger logger = LoggerFactory.getLogger(TocItemLeaf.class);
    private ISymbol symbol;
    private String description;
    private int layerType;
    private static int w_1symbol = 20;
    private static int h_1symbol = 15;
    private Dimension sz;
    BufferedImage imgLegend = null;
    public static final DataFlavor INFO_FLAVOR = new DataFlavor(TocItemLeaf.class, "ItemLeaf");
    static DataFlavor[] flavors = new DataFlavor[]{INFO_FLAVOR};

    public TocItemLeaf(ISymbol symbol, String description, int layerType) {
        this.symbol = symbol;
        this.description = description;
        this.layerType = layerType;
    }

    public TocItemLeaf() {
    }

    public void setImageLegend(Image imageLegend, String descrip, Dimension size) {
        this.description = descrip;
        this.sz = size;
        this.imgLegend = new BufferedImage(this.sz.width, this.sz.height, 2);
        Graphics2D g2 = this.imgLegend.createGraphics();
        double ratioImage = (double)imageLegend.getWidth(null) / (double)imageLegend.getHeight(null);
        double ratioToc = (double)this.sz.width / (double)this.sz.height;
        boolean resul = g2.drawImage(imageLegend, 0, 0, this.sz.width, this.sz.height, null);
    }

    @Override
    public String getLabel() {
        return this.description;
    }

    @Override
    public Icon getIcon() {
        if (this.imgLegend != null) {
            return new ImageIcon(this.imgLegend);
        }
        BufferedImage img = null;
        Graphics2D g2 = null;
        Rectangle r = null;
        switch (this.layerType) {
            case 0: {
                img = new BufferedImage(3 * w_1symbol, h_1symbol, 2);
                g2 = img.createGraphics();
                r = new Rectangle(3 * w_1symbol, h_1symbol);
                break;
            }
            case 16: {
                break;
            }
            default: {
                int wSymbol = w_1symbol;
                if (StringUtils.isEmpty((CharSequence)this.getLabel())) {
                    wSymbol = this.sz.width;
                }
                img = new BufferedImage(wSymbol, h_1symbol, 2);
                g2 = img.createGraphics();
                r = new Rectangle(w_1symbol, h_1symbol);
            }
        }
        if (g2 == null) {
            return null;
        }
        try {
            ISymbol clonesym = (ISymbol)this.symbol.clone();
            clonesym.drawInsideRectangle(g2, AffineTransform.getScaleInstance(1.0, 1.0), r);
        }
        catch (SymbolDrawingException e) {
            if (e.getType() == 0) {
                try {
                    MapContextLocator.getSymbolManager().getWarningSymbol(SymbolDrawingException.STR_UNSUPPORTED_SET_OF_SETTINGS, this.symbol.getDescription(), 0).drawInsideRectangle(g2, g2.getTransform(), r.getBounds());
                }
                catch (SymbolDrawingException symbolDrawingException) {}
            }
            logger.warn("Symbol type mismatch", (Throwable)e);
            return null;
        }
        catch (CloneNotSupportedException e) {
            logger.warn("Symbol cannot be cloned (?)", (Throwable)e);
            return null;
        }
        return new ImageIcon(img);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dF) {
        return dF.equals(INFO_FLAVOR);
    }

    @Override
    public Object getTransferData(DataFlavor dF) throws UnsupportedFlavorException, IOException {
        if (dF.equals(INFO_FLAVOR)) {
            return this;
        }
        throw new UnsupportedFlavorException(dF);
    }

    @Override
    public Dimension getSize() {
        return this.sz;
    }

    @Override
    public void setSize(Dimension sz) {
        this.sz = sz;
    }

    public ISymbol getSymbol() {
        return this.symbol;
    }

    @Override
    public IContextMenuAction getDoubleClickAction() {
        if (this.symbol == null) {
            return null;
        }
        return new ChangeSymbolTocMenuEntry();
    }
}

