/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toc.actions;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.view.toc.AbstractTocContextMenuAction;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.app.project.documents.view.toc.actions.CopyPasteLayersUtils;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.persistence.PersistentState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CutLayersTocMenuEntry
extends AbstractTocContextMenuAction {
    private static Logger logger = LoggerFactory.getLogger(CutLayersTocMenuEntry.class);

    @Override
    public String getGroup() {
        return "copyPasteLayer";
    }

    @Override
    public int getGroupOrder() {
        return 60;
    }

    @Override
    public int getOrder() {
        return 1;
    }

    @Override
    public String getText() {
        return PluginServices.getText((Object)this, (String)"cortar");
    }

    @Override
    public boolean isEnabled(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems.length >= 1 && this.isTocItemBranch(item)) {
            for (int i = 0; i < selectedItems.length; ++i) {
                if (!selectedItems[i].isEditing() && selectedItems[i].isAvailable()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void execute(ITocItem item, FLayer[] selectedItems) {
        PersistentState lyrs_state = null;
        try {
            FLayer[] tocopy = this.getLayersWithNoActiveAncestors(selectedItems);
            lyrs_state = CopyPasteLayersUtils.getAsFLayersPersistentState(tocopy, this.getMapContext());
            CopyPasteLayersUtils.saveToClipboard(lyrs_state);
            int option = JOptionPane.showConfirmDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"desea_borrar_la_capa"));
            if (option == 0) {
                CopyPasteLayersUtils.removeLayers(tocopy, this.getMapContext());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), Messages.getText((String)"No_ha_sido_posible_realizar_la_operacion") + "\n\n" + e.getMessage(), Messages.getText((String)"cortar"), 0);
            logger.info("While cutting layers.", (Throwable)e);
            return;
        }
    }

    private FLayer[] getLayersWithNoActiveAncestors(FLayer[] selItems) {
        ArrayList<FLayer> resp = new ArrayList<FLayer>();
        FLayer lyr = null;
        for (int i = 0; i < selItems.length; ++i) {
            lyr = selItems[i];
            if (this.hasActiveAncestor(lyr)) continue;
            resp.add(lyr);
        }
        return resp.toArray(new FLayer[0]);
    }

    private boolean hasActiveAncestor(FLayer lyr) {
        for (FLayers lyrs = lyr.getParentLayer(); lyrs != null; lyrs = lyrs.getParentLayer()) {
            if (lyrs.isActive()) {
                return true;
            }
            if (lyrs != lyrs.getParentLayer()) continue;
            return false;
        }
        return false;
    }
}

