/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toc.actions;

import java.awt.Component;
import javax.swing.JOptionPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.extension.ProjectExtension;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.documents.view.toc.AbstractTocContextMenuAction;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.app.project.documents.view.toc.actions.CopyPasteLayersUtils;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasteLayersTocMenuEntry
extends AbstractTocContextMenuAction {
    private static Logger logger = LoggerFactory.getLogger(PasteLayersTocMenuEntry.class);

    @Override
    public String getGroup() {
        return "copyPasteLayer";
    }

    @Override
    public int getGroupOrder() {
        return 60;
    }

    @Override
    public int getOrder() {
        return 2;
    }

    @Override
    public String getText() {
        return PluginServices.getText((Object)this, (String)"pegar");
    }

    @Override
    public boolean isEnabled(ITocItem item, FLayer[] selectedItems) {
        FLayer lyr;
        if (this.isTocItemBranch(item) ? (lyr = this.getNodeLayer(item)) instanceof FLayers : !this.isTocItemLeaf(item) && this.getNodeLayer(item) == null) {
            return !CopyPasteLayersUtils.isClipboardEmpty();
        }
        return false;
    }

    private FLayers getFLayersFromClipboard() {
        FLayers resp = null;
        try {
            resp = CopyPasteLayersUtils.getClipboardAsFLayers();
        }
        catch (PersistenceException e) {
            ApplicationLocator.getManager().message(Messages.getText((String)"_Clipboard_error"), 0);
            resp = null;
        }
        return resp;
    }

    @Override
    public void execute(ITocItem item, FLayer[] selectedItems) {
        FLayers target_root;
        FLayers clipboard_root = this.getFLayersFromClipboard();
        if (clipboard_root == null) {
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), Messages.getText((String)"No_ha_sido_posible_realizar_la_operacion"), Messages.getText((String)"pegar"), 0);
            logger.info("Unable to parse clipboard as flayers");
            return;
        }
        if (this.isTocItemBranch(item)) {
            target_root = (FLayers)this.getNodeLayer(item);
        } else if (this.getNodeLayer(item) == null) {
            target_root = this.getMapContext().getLayers();
        } else {
            return;
        }
        this.getMapContext().beginAtomicEvent();
        boolean isOK = CopyPasteLayersUtils.addLayers(clipboard_root, target_root);
        this.getMapContext().endAtomicEvent();
        if (isOK) {
            this.getMapContext().invalidate();
            Project project = ((ProjectExtension)PluginServices.getExtension(ProjectExtension.class)).getProject();
            project.setModified(true);
        }
    }
}

