/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toolListeners;

import java.awt.Image;
import java.text.NumberFormat;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiFrame.MainFrame;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Behavior.LineGeometry;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.MeasureEvent;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.AngleListener;

public class AngleGeometryListener
implements AngleListener {
    private final MapControl mapCtrl;
    private MeasureEvent event;
    private final Image cursorImg = PluginServices.getIconTheme().get("cursor-info-by-point").getImage();
    private GeometryManager geomManager = GeometryLocator.getGeometryManager();

    public AngleGeometryListener(MapControl mc) {
        this.mapCtrl = mc;
    }

    public void point(PointEvent event) throws BehaviorException {
    }

    private void showAngleStatusBar(double angle) {
        MainFrame mF = PluginServices.getMainFrame();
        if (mF != null) {
            double bigAngle;
            double smallAngle;
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(2);
            if (angle >= 180.0) {
                smallAngle = angle - 180.0;
                bigAngle = 180.0 - smallAngle;
            } else {
                smallAngle = angle;
                bigAngle = 180.0 - smallAngle;
            }
            if (smallAngle > bigAngle) {
                double temp = bigAngle;
                bigAngle = smallAngle;
                smallAngle = temp;
            }
            mF.getStatusBar().setMessage("4", "Ang.1=" + nf.format(smallAngle));
            mF.getStatusBar().setMessage("5", "Ang.2=" + nf.format(bigAngle));
        }
    }

    public void pointDoubleClick(PointEvent event) throws BehaviorException {
    }

    public Image getImageCursor() {
        return this.cursorImg;
    }

    public boolean cancelDrawing() {
        return false;
    }

    public double angle(LineGeometry line1, LineGeometry line2, Point cuadrantPoint) {
        double angle = 0.0;
        try {
            angle = line1.angleWith(line2, cuadrantPoint);
            this.showAngleStatusBar(angle);
        }
        catch (Exception ex) {
            this.showAngleStatusBar(0.0);
        }
        return angle;
    }
}

