/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.view.toolListeners;

import java.awt.Image;
import java.awt.geom.Point2D;
import java.text.NumberFormat;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiFrame.MainFrame;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusBarListener
implements PointListener {
    private static Logger logger = LoggerFactory.getLogger(StatusBarListener.class);
    private static final String DEGREES_FORMAT = "%-%d\u00b0 %m\u2032 %.2s\u2033";
    private MapControl mapControl = null;
    private NumberFormat nf = null;
    private static long lastLogTime = 0L;

    public StatusBarListener(MapControl mc) {
        this.mapControl = mc;
        this.nf = NumberFormat.getInstance();
        this.nf.setMaximumFractionDigits(2);
    }

    public Image getImageCursor() {
        return null;
    }

    public boolean cancelDrawing() {
        return false;
    }

    public void point(PointEvent event) throws BehaviorException {
        String[] axisText = new String[]{"X = ", "Y = "};
        Point2D p = this.mapControl.getMapContext().getViewPort().toMapPoint(event.getPoint());
        this.setFractionDigits(p);
        axisText = this.setCoorDisplayText(axisText);
        MainFrame mF = PluginServices.getMainFrame();
        if (mF != null) {
            mF.getStatusBar().setMessage("units", PluginServices.getText((Object)this, (String)MapContext.getDistanceNames()[this.mapControl.getMapContext().getViewPort().getDistanceUnits()]));
            IProjection proj = this.mapControl.getViewPort().getProjection();
            mF.getStatusBar().setMessage("projection", proj == null ? "" : proj.getAbrev());
            String[] coords = this.getCoords(p);
            mF.getStatusBar().setMessage("x", axisText[0] + coords[0]);
            mF.getStatusBar().setMessage("y", axisText[1] + coords[1]);
        }
    }

    public void setFractionDigits(Point2D p) {
        IProjection iProj = this.mapControl.getMapContext().getProjection();
        if (iProj != null && !iProj.isProjected()) {
            this.nf.setMaximumFractionDigits(8);
        } else {
            this.nf.setMaximumFractionDigits(2);
        }
    }

    public String[] setCoorDisplayText(String[] axisText) {
        IProjection iProj = this.mapControl.getMapContext().getProjection();
        if (iProj == null) {
            axisText[0] = "";
            axisText[1] = "";
        } else if (!iProj.isProjected() || MapContext.getDistanceNames()[this.mapControl.getMapContext().getViewPort().getDistanceUnits()].equals("Grados")) {
            axisText[0] = "Lon = ";
            axisText[1] = "Lat = ";
        } else {
            axisText[0] = "X = ";
            axisText[1] = "Y = ";
        }
        return axisText;
    }

    public String[] getCoords(Point2D p) {
        String[] coords = new String[2];
        IProjection iProj = this.mapControl.getMapContext().getProjection();
        if (!iProj.isProjected()) {
            coords[0] = String.valueOf(GeometryUtils.formatCoordinate((String)DEGREES_FORMAT, (double)p.getX()));
            coords[1] = String.valueOf(GeometryUtils.formatCoordinate((String)DEGREES_FORMAT, (double)p.getY()));
        } else {
            double[] trans2Meter = MapContext.getDistanceTrans2Meter();
            if (PluginServices.getText((Object)this, (String)MapContext.getDistanceNames()[this.mapControl.getViewPort().getDistanceUnits()]).equals(PluginServices.getText((Object)this, (String)"Grados"))) {
                Point2D pgeo = null;
                try {
                    pgeo = iProj.toGeo(p);
                    coords[0] = String.valueOf(GeometryUtils.formatCoordinate((String)DEGREES_FORMAT, (double)pgeo.getX()));
                    coords[1] = String.valueOf(GeometryUtils.formatCoordinate((String)DEGREES_FORMAT, (double)pgeo.getY()));
                }
                catch (Exception exc) {
                    if (System.currentTimeMillis() - lastLogTime > 5000L) {
                        lastLogTime = System.currentTimeMillis();
                        logger.info("Error: Unable to unproject coordinates: " + p);
                    }
                    coords[0] = "-";
                    coords[1] = "-";
                }
            } else {
                if (PluginServices.getText((Object)this, (String)MapContext.getDistanceNames()[this.mapControl.getViewPort().getMapUnits()]).equals(PluginServices.getText((Object)this, (String)"Grados"))) {
                    this.mapControl.getViewPort().setMapUnits(1);
                }
                coords[0] = String.valueOf(this.nf.format(p.getX() / trans2Meter[this.mapControl.getViewPort().getDistanceUnits()] * trans2Meter[this.mapControl.getViewPort().getMapUnits()]));
                coords[1] = String.valueOf(this.nf.format(p.getY() / trans2Meter[this.mapControl.getViewPort().getDistanceUnits()] * trans2Meter[this.mapControl.getViewPort().getMapUnits()]));
            }
        }
        return coords;
    }

    public void pointDoubleClick(PointEvent event) throws BehaviorException {
    }
}

