/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.serverexplorer.filesystem.swing;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class FilesystemExplorerWizardTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -1289509561088757725L;
    private static final int COLUMNS = 2;
    private static final int COLUMN_STORE_PARAMETERS = 0;
    private static final int COLUMN_TILED = 1;
    public static final String COLUMN_STORE_PARAMETERS_NAME = "Fichero";
    public static final String COLUMN_TILED_NAME = "_tiled";
    private List<FilesystemStoreParametersToLoad> data = new ArrayList<FilesystemStoreParametersToLoad>();

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return FilesystemStoreParametersToLoad.class;
            }
            case 1: {
                return Boolean.class;
            }
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public Object getValueAt(int i, int j) {
        if (i < this.data.size()) {
            FilesystemStoreParametersToLoad filesystemStoreParametersToLoad = this.data.get(i);
            switch (j) {
                case 0: {
                    return filesystemStoreParametersToLoad.getParameters();
                }
                case 1: {
                    return filesystemStoreParametersToLoad.isTiled();
                }
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int col) {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        if (col < 2) {
            switch (col) {
                case 0: {
                    return i18nManager.getTranslation(COLUMN_STORE_PARAMETERS_NAME);
                }
                case 1: {
                    return i18nManager.getTranslation(COLUMN_TILED_NAME);
                }
            }
        }
        throw new IndexOutOfBoundsException("Column '" + col + "' > " + 2);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 1 && this.isEditableTiled(row);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (row < this.data.size() && col < 2) {
            FilesystemStoreParametersToLoad filesystemStoreParametersToLoad = this.data.get(row);
            switch (col) {
                case 0: {
                    if (value == null || !(value instanceof FilesystemStoreParameters)) {
                        throw new IllegalArgumentException("The object '" + value.toString() + "' must be a FilesystemStoreParameters.");
                    }
                    filesystemStoreParametersToLoad.setParameters((FilesystemStoreParameters)value);
                    break;
                }
                case 1: {
                    if (value == null) {
                        filesystemStoreParametersToLoad.setTiled(false);
                        break;
                    }
                    if (!(value instanceof Boolean)) {
                        throw new IllegalArgumentException("The object '" + value.toString() + "' must be a Boolean.");
                    }
                    filesystemStoreParametersToLoad.setTiled((Boolean)value);
                    break;
                }
            }
        }
    }

    public void add(FilesystemStoreParameters fileParams) {
        DataManager dataManager = DALLocator.getDataManager();
        DataStoreProviderFactory factory = dataManager.getStoreProviderFactory(((DataStoreParameters)fileParams).getDataStoreName());
        boolean editable = false;
        boolean tiled = false;
        if (factory != null) {
            if (factory.getClass().getSimpleName().equalsIgnoreCase("TileProviderFactory")) {
                editable = false;
                tiled = true;
            } else {
                switch (factory.isTiledSupported()) {
                    case 2: {
                        editable = false;
                        tiled = false;
                        break;
                    }
                    case 1: {
                        editable = true;
                        tiled = factory.worksBestTiled() == 1;
                        break;
                    }
                    case 0: {
                        editable = false;
                        tiled = false;
                        break;
                    }
                }
            }
        }
        FilesystemStoreParametersToLoad filesystemStoreParametersToLoad = new FilesystemStoreParametersToLoad(fileParams, tiled, editable);
        this.data.add(filesystemStoreParametersToLoad);
    }

    public void add(List<FilesystemStoreParameters> listFileParams) {
        for (FilesystemStoreParameters filesystemStoreParameters : listFileParams) {
            this.add(filesystemStoreParameters);
        }
    }

    public void remove(int row) {
        this.data.remove(row);
    }

    public FilesystemStoreParameters getParams(int row) {
        return this.data.get(row).getParameters();
    }

    public boolean isTiled(int row) {
        return this.data.get(row).isTiled();
    }

    public boolean isEditableTiled(int row) {
        return this.data.get(row).isEditable();
    }

    public void up(int row) {
        if (row > 0 && row < this.data.size()) {
            FilesystemStoreParametersToLoad aux = this.data.get(row - 1);
            this.data.set(row - 1, this.data.get(row));
            this.data.set(row, aux);
        }
    }

    public void down(int row) {
        if (row >= 0 && row < this.data.size() - 1) {
            FilesystemStoreParametersToLoad aux = this.data.get(row);
            this.data.set(row, this.data.get(row + 1));
            this.data.set(row + 1, aux);
        }
    }

    public DataStoreParameters[] getParameters() {
        ArrayList<FilesystemStoreParameters> result = new ArrayList<FilesystemStoreParameters>();
        for (FilesystemStoreParametersToLoad rowData : this.data) {
            result.add(rowData.getParameters());
        }
        return result.toArray(new DataStoreParameters[0]);
    }

    public boolean isTiled(DataStoreParameters parameters) {
        for (FilesystemStoreParametersToLoad filesystemStoreParametersToLoad : this.data) {
            if (filesystemStoreParametersToLoad.getParameters() != parameters) continue;
            return filesystemStoreParametersToLoad.isTiled();
        }
        return false;
    }

    public static class FilesystemStoreParametersToLoad {
        private FilesystemStoreParameters params;
        private boolean tiled;
        private boolean editable = false;

        public FilesystemStoreParametersToLoad(FilesystemStoreParameters params) {
            this.setParameters(params);
        }

        public FilesystemStoreParametersToLoad(FilesystemStoreParameters params, boolean tiled, boolean editable) {
            this.setParameters(params);
            this.setTiled(tiled);
            this.editable = editable;
        }

        FilesystemStoreParameters getParameters() {
            return this.params;
        }

        public void setParameters(FilesystemStoreParameters file) {
            this.params = file;
        }

        public boolean isTiled() {
            return this.tiled;
        }

        public void setTiled(boolean tiled) {
            this.tiled = tiled;
        }

        public boolean isEditable() {
            return this.editable;
        }
    }
}

