/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.serverexplorer.filesystem.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TiledCellRenderer
extends JPanel
implements TableCellRenderer {
    private static final long serialVersionUID = 3875203211014535067L;
    private JCheckBox checkBox = new JCheckBox();
    private static final Logger LOGGER = LoggerFactory.getLogger(TiledCellRenderer.class);

    public TiledCellRenderer() {
        super(new BorderLayout());
        this.checkBox.setOpaque(false);
        this.checkBox.setHorizontalAlignment(0);
        this.add((Component)this.checkBox, "Center");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean booleanValue;
        if (isSelected) {
            this.checkBox.setForeground(table.getSelectionForeground());
            this.checkBox.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.checkBox.setForeground(table.getForeground());
            this.checkBox.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        try {
            booleanValue = (Boolean)value;
        }
        catch (Exception ex) {
            booleanValue = false;
        }
        boolean cellEditable = table.getModel().isCellEditable(row, column);
        if (!cellEditable && !booleanValue) {
            this.checkBox.setVisible(false);
        } else {
            this.checkBox.setVisible(true);
        }
        this.checkBox.setEnabled(cellEditable);
        this.checkBox.setSelected(value != null && booleanValue);
        return this;
    }
}

