/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib;

import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gvsig.dwg.lib.DwgClass;
import org.gvsig.dwg.lib.DwgClass2004;
import org.gvsig.dwg.lib.DwgHandleReference;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.DwgObjectOffset;
import org.gvsig.dwg.lib.DwgSectionOffset;
import org.gvsig.dwg.lib.DwgVersionNotSupportedException;
import org.gvsig.dwg.lib.IDwg3DTestable;
import org.gvsig.dwg.lib.IDwgBlockMember;
import org.gvsig.dwg.lib.IDwgExtrusionable;
import org.gvsig.dwg.lib.IDwgPolyline;
import org.gvsig.dwg.lib.objects.DwgBlockHeader;
import org.gvsig.dwg.lib.objects.DwgInsert;
import org.gvsig.dwg.lib.objects.DwgLayer;
import org.gvsig.dwg.lib.readers.DwgFileV12Reader;
import org.gvsig.dwg.lib.readers.DwgFileV14Reader;
import org.gvsig.dwg.lib.readers.DwgFileV15Reader;
import org.gvsig.dwg.lib.readers.DwgFileVR2004Reader;
import org.gvsig.dwg.lib.readers.IDwgFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwgFile {
    private static HashMap acadVersions = new HashMap();
    private static Logger logger;
    private String fileName;
    private String dwgVersion;
    private ArrayList dwgSectionOffsets;
    private Map headerVars;
    private ArrayList dwgObjectOffsets;
    private List dwgObjects;
    private HashMap handle_objects;
    private ArrayList dwgClasses;
    private HashMap layerTable;
    private IDwgFileReader dwgReader;
    private boolean dwg3DFile = false;
    private ByteBuffer bb;
    private List dwgPolylines;
    private List insertList;
    private List blockList;

    public DwgFile(String fileName) {
        this.fileName = fileName;
        this.dwgSectionOffsets = new ArrayList();
        this.dwgObjectOffsets = new ArrayList();
        this.headerVars = new HashMap();
        this.dwgClasses = new ArrayList();
        this.dwgObjects = new ArrayList();
        this.handle_objects = new HashMap();
        this.layerTable = new HashMap();
        this.dwgPolylines = new ArrayList();
        this.insertList = new ArrayList();
        this.blockList = new ArrayList();
    }

    public String getDwgVersion() {
        return this.dwgVersion;
    }

    public void read() throws IOException, DwgVersionNotSupportedException {
        this.setDwgVersion();
        if (this.dwgVersion.equalsIgnoreCase("Autocad R2000, R2000i, R2002")) {
            this.dwgReader = new DwgFileV15Reader();
        } else if (this.dwgVersion.equalsIgnoreCase("Autocad pre-R14") || this.dwgVersion.equalsIgnoreCase("Autocad R14") || this.dwgVersion.equalsIgnoreCase("Autocad R13")) {
            this.dwgReader = new DwgFileV14Reader();
        } else if (this.dwgVersion.equalsIgnoreCase("Autocad R2004, R2005, R2006")) {
            this.dwgReader = new DwgFileVR2004Reader();
        } else if (this.dwgVersion.equalsIgnoreCase("Autocad R12") || this.dwgVersion.equalsIgnoreCase("Autocad pre-R13 a") || this.dwgVersion.equalsIgnoreCase("Autocad pre-R13 b")) {
            boolean isR13 = true;
            if (this.dwgVersion.equalsIgnoreCase("Autocad R12")) {
                isR13 = false;
            }
            this.dwgReader = new DwgFileV12Reader(isR13);
        } else {
            DwgVersionNotSupportedException exception = new DwgVersionNotSupportedException("Version de DWG no soportada");
            exception.setDwgVersion(this.dwgVersion);
            throw exception;
        }
        try {
            this.dwgReader.read(this, this.bb);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error leyendo dwg");
        }
    }

    private void setDwgVersion() throws IOException {
        File file = new File(this.fileName);
        FileInputStream fileInputStream = new FileInputStream(file);
        FileChannel fileChannel = fileInputStream.getChannel();
        long channelSize = fileChannel.size();
        this.bb = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, channelSize);
        byte[] versionBytes = new byte[]{this.bb.get(0), this.bb.get(1), this.bb.get(2), this.bb.get(3), this.bb.get(4), this.bb.get(5)};
        ByteBuffer versionByteBuffer = ByteBuffer.wrap(versionBytes);
        String[] bs = new String[versionByteBuffer.capacity()];
        String versionString = "";
        for (int i = 0; i < versionByteBuffer.capacity(); ++i) {
            bs[i] = new String(new byte[]{versionByteBuffer.get(i)});
            versionString = versionString + bs[i];
        }
        String version = (String)acadVersions.get(versionString);
        if (version == null) {
            version = "Unknown Dwg format";
        }
        this.dwgVersion = version;
    }

    public void setHeader(String key, Object value) {
        this.headerVars.put(key, value);
    }

    public Object getHeader(String key) {
        return this.headerVars.get(key);
    }

    protected void addDwgLayer(DwgLayer dwgLayer) {
        this.layerTable.put(new Integer(dwgLayer.getHandle().getOffset()), dwgLayer);
    }

    private void printInfoOfAObject(DwgObject entity) {
        logger.info("index = " + entity.getIndex() + " entity.type = " + entity.type + " entityClassName = " + entity.getClass().getName());
        logger.info("handleCode = " + entity.getHandle().getCode());
        logger.info("entityLayerHandle = " + entity.getHandle().getOffset());
        if (entity.hasLayerHandle()) {
            logger.info("layerHandleCode = " + entity.getLayerHandle().getCode());
            logger.info("layerHandle = " + entity.getLayerHandle().getOffset());
        }
        if (entity.hasSubEntityHandle()) {
            logger.info("subEntityHandleCode = " + entity.getSubEntityHandle().getCode());
            logger.info("subEntityHandle = " + entity.getSubEntityHandle().getOffset());
        }
        if (entity.hasNextHandle()) {
            logger.info("nextHandleCode = " + entity.getNextHandle().getCode());
            logger.info("nextHandle = " + entity.getNextHandle().getOffset());
        }
        if (entity.hasPreviousHandle()) {
            logger.info("previousHandleCode = " + entity.getPreviousHandle().getCode());
            logger.info("previousHandle = " + entity.getPreviousHandle().getOffset());
        }
        if (entity.hasXDicObjHandle()) {
            logger.info("xDicObjHandleCode = " + entity.getXDicObjHandle());
            logger.info("xDicObjHandle = " + entity.getXDicObjHandle());
        }
        if (entity.hasReactorsHandles()) {
            ArrayList reactorsHandles = entity.getReactorsHandles();
            int size = reactorsHandles.size();
            logger.info("NUMERO DE reactors = " + size);
            for (int i = 0; i < size; ++i) {
                DwgHandleReference hr = (DwgHandleReference)reactorsHandles.get(i);
                logger.info("reactorHandleCode = " + hr.getCode());
                logger.info(" reactorHandle = " + hr.getOffset());
            }
        }
    }

    public DwgLayer getDwgLayer(DwgObject entity) {
        DwgHandleReference handle = entity.getLayerHandle();
        if (handle == null) {
            return null;
        }
        int handleCode = handle.getCode();
        int entityLayerHandle = entity.getLayerHandle().getOffset();
        int layerHandle = -1;
        switch (handleCode) {
            case 4: {
                int nextHandleCode;
                if (entity.hasNextHandle()) {
                    nextHandleCode = entity.getNextHandle().getCode();
                    if (nextHandleCode != 5) break;
                    layerHandle = entity.getNextHandle().getOffset();
                    break;
                }
                layerHandle = entity.getLayerHandle().getOffset();
                break;
            }
            case 5: {
                layerHandle = entity.getLayerHandle().getOffset();
                break;
            }
            case 8: {
                int nextHandleCode;
                if (entity.hasNextHandle()) {
                    nextHandleCode = entity.getNextHandle().getCode();
                    if (nextHandleCode != 5) break;
                    layerHandle = entity.getNextHandle().getOffset();
                    break;
                }
                layerHandle = entity.getHandle().getOffset() - 1;
                break;
            }
            case 12: {
                int nextHandleCode;
                if (entity.hasNextHandle()) {
                    nextHandleCode = entity.getNextHandle().getCode();
                    if (nextHandleCode != 5) break;
                    layerHandle = entity.getNextHandle().getOffset();
                    break;
                }
                layerHandle = entity.getHandle().getOffset() - entity.getLayerHandle().getOffset() + 1;
                break;
            }
        }
        if (layerHandle != -1) {
            for (DwgLayer lyr : this.layerTable.values()) {
                int lyrHdl = lyr.getHandle().getOffset();
                if (lyrHdl != layerHandle) continue;
                return lyr;
            }
        }
        return null;
    }

    public DwgObject getDwgSuperEntity(DwgObject entity) {
        if (entity.hasSubEntityHandle()) {
            DwgObject object;
            int handleCode = entity.subEntityHandle.getCode();
            int offset = entity.subEntityHandle.getOffset();
            int handle = -1;
            switch (handleCode) {
                case 4: 
                case 5: {
                    handle = offset;
                    break;
                }
                case 8: {
                    handle = entity.getHandle().getOffset() - 1;
                    break;
                }
                case 10: {
                    handle = entity.getHandle().getOffset() + offset;
                    break;
                }
                case 12: {
                    handle = entity.getHandle().getOffset() - offset;
                    break;
                }
                default: {
                    logger.warn("DwgObject.getDwgSuperEntity: handleCode " + handleCode + " no implementado. offset = " + offset);
                }
            }
            if (handle != -1 && (object = this.getDwgObjectFromHandle(handle)) != null) {
                return object;
            }
        }
        return null;
    }

    public String getLayerName(DwgObject entity) {
        DwgLayer dwgLayer = this.getDwgLayer(entity);
        if (dwgLayer == null) {
            return "";
        }
        return dwgLayer.getName();
    }

    public int getColorByLayer(DwgObject entity) {
        DwgLayer dwgLyr = this.getDwgLayer(entity);
        int colorByLayer = dwgLyr == null ? 0 : dwgLyr.getColor();
        return colorByLayer;
    }

    public void calculateGisModelDwgPolylines() {
        if (!(this.dwgReader instanceof DwgFileV12Reader)) {
            for (int i = 0; i < this.dwgPolylines.size(); ++i) {
                DwgObject pol = (DwgObject)this.dwgPolylines.get(i);
                if (!(pol instanceof IDwgPolyline)) continue;
                ((IDwgPolyline)((Object)pol)).calculateGisModel(this);
            }
        }
    }

    public void blockManagement2() {
        Iterator it = null;
        if (!(this.dwgReader instanceof DwgFileV12Reader)) {
            it = this.dwgObjects.iterator();
            int i = 0;
            while (it.hasNext()) {
                DwgObject entity = (DwgObject)it.next();
                DwgObject superEnt = this.getDwgSuperEntity(entity);
                if (!(superEnt instanceof DwgBlockHeader)) continue;
                DwgBlockHeader blk = (DwgBlockHeader)superEnt;
                blk.addObject(entity);
                it.remove();
                ++i;
            }
        }
        for (DwgInsert insert : this.insertList) {
            if (insert.isProcessed()) continue;
            insert.setProcessed(true);
            double[] p = insert.getInsertionPoint();
            Point2D.Double point = new Point2D.Double(p[0], p[1]);
            double[] scale = insert.getScale();
            double rot = insert.getRotation();
            int blockHandle = insert.getBlockHeaderHandle().getOffset();
            this.manageInsert2(point, scale, rot, blockHandle, this.dwgObjects, this.handle_objects);
        }
    }

    public void manageInsert2(Point2D insPoint, double[] scale, double rot, int bHandle, List dwgObjectsWithoutBlocks, Map handleObjectsWithoutBlocks) {
        DwgObject object = (DwgObject)this.handle_objects.get(new Integer(bHandle));
        if (object == null) {
            logger.error("No hemos encontrado el BlockHeader cuyo handle es " + bHandle);
            return;
        }
        if (!(object instanceof DwgBlockHeader)) {
            logger.error("handle incorrecto." + object.getClass().getName() + " no es un blockheader");
            return;
        }
        DwgBlockHeader blockHeader = (DwgBlockHeader)object;
        double[] bPoint = blockHeader.getBasePoint();
        String bname = blockHeader.getName();
        if (bname.startsWith("*")) {
            return;
        }
        ArrayList entities = blockHeader.getObjects();
        if (entities.size() == 0) {
            logger.warn("El bloque " + blockHeader.getName() + " no tiene ninguna entidad");
        }
        for (DwgObject obj : entities) {
            this.manageBlockEntity(obj, bPoint, insPoint, scale, rot, dwgObjectsWithoutBlocks, handleObjectsWithoutBlocks);
        }
    }

    public int getIndexOf(DwgObject dwgObject) {
        return this.dwgObjects.indexOf(dwgObject);
    }

    private void manageBlockEntity(DwgObject entity, double[] bPoint, Point2D insPoint, double[] scale, double rot, List dwgObjectsWithoutBlocks, Map handleObjectsWithoutBlocks) {
        if (entity instanceof IDwgBlockMember) {
            IDwgBlockMember blockMember = (IDwgBlockMember)((Object)entity);
            blockMember.transform2Block(bPoint, insPoint, scale, rot, dwgObjectsWithoutBlocks, handleObjectsWithoutBlocks, this);
        }
    }

    public void addDwgSectionOffset(String key, int seek, int size) {
        DwgSectionOffset dso = new DwgSectionOffset(key, seek, size);
        this.dwgSectionOffsets.add(dso);
    }

    public int getDwgSectionOffset(String key) {
        int offset = 0;
        for (int i = 0; i < this.dwgSectionOffsets.size(); ++i) {
            DwgSectionOffset dso = (DwgSectionOffset)this.dwgSectionOffsets.get(i);
            String ikey = dso.getKey();
            if (!key.equals(ikey)) continue;
            offset = dso.getSeek();
            break;
        }
        return offset;
    }

    public void addDwgObjectOffset(int handle, int offset) {
        DwgObjectOffset doo = new DwgObjectOffset(handle, offset);
        this.dwgObjectOffsets.add(doo);
    }

    public void addDwgObject(DwgObject dwgObject) {
        this.dwgObjects.add(dwgObject);
        if (dwgObject instanceof DwgLayer) {
            this.addDwgLayer((DwgLayer)dwgObject);
        }
        if (dwgObject instanceof IDwgExtrusionable) {
            ((IDwgExtrusionable)((Object)dwgObject)).applyExtrussion();
        }
        if (dwgObject instanceof IDwgPolyline) {
            this.dwgPolylines.add(dwgObject);
        }
        if (dwgObject instanceof IDwg3DTestable && !this.isDwg3DFile()) {
            this.setDwg3DFile(((IDwg3DTestable)((Object)dwgObject)).has3DData());
        }
        if (dwgObject instanceof DwgInsert) {
            this.insertList.add(dwgObject);
        }
        if (dwgObject instanceof DwgBlockHeader) {
            this.blockList.add(dwgObject);
        }
        this.handle_objects.put(new Integer(dwgObject.getHandle().getOffset()), dwgObject);
    }

    public DwgObject getDwgObject(int index) {
        return (DwgObject)this.dwgObjects.get(index);
    }

    public DwgObject getDwgObjectFromHandle(int handle) {
        return (DwgObject)this.handle_objects.get(new Integer(handle));
    }

    public void addDwgClass(DwgClass dwgClass) {
        this.dwgClasses.add(dwgClass);
    }

    public void addDwgClass(DwgClass2004 dwgClass) {
        this.dwgClasses.add(dwgClass);
    }

    public void printClasses() {
        logger.info("#### CLASSES ####");
        for (int i = 0; i < this.dwgClasses.size(); ++i) {
            DwgClass clazz = (DwgClass)this.dwgClasses.get(i);
            logger.info(clazz.toString());
        }
        logger.info("#############");
    }

    public List getDwgClasses() {
        return this.dwgClasses;
    }

    public ArrayList getDwgObjectOffsets() {
        return this.dwgObjectOffsets;
    }

    public List getDwgObjects() {
        return this.dwgObjects;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isDwg3DFile() {
        return this.dwg3DFile;
    }

    public void setDwg3DFile(boolean dwg3DFile) {
        this.dwg3DFile = dwg3DFile;
    }

    static {
        acadVersions.put("AC1004", "Autocad R9");
        acadVersions.put("AC1006", "Autocad R10");
        acadVersions.put("AC1007", "Autocad pre-R11");
        acadVersions.put("AC1007", "Autocad pre-R11");
        acadVersions.put("AC1008", "Autocad pre-R11b");
        acadVersions.put("AC1009", "Autocad R12");
        acadVersions.put("AC1010", "Autocad pre-R13 a");
        acadVersions.put("AC1011", "Autocad pre-R13 b");
        acadVersions.put("AC1012", "Autocad R13");
        acadVersions.put("AC1013", "Autocad pre-R14");
        acadVersions.put("AC1014", "Autocad R14");
        acadVersions.put("AC1500", "Autocad pre-2000");
        acadVersions.put("AC1015", "Autocad R2000, R2000i, R2002");
        acadVersions.put("AC402a", "Autocad pre-2004a");
        acadVersions.put("AC402b", "Autocad pre-2004b");
        acadVersions.put("AC1018", "Autocad R2004, R2005, R2006");
        acadVersions.put("AC1021", "Autocad R2007");
        logger = LoggerFactory.getLogger((String)DwgFile.class.getName());
    }
}

