/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.objects;

import org.gvsig.dwg.lib.DwgHandleReference;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.IDwg2FMap;
import org.gvsig.dwg.lib.IDwg3DTestable;
import org.gvsig.dwg.lib.IDwgExtrusionable;
import org.gvsig.dwg.lib.util.AcadExtrusionCalculator;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Point;

public class DwgMText
extends DwgObject
implements IDwgExtrusionable,
IDwg3DTestable,
IDwg2FMap {
    private double[] insertionPoint;
    private double[] extrusion;
    private double[] xAxisDirection;
    private double width;
    private double height;
    private int attachment;
    private int drawingDir;
    private double extHeight;
    private double extWidth;
    private String text;
    private int lineSpacingStyle;
    private double lineSpacingFactor;
    private DwgHandleReference styleHandle = null;

    public DwgMText(int index) {
        super(index);
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public double[] getInsertionPoint() {
        return this.insertionPoint;
    }

    public void setInsertionPoint(double[] insertionPoint) {
        this.insertionPoint = insertionPoint;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double[] getExtrusion() {
        return this.extrusion;
    }

    public int getAttachment() {
        return this.attachment;
    }

    public void setAttachment(int attachment) {
        this.attachment = attachment;
    }

    public int getDrawingDir() {
        return this.drawingDir;
    }

    public void setDrawingDir(int drawingDir) {
        this.drawingDir = drawingDir;
    }

    public double getExtHeight() {
        return this.extHeight;
    }

    public void setExtHeight(double extHeight) {
        this.extHeight = extHeight;
    }

    public double getExtWidth() {
        return this.extWidth;
    }

    public void setExtWidth(double extWidth) {
        this.extWidth = extWidth;
    }

    public double getLineSpacingFactor() {
        return this.lineSpacingFactor;
    }

    public void setLineSpacingFactor(double lineSpacingFactor) {
        this.lineSpacingFactor = lineSpacingFactor;
    }

    public int getLineSpacingStyle() {
        return this.lineSpacingStyle;
    }

    public void setLineSpacingStyle(int lineSpacingStyle) {
        this.lineSpacingStyle = lineSpacingStyle;
    }

    public DwgHandleReference getStyleHandle() {
        return this.styleHandle;
    }

    public void setStyleHandle(DwgHandleReference styleHandle) {
        this.styleHandle = styleHandle;
    }

    public double[] getXAxisDirection() {
        return this.xAxisDirection;
    }

    public void setXAxisDirection(double[] axisDirection) {
        this.xAxisDirection = axisDirection;
    }

    public void setExtrusion(double[] extrusion) {
        this.extrusion = extrusion;
    }

    @Override
    public void applyExtrussion() {
        double[] mtextPoint = this.getInsertionPoint();
        double[] mtextExt = this.getExtrusion();
        mtextPoint = AcadExtrusionCalculator.extrude2(mtextPoint, mtextExt);
        this.setInsertionPoint(mtextPoint);
    }

    @Override
    public boolean has3DData() {
        return this.getInsertionPoint()[2] != 0.0;
    }

    @Override
    public double getZ() {
        return this.getInsertionPoint()[2];
    }

    @Override
    public Geometry toFMapGeometry(boolean is3DFile) throws CreateGeometryException {
        GeometryManager gMan = GeometryLocator.getGeometryManager();
        double[] p = this.getInsertionPoint();
        Point point = (Point)gMan.create(this.getGeometryType(), this.getGeometrySubType(is3DFile));
        point.setCoordinates(p);
        return point;
    }

    @Override
    public String toFMapString(boolean is3DFile) {
        if (is3DFile) {
            return "FPoint3D";
        }
        return "FPoint2D";
    }

    @Override
    public String toString() {
        return "MText";
    }

    @Override
    public Object clone() {
        DwgMText obj = new DwgMText(this.index);
        this.fill(obj);
        return obj;
    }

    @Override
    protected void fill(DwgObject obj) {
        super.fill(obj);
        DwgMText myObj = (DwgMText)obj;
        myObj.setAttachment(this.attachment);
        myObj.setDrawingDir(this.drawingDir);
        myObj.setExtHeight(this.extHeight);
        myObj.setExtrusion(this.extrusion);
        myObj.setExtWidth(this.extWidth);
        myObj.setHeight(this.extHeight);
        myObj.setInsertionPoint(this.insertionPoint);
        myObj.setLineSpacingFactor(this.lineSpacingFactor);
        myObj.setLineSpacingStyle(this.lineSpacingStyle);
        myObj.setStyleHandle(this.styleHandle);
        myObj.setText(this.text);
        myObj.setWidth(this.width);
        myObj.setXAxisDirection(this.xAxisDirection);
    }

    @Override
    public int getGeometryType() {
        return 1;
    }
}

